/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.processors.cache.database.txdr.WalSender;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.TransactionalDrMXBean;

public class TransactionalDrMXBeanImpl
implements TransactionalDrMXBean {
    private final TransactionalDrProcessorImpl txdrProc;

    TransactionalDrMXBeanImpl(TransactionalDrProcessorImpl txdrProc) {
        assert (txdrProc != null);
        this.txdrProc = txdrProc;
    }

    public String clusterRole() {
        return this.txdrProc.localState().role().name();
    }

    public String replicationState() {
        return this.txdrProc.localState().state().name();
    }

    public long replicaTimeLag() {
        ReplicationSessionDescriptor locState = this.txdrProc.localState();
        return locState.role() == ClusterRole.REPLICA ? U.currentTimeMillis() - locState.lastSuccessfullyAppliedCutId() : -1L;
    }

    public long masterWalSenderSegmentsLag() {
        ReplicationSessionDescriptor locState = this.txdrProc.localState();
        WalSender walSnd = this.txdrProc.walSender();
        return locState.role() == ClusterRole.MASTER && walSnd != null ? walSnd.lastReadySegmentIndex() - locState.lastSuccessfullySentWalIndex() : -1L;
    }

    public boolean readOnly() {
        return this.txdrProc.localState().readOnly();
    }

    public long lastSuccessfullyAppliedCutId() {
        ReplicationSessionDescriptor locState = this.txdrProc.localState();
        return locState.role() == ClusterRole.REPLICA ? locState.lastSuccessfullyAppliedCutId() : -1L;
    }

    public boolean cutApplyingInProgress() {
        return this.txdrProc.cutApplyingInProgress();
    }
}

