/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.txdr.TopologyEventsSnapshot;

public class LocalConsistentCutData
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private static final int TOPOLOGY_CHANGED_FLAG_MASK = 1;
    private Set<GridCacheVersion> locTxs;
    private Map<GridCacheVersion, Set<GridCacheVersion>> dependentTxsGraph;
    private Map<Integer, Map<Integer, Long>> atomicUpdCntrs;
    private TopologyEventsSnapshot topEvtSnapshot;
    private byte flags;

    public LocalConsistentCutData(Set<GridCacheVersion> locTxs, Map<GridCacheVersion, Set<GridCacheVersion>> dependentTxsGraph) {
        this(locTxs, dependentTxsGraph, null);
    }

    public LocalConsistentCutData(Set<GridCacheVersion> locTxs, Map<GridCacheVersion, Set<GridCacheVersion>> dependentTxsGraph, Map<Integer, Map<Integer, Long>> atomicUpdCntrs) {
        this.locTxs = locTxs;
        this.dependentTxsGraph = dependentTxsGraph;
        this.atomicUpdCntrs = atomicUpdCntrs;
    }

    public LocalConsistentCutData() {
    }

    public Set<GridCacheVersion> localTxs() {
        return this.locTxs;
    }

    public Map<GridCacheVersion, Set<GridCacheVersion>> dependentTxsGraph() {
        return this.dependentTxsGraph;
    }

    public boolean topologyChanged() {
        return (this.flags & 1) != 0;
    }

    public void topologyChanged(boolean topChanged) {
        this.flags = topChanged ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    public TopologyEventsSnapshot topologyEventsSnapshot() {
        return this.topEvtSnapshot;
    }

    public void topologyEventsSnapshot(TopologyEventsSnapshot topEvtSnapshot) {
        this.topEvtSnapshot = topEvtSnapshot;
    }

    public Map<Integer, Map<Integer, Long>> atomicUpdateCounters() {
        return this.atomicUpdCntrs;
    }

    public byte getProtocolVersion() {
        return 2;
    }

    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection((ObjectOutput)out, this.locTxs);
        U.writeMap((ObjectOutput)out, this.dependentTxsGraph);
        out.writeObject(this.topEvtSnapshot);
        out.writeByte(this.flags);
        U.writeMap((ObjectOutput)out, this.atomicUpdCntrs);
    }

    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.locTxs = U.readSet((ObjectInput)in);
        this.dependentTxsGraph = U.readHashMap((ObjectInput)in);
        this.topEvtSnapshot = (TopologyEventsSnapshot)in.readObject();
        this.flags = in.readByte();
        if (protoVer >= 2) {
            this.atomicUpdCntrs = U.readHashMap((ObjectInput)in);
        }
    }

    public String toString() {
        return S.toString(LocalConsistentCutData.class, (Object)((Object)this));
    }
}

