/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskAdapter;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.ReplicationSessionDescriptor;
import org.gridgain.grid.internal.txdr.ReplicationState;
import org.gridgain.grid.internal.txdr.TransactionalDrGlobalStatus;
import org.jetbrains.annotations.Nullable;

public class GlobalReplicationStatusTask
extends ComputeTaskAdapter<Void, TransactionalDrGlobalStatus> {
    private static final long serialVersionUID = 0L;
    @IgniteInstanceResource
    protected IgniteEx ignite;

    @Nullable
    public Map<? extends ComputeJob, ClusterNode> map(List<ClusterNode> subgrid, @Nullable Void arg) throws IgniteException {
        HashMap<GlobalReplicationStatusJob, ClusterNode> jobs = new HashMap<GlobalReplicationStatusJob, ClusterNode>();
        Collection baselineNodes = this.ignite.context().discovery().discoCache().aliveBaselineNodes();
        Collection<Object> nodes = baselineNodes == null ? subgrid : baselineNodes;
        for (ClusterNode clusterNode : nodes) {
            jobs.put(new GlobalReplicationStatusJob(), clusterNode);
        }
        return jobs;
    }

    @Nullable
    public TransactionalDrGlobalStatus reduce(List<ComputeJobResult> results) throws IgniteException {
        boolean globalStatusInitialized = false;
        GlobalStatusBuilder builder = null;
        for (ComputeJobResult r : results) {
            ReplicationSessionDescriptor locState = (ReplicationSessionDescriptor)r.getData();
            if (locState == null) continue;
            if (!globalStatusInitialized) {
                globalStatusInitialized = true;
                builder = new GlobalStatusBuilder(locState.role(), locState.state(), locState.sessionId(), locState.readOnly());
            } else if (locState.role() != builder.role() || locState.state() != builder.state || locState.sessionId() != builder.bootstrapSesId()) {
                U.log((IgniteLogger)this.ignite.log(), (Object)"Collecting global transactional status during state transition.");
            }
            builder.mergeLocalState(r.getNode().consistentId(), locState);
        }
        return globalStatusInitialized ? builder.build() : null;
    }

    private static class GlobalStatusBuilder
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private ClusterRole role;
        private ReplicationState state;
        private long bootstrapSesId;
        private List<Long> successfullyAppliedCutIds = new ArrayList<Long>();
        private Map<Object, ReplicationSessionDescriptor> locStates = new HashMap<Object, ReplicationSessionDescriptor>();
        private final boolean isReadOnly;

        public GlobalStatusBuilder(ClusterRole role, ReplicationState state, long bootstrapSesId, boolean readOnly) {
            this.role = role;
            this.state = state;
            this.bootstrapSesId = bootstrapSesId;
            this.isReadOnly = readOnly;
        }

        public ClusterRole role() {
            return this.role;
        }

        public ReplicationState state() {
            return this.state;
        }

        public long bootstrapSesId() {
            return this.bootstrapSesId;
        }

        public GlobalStatusBuilder mergeLocalState(Object consistentId, ReplicationSessionDescriptor locState) {
            this.successfullyAppliedCutIds.add(Math.max(locState.lastGloballyAppliedCutId(), locState.sessionId()));
            this.locStates.put(consistentId, locState);
            return this;
        }

        public TransactionalDrGlobalStatus build() {
            long timeLag = 0L;
            long minAppliedCutId = 0L;
            if (this.role == ClusterRole.REPLICA) {
                minAppliedCutId = Collections.min(this.successfullyAppliedCutIds);
                timeLag = U.currentTimeMillis() - minAppliedCutId;
            }
            return new TransactionalDrGlobalStatus(this.role, this.state, this.bootstrapSesId, minAppliedCutId, timeLag, this.locStates, this.isReadOnly);
        }
    }

    public static class GlobalReplicationStatusJob
    extends ComputeJobAdapter {
        private static final long serialVersionUID = 0L;
        @IgniteInstanceResource
        protected IgniteEx ignite;

        public Object execute() throws IgniteException {
            if (this.ignite.context().txDr() instanceof TransactionalDrProcessorImpl) {
                TransactionalDrProcessorImpl txDr = (TransactionalDrProcessorImpl)this.ignite.context().txDr();
                return txDr.localState();
            }
            return null;
        }
    }
}

