/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.TrackingPageIsCorruptedException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.AbstractFullPageIdIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.PageIdIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FullPageIdIncrementalSnapshotIterable
extends AbstractFullPageIdIterable {
    FullPageIdIncrementalSnapshotIterable(GridCacheSharedContext<?, ?> sharedCtx, Map<Integer, Long> nextSnapshotTagsForCacheGrp, Map<Integer, Long> lastSuccessfulSnapshotIdsForCache, PartitionAllocationMap partStateMap) {
        super(sharedCtx, nextSnapshotTagsForCacheGrp, lastSuccessfulSnapshotIdsForCache, partStateMap);
    }

    @Override
    public PageIdIterable.CountingIterator<FullPageId> iterator() {
        return new FullPageIdIncrementalSnapshotIterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(@NotNull FullPageId fullId) {
        PagesAllocationRange pages;
        int grpId = fullId.groupId();
        long pageId = fullId.pageId();
        GroupPartitionId cachePartId = PartitionAllocationMap.createCachePartId((FullPageId)fullId);
        if (!this.partStateMap.containsKey(cachePartId)) {
            return false;
        }
        int idx = PageIdUtils.pageIndex((long)pageId);
        if (idx >= (pages = this.partStateMap.get(cachePartId)).getCurrAllocatedPageCnt()) {
            return false;
        }
        if (idx >= pages.getLastAllocatedPageCnt()) {
            return true;
        }
        if (idx == 0) {
            return true;
        }
        long trackingPage = this.io.trackingPageFor(pageId, this.realPageSize(grpId));
        if (trackingPage == pageId) {
            return false;
        }
        try (AbstractFullPageIdIterable.TrackingPageBufferScope ignored = this.borrowTrackingPage(grpId, trackingPage);){
            boolean bl = this.io.wasChanged(this.getCachedTrackingPage(), pageId, this.getCurrentSnapshotTag(grpId), this.getLastSuccessfulSnapshotTag(grpId), this.realPageSize(grpId));
            return bl;
        }
        catch (TrackingPageIsCorruptedException ex) {
            if (ex != TrackingPageIsCorruptedException.INSTANCE) {
                U.error((IgniteLogger)this.sharedCtx.logger(this.getClass()), (Object)("Corrupted nextSnapshotTag grpId=" + grpId + ", partition=" + PageIdUtils.partId((long)pageId) + ", trackingPageId=" + U.hexLong((long)trackingPage) + ", lastSavedTag=" + ex.lastTag() + ", nextSnapshotTag=" + ex.passedTag()), (Throwable)ex);
            }
            this.markCorruptedTrackingPage(trackingPage, grpId);
            return true;
        }
    }

    @Override
    @Nullable
    public FullPageId next(@Nullable FullPageId curPageFullId) {
        return this.next(curPageFullId, null);
    }

    @Nullable
    public FullPageId next(@Nullable FullPageId curPageFullId, @Nullable AtomicInteger progressCntr) {
        if (this.partStateMap.isEmpty()) {
            return null;
        }
        if (curPageFullId == null) {
            return this.nextStartPage(null);
        }
        GroupPartitionId curCachePartId = PartitionAllocationMap.createCachePartId((FullPageId)curPageFullId);
        PagesAllocationRange curAllocPagesRange = this.partStateMap.get(curCachePartId);
        int curTotalAllocatedPageCnt = curAllocPagesRange != null ? curAllocPagesRange.getCurrAllocatedPageCnt() : 0;
        int curMaxPageIdx = curTotalAllocatedPageCnt - 1;
        int curPageIdx = PageIdUtils.pageIndex((long)curPageFullId.pageId());
        if (curAllocPagesRange == null) {
            return this.nextStartPage(null);
        }
        if (curPageIdx == curMaxPageIdx) {
            if (progressCntr != null) {
                progressCntr.addAndGet(curAllocPagesRange.getCurrAllocatedPageCnt());
            }
            return this.nextStartPage(curCachePartId);
        }
        int prevSnapshotWrittenPage = curAllocPagesRange.getLastAllocatedPageCnt();
        return this.getNextId(curPageFullId, curTotalAllocatedPageCnt, curMaxPageIdx, prevSnapshotWrittenPage);
    }

    private FullPageId getNextId(@NotNull FullPageId curPageFullId, int curTotalAllocatedPageCnt, int curMaxPageIdx, int prevSnapshotWrittenPage) {
        int curGrpId;
        long trackingPage;
        int nextId;
        long curPageId = curPageFullId.pageId();
        int nextPageIdx = PageIdUtils.pageIndex((long)curPageId) + 1;
        long nextPageId = PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)nextPageIdx);
        do {
            Long founded;
            int index;
            if ((index = PageIdUtils.pageIndex((long)nextPageId)) > curMaxPageIdx) {
                return this.next(new FullPageId(PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)curMaxPageIdx), curPageFullId.groupId()));
            }
            curGrpId = curPageFullId.groupId();
            if (index >= prevSnapshotWrittenPage) {
                return new FullPageId(nextPageId, curGrpId);
            }
            trackingPage = this.io.trackingPageFor(nextPageId, this.realPageSize(curGrpId));
            if (trackingPage == nextPageId) {
                return this.next(new FullPageId(nextPageId, curGrpId));
            }
            long lastSuccessfulSnapshotTag = this.getLastSuccessfulSnapshotTag(curGrpId);
            try (AbstractFullPageIdIterable.TrackingPageBufferScope ignored = this.borrowTrackingPage(curGrpId, trackingPage);){
                founded = this.io.findNextChangedPage(this.getCachedTrackingPage(), nextPageId, this.getCurrentSnapshotTag(curGrpId), lastSuccessfulSnapshotTag, this.realPageSize(curGrpId));
            }
            catch (TrackingPageIsCorruptedException e) {
                if (e != TrackingPageIsCorruptedException.INSTANCE) {
                    U.error((IgniteLogger)this.sharedCtx.logger(this.getClass()), (Object)("Corrupted nextSnapshotTag grpId=" + curGrpId + ", partition=" + PageIdUtils.partId((long)nextPageId) + ", trackingPageId=" + U.hexLong((long)trackingPage) + ", lastSavedTag=" + e.lastTag() + ", nextSnapshotTag=" + e.passedTag()), (Throwable)e);
                }
                this.markCorruptedTrackingPage(trackingPage, curGrpId);
                return new FullPageId(nextPageId, curGrpId);
            }
            if (founded == null) continue;
            nextId = PageIdUtils.pageIndex((long)founded);
            if (nextId > prevSnapshotWrittenPage) {
                return new FullPageId(PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)prevSnapshotWrittenPage), curGrpId);
            }
            return new FullPageId(founded.longValue(), curGrpId);
        } while ((nextId = PageIdUtils.pageIndex((long)(nextPageId = PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)(PageIdUtils.pageIndex((long)trackingPage) + this.io.countOfPageToTrack(this.realPageSize(curPageFullId.groupId()))))))) < prevSnapshotWrittenPage || prevSnapshotWrittenPage >= curTotalAllocatedPageCnt);
        return new FullPageId(PageIdUtils.pageId((int)PageIdUtils.partId((long)curPageId), (byte)PageIdUtils.flag((long)curPageId), (int)prevSnapshotWrittenPage), curGrpId);
    }

    private FullPageId nextStartPage(@Nullable GroupPartitionId grpPartId) {
        for (int i = 0; i < this.partStateMap.size(); ++i) {
            GroupPartitionId groupPartitionId = grpPartId = grpPartId == null ? this.partStateMap.firstKey() : this.partStateMap.nextKey(grpPartId);
            if (grpPartId == null) {
                return null;
            }
            PagesAllocationRange range0 = this.partStateMap.get(grpPartId);
            assert (range0 != null);
            if (range0.getCurrAllocatedPageCnt() == 0) continue;
            return grpPartId.createFirstPageFullId();
        }
        assert (grpPartId == null && this.partStateMap.isEmpty() || this.partStateMap.nextKey(grpPartId) == null) : "Not all pages were tried [pageCounts=" + this.partStateMap + ", grpPartId=" + grpPartId + ']';
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.next(null) == null;
    }

    private class FullPageIdIncrementalSnapshotIterator
    implements PageIdIterable.CountingIterator<FullPageId> {
        @Nullable
        private FullPageId next;
        private final AtomicInteger overallIteratedCnt = new AtomicInteger();

        private FullPageIdIncrementalSnapshotIterator() {
            this.advance();
        }

        private void advance() {
            FullPageId curPageFullId = this.next;
            this.next = FullPageIdIncrementalSnapshotIterable.this.next(curPageFullId, this.overallIteratedCnt);
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public FullPageId next() {
            FullPageId next = this.next;
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.advance();
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        public int currentInternalCount() {
            return this.overallIteratedCnt.get();
        }

        @Override
        public int totalInternalCount() {
            return FullPageIdIncrementalSnapshotIterable.this.getTotalPageCnt();
        }
    }
}

