/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.compression;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.compression.SnapshotCompressionUtils;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.FsSnapshotPath;

public class CompressionTask
implements Runnable {
    private static final int COPY_BUFFER_SIZE = IgniteSystemProperties.getInteger((String)"GG_SNAPSHOT_COPY_LARGE_BUFFER_SIZE", (int)8192);
    private static final String NO_SPACE_LEFT_ON_DEVICE_MSG = "No space left on device";
    private final FsSnapshotPath file;
    private final IgniteLogger logger;
    protected final CompressionOption codec;
    protected final int comprLvl;
    private final SnapshotOperationContext snapshotOperationContext;
    private final SnapshotMetricsMXBeanImpl snapshotMetricsMXBean;

    public CompressionTask(FsSnapshotPath file, CompressionOption codec, int comprLvl, SnapshotOperationContext snapshotOperationContext, SnapshotMetricsMXBeanImpl snapshotMetricsMXBean, IgniteLogger logger) {
        if (!file.isFile()) {
            throw new IgniteException("Invalid file " + file + " passed for compression.");
        }
        this.file = file;
        this.codec = codec;
        this.comprLvl = comprLvl;
        this.snapshotOperationContext = snapshotOperationContext;
        this.snapshotMetricsMXBean = snapshotMetricsMXBean;
        this.logger = logger;
    }

    @Override
    public void run() {
        long size;
        File compressedFile = new File(this.file.getAbsolutePath() + this.codec.fileExtension());
        File tmpFile = new File(compressedFile.getAbsolutePath() + ".tmp");
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Creating CompressionOutputStream for " + tmpFile + ", compressionLevel=" + this.comprLvl + ", compressionOption=" + this.codec);
            }
            try (OutputStream compressionStream = SnapshotCompressionUtils.wrapWithCompression(Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]), this.codec, this.comprLvl, this.file.getName());
                 InputStream fileInputStream = this.file.inputStream();){
                size = SnapshotUtils.copyLarge(fileInputStream, compressionStream, COPY_BUFFER_SIZE, this.snapshotOperationContext);
            }
            catch (IOException ioException) {
                if (NO_SPACE_LEFT_ON_DEVICE_MSG.equals(ioException.getMessage())) {
                    this.logger.warning("Unable to compress partition file " + this.file.getAbsolutePath(), (Throwable)ioException);
                    if (tmpFile.exists()) {
                        U.delete((File)tmpFile);
                    }
                    return;
                }
                throw ioException;
            }
            this.snapshotMetricsMXBean.incrementTotalBytesWrittenOnStorage(tmpFile.length());
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
        finally {
            if (tmpFile.exists()) {
                U.delete((File)tmpFile);
            }
        }
        SnapshotUtils.checkSnapshotCancellation(this.snapshotOperationContext);
        Files.move(tmpFile.toPath(), compressedFile.toPath(), new CopyOption[0]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Archived " + this.file + " to " + compressedFile + ", bytes archived " + size);
        }
        SnapshotUtils.checkSnapshotCancellation(this.snapshotOperationContext);
        boolean result = this.file.delete();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Removed " + this.file + ", result=" + result);
        }
    }
}

