/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.persistence;

import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cache.store.cassandra.persistence.PojoField;
import org.apache.ignite.cache.store.cassandra.persistence.PojoFieldAccessor;
import org.w3c.dom.Element;

public class PojoKeyField
extends PojoField {
    private static final String SORT_ATTR = "sort";
    private SortOrder sortOrder;

    public PojoKeyField(Element element, Class clazz) {
        super(element, clazz);
        if (element.hasAttribute(SORT_ATTR)) {
            try {
                this.sortOrder = SortOrder.valueOf(element.getAttribute(SORT_ATTR).trim().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Incorrect sort order '" + element.getAttribute(SORT_ATTR) + "' specified");
            }
        }
    }

    public PojoKeyField(PojoKeyField pojoKeyField, Class<?> clazz) {
        super(pojoKeyField, clazz);
        this.sortOrder = pojoKeyField.sortOrder;
    }

    public PojoKeyField(PojoFieldAccessor pojoFieldAccessor) {
        super(pojoFieldAccessor);
        QuerySqlField querySqlField = (QuerySqlField)pojoFieldAccessor.getAnnotation(QuerySqlField.class);
        if (querySqlField != null && querySqlField.descending()) {
            this.sortOrder = SortOrder.DESC;
        }
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static enum SortOrder {
        ASC,
        DESC;

    }
}

