/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.store.cassandra.persistence;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.store.cassandra.common.CassandraHelper;
import org.apache.ignite.cache.store.cassandra.common.SystemHelper;
import org.apache.ignite.cache.store.cassandra.persistence.KeyPersistenceSettings;
import org.apache.ignite.cache.store.cassandra.persistence.PersistenceStrategy;
import org.apache.ignite.cache.store.cassandra.persistence.PojoField;
import org.apache.ignite.cache.store.cassandra.persistence.PojoKeyField;
import org.apache.ignite.cache.store.cassandra.persistence.PojoValueField;
import org.apache.ignite.cache.store.cassandra.persistence.ValuePersistenceSettings;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class KeyValuePersistenceSettings
implements Serializable {
    private static final String DFLT_KEYSPACE_OPTIONS = "replication = {'class' : 'SimpleStrategy', 'replication_factor' : 3} and durable_writes = true";
    private static final String KEYSPACE_ATTR = "keyspace";
    private static final String TABLE_ATTR = "table";
    private static final String TTL_ATTR = "ttl";
    private static final String PERSISTENCE_NODE = "persistence";
    private static final String KEYSPACE_OPTIONS_NODE = "keyspaceOptions";
    private static final String TABLE_OPTIONS_NODE = "tableOptions";
    private static final String KEY_PERSISTENCE_NODE = "keyPersistence";
    private static final String VALUE_PERSISTENCE_NODE = "valuePersistence";
    private Integer ttl;
    private String keyspace;
    private String tbl;
    private String tblOptions;
    private String keyspaceOptions = "replication = {'class' : 'SimpleStrategy', 'replication_factor' : 3} and durable_writes = true";
    private KeyPersistenceSettings keyPersistenceSettings;
    private ValuePersistenceSettings valPersistenceSettings;
    private List<String> tableColumns;

    public KeyValuePersistenceSettings(String string) {
        this.init(string);
    }

    public KeyValuePersistenceSettings(File file) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new IgniteException("Failed to get input stream for Cassandra persistence settings file: " + file.getAbsolutePath(), (Throwable)iOException);
        }
        this.init(this.loadSettings(fileInputStream));
    }

    public KeyValuePersistenceSettings(Resource resource) {
        InputStream inputStream;
        try {
            inputStream = resource.getInputStream();
        }
        catch (IOException iOException) {
            throw new IgniteException("Failed to get input stream for Cassandra persistence settings resource: " + resource, (Throwable)iOException);
        }
        this.init(this.loadSettings(inputStream));
    }

    public Integer getTTL() {
        return this.ttl;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getTable() {
        return this.tbl;
    }

    public KeyPersistenceSettings getKeyPersistenceSettings() {
        return this.keyPersistenceSettings;
    }

    public ValuePersistenceSettings getValuePersistenceSettings() {
        return this.valPersistenceSettings;
    }

    public List<PojoField> getFields() {
        LinkedList<PojoField> linkedList = new LinkedList<PojoField>();
        for (PojoField pojoField : this.keyPersistenceSettings.getFields()) {
            linkedList.add(pojoField);
        }
        for (PojoField pojoField : this.valPersistenceSettings.getFields()) {
            linkedList.add(pojoField);
        }
        return linkedList;
    }

    public List<PojoKeyField> getKeyFields() {
        return this.keyPersistenceSettings.getFields();
    }

    public List<PojoValueField> getValueFields() {
        return this.valPersistenceSettings.getFields();
    }

    public String getKeyspaceDDLStatement() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create keyspace if not exists \"").append(this.keyspace).append("\"");
        if (this.keyspaceOptions != null) {
            if (!this.keyspaceOptions.trim().toLowerCase().startsWith("with")) {
                stringBuilder.append("\nwith");
            }
            stringBuilder.append(" ").append(this.keyspaceOptions);
        }
        return (string = stringBuilder.toString().trim().replaceAll(" +", " ")).endsWith(";") ? string : string + ";";
    }

    public List<String> getTableColumns() {
        return this.tableColumns;
    }

    public String getTableDDLStatement(String string) {
        String string2;
        String string3;
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("Table name should be specified");
        }
        String string4 = this.keyPersistenceSettings.getTableColumnsDDL();
        String string5 = this.valPersistenceSettings.getTableColumnsDDL(new HashSet<String>(this.keyPersistenceSettings.getTableColumns()));
        String string6 = string4;
        if (string5 != null && !string5.trim().isEmpty()) {
            string6 = string6 + ",\n" + string5;
        }
        String string7 = this.keyPersistenceSettings.getPrimaryKeyDDL();
        String string8 = this.keyPersistenceSettings.getClusteringDDL();
        String string9 = string3 = this.tblOptions != null && !this.tblOptions.trim().isEmpty() ? this.tblOptions.trim() : "";
        if (string8 != null && !string8.isEmpty()) {
            String string10 = string3 = string3.isEmpty() ? string8 : string3 + " and " + string8;
        }
        if (!string3.trim().isEmpty()) {
            string3 = string3.trim().toLowerCase().startsWith("with") ? string3.trim() : "with " + string3.trim();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("create table if not exists \"").append(this.keyspace).append("\".\"").append(string).append("\"");
        stringBuilder.append("\n(\n").append(string6).append(",\n").append(string7).append("\n)");
        if (!string3.isEmpty()) {
            stringBuilder.append(" \n").append(string3);
        }
        return (string2 = stringBuilder.toString().trim().replaceAll(" +", " ")).endsWith(";") ? string2 : string2 + ";";
    }

    public List<String> getIndexDDLStatements(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        HashSet<String> hashSet = new HashSet<String>(this.keyPersistenceSettings.getTableColumns());
        List<PojoValueField> list = this.valPersistenceSettings.getFields();
        for (PojoField pojoField : list) {
            if (hashSet.contains(pojoField.getColumn()) || !((PojoValueField)pojoField).isIndexed()) continue;
            linkedList.add(((PojoValueField)pojoField).getIndexDDL(this.keyspace, string));
        }
        return linkedList;
    }

    private String loadSettings(InputStream inputStream) {
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append(SystemHelper.LINE_SEPARATOR);
                }
                stringBuilder.append(string);
                string = bufferedReader.readLine();
            }
        }
        catch (Throwable throwable) {
            try {
                throw new IgniteException("Failed to read input stream for Cassandra persistence settings", throwable);
            }
            catch (Throwable throwable2) {
                U.closeQuiet(bufferedReader);
                U.closeQuiet((AutoCloseable)inputStream);
                throw throwable2;
            }
        }
        U.closeQuiet((AutoCloseable)bufferedReader);
        U.closeQuiet((AutoCloseable)inputStream);
        return stringBuilder.toString();
    }

    private int extractIntAttribute(Element element, String string) {
        String string2 = element.getAttribute(string).trim();
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Incorrect value '" + string2 + "' specified for '" + string + "' attribute");
        }
    }

    private void init(String string) {
        Object object2;
        Object object3;
        Document document;
        Object object4;
        Object object5;
        try {
            object5 = DocumentBuilderFactory.newInstance();
            object4 = ((DocumentBuilderFactory)object5).newDocumentBuilder();
            document = ((DocumentBuilder)object4).parse(new InputSource(new StringReader(string)));
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Failed to parse persistence settings:" + SystemHelper.LINE_SEPARATOR + string, throwable);
        }
        object5 = document.getDocumentElement();
        if (!PERSISTENCE_NODE.equals(object5.getNodeName())) {
            throw new IllegalArgumentException("Incorrect persistence settings specified. Root XML element should be 'persistence'");
        }
        if (!object5.hasAttribute(KEYSPACE_ATTR)) {
            throw new IllegalArgumentException("Incorrect persistence settings 'keyspace' attribute should be specified");
        }
        this.keyspace = object5.getAttribute(KEYSPACE_ATTR).trim();
        String string2 = this.tbl = object5.hasAttribute(TABLE_ATTR) ? object5.getAttribute(TABLE_ATTR).trim() : null;
        if (object5.hasAttribute(TTL_ATTR)) {
            this.ttl = this.extractIntAttribute((Element)object5, TTL_ATTR);
        }
        if (!object5.hasChildNodes()) {
            throw new IllegalArgumentException("Incorrect Cassandra persistence settings specification, there are no key and value persistence settings specified");
        }
        object4 = object5.getChildNodes();
        int n = object4.getLength();
        for (int i = 0; i < n; ++i) {
            object3 = object4.item(i);
            if (object3.getNodeType() != 1) continue;
            object2 = (Element)object3;
            String object6 = object2.getNodeName();
            if (object6.equals(TABLE_OPTIONS_NODE)) {
                this.tblOptions = object2.getTextContent();
                this.tblOptions = this.tblOptions.replace("\n", " ").replace("\r", "").replace("\t", " ");
                continue;
            }
            if (object6.equals(KEYSPACE_OPTIONS_NODE)) {
                this.keyspaceOptions = object2.getTextContent();
                this.keyspaceOptions = this.keyspaceOptions.replace("\n", " ").replace("\r", "").replace("\t", " ");
                continue;
            }
            if (object6.equals(KEY_PERSISTENCE_NODE)) {
                this.keyPersistenceSettings = new KeyPersistenceSettings((Element)object2);
                continue;
            }
            if (!object6.equals(VALUE_PERSISTENCE_NODE)) continue;
            this.valPersistenceSettings = new ValuePersistenceSettings((Element)object2);
        }
        if (this.keyPersistenceSettings == null) {
            throw new IllegalArgumentException("Incorrect Cassandra persistence settings specification, there are no key persistence settings specified");
        }
        if (this.valPersistenceSettings == null) {
            throw new IllegalArgumentException("Incorrect Cassandra persistence settings specification, there are no value persistence settings specified");
        }
        List<PojoKeyField> list = this.keyPersistenceSettings.getFields();
        object3 = this.valPersistenceSettings.getFields();
        if (PersistenceStrategy.POJO == this.keyPersistenceSettings.getStrategy() && (list == null || list.isEmpty())) {
            throw new IllegalArgumentException("Incorrect Cassandra persistence settings specification, there are no key fields found");
        }
        if (PersistenceStrategy.POJO == this.valPersistenceSettings.getStrategy() && (object3 == null || object3.isEmpty())) {
            throw new IllegalArgumentException("Incorrect Cassandra persistence settings specification, there are no value fields found");
        }
        if (object3 != null && !object3.isEmpty()) {
            object2 = this.keyPersistenceSettings.getColumn();
            Class clazz = this.keyPersistenceSettings.getJavaClass();
            if (object2 != null && !((String)object2).isEmpty()) {
                Iterator<Object> iterator = object3.iterator();
                while (iterator.hasNext()) {
                    PojoField pojoField = (PojoField)iterator.next();
                    if (!((String)object2).equals(pojoField.getColumn()) || CassandraHelper.isCassandraCompatibleTypes(clazz, pojoField.getJavaClass())) continue;
                    throw new IllegalArgumentException("Value field '" + pojoField.getName() + "' shares the same Cassandra table column '" + object2 + "' with key, but their Java classes are different. Fields sharing the same column should have the same Java class as their type or should be mapped to the same Cassandra primitive type.");
                }
            }
            if (list != null && !list.isEmpty()) {
                for (PojoField pojoField : list) {
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        PojoField pojoField2 = (PojoField)iterator.next();
                        if (!pojoField.getColumn().equals(pojoField2.getColumn()) || CassandraHelper.isCassandraCompatibleTypes(pojoField.getJavaClass(), pojoField2.getJavaClass())) continue;
                        throw new IllegalArgumentException("Value field '" + pojoField2.getName() + "' shares the same Cassandra table column '" + object2 + "' with key field '" + pojoField.getName() + "', but their Java classes are different. Fields sharing the same column should have the same Java class as their type or should be mapped to the same Cassandra primitive type.");
                    }
                }
            }
        }
        this.tableColumns = new LinkedList<String>();
        for (String string3 : this.keyPersistenceSettings.getTableColumns()) {
            if (this.tableColumns.contains(string3)) continue;
            this.tableColumns.add(string3);
        }
        for (String string4 : this.valPersistenceSettings.getTableColumns()) {
            if (this.tableColumns.contains(string4)) continue;
            this.tableColumns.add(string4);
        }
        this.tableColumns = Collections.unmodifiableList(this.tableColumns);
    }
}

