/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.systemview.view;

import java.util.Date;
import java.util.UUID;
import org.apache.ignite.internal.managers.systemview.walker.Order;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;

public class SqlQueryView {
    private final GridRunningQueryInfo qry;

    public SqlQueryView(GridRunningQueryInfo qry) {
        this.qry = qry;
    }

    @Order(value=2)
    public UUID originNodeId() {
        return this.qry.nodeId();
    }

    @Order
    public String queryId() {
        return this.qry.globalQueryId();
    }

    @Order(value=1)
    public String sql() {
        return this.qry.query();
    }

    @Order(value=3)
    public Date startTime() {
        return new Date(this.qry.startTime());
    }

    @Order(value=4)
    public long duration() {
        return System.currentTimeMillis() - this.qry.startTime();
    }

    @Order(value=5)
    public long diskAllocationCurrent() {
        return this.qry.memoryMetricProvider().writtenOnDisk();
    }

    @Order(value=6)
    public long diskAllocationMax() {
        return this.qry.memoryMetricProvider().maxWrittenOnDisk();
    }

    @Order(value=7)
    public long diskAllocationTotal() {
        return this.qry.memoryMetricProvider().totalWrittenOnDisk();
    }

    @Order(value=8)
    public String initiatorId() {
        return this.qry.queryInitiatorId();
    }

    @Order(value=9)
    public boolean local() {
        return this.qry.local();
    }

    @Order(value=10)
    public long memoryCurrent() {
        return this.qry.memoryMetricProvider().reserved();
    }

    @Order(value=11)
    public long memoryMax() {
        return this.qry.memoryMetricProvider().maxReserved();
    }

    @Order(value=12)
    public String schemaName() {
        return this.qry.schemaName();
    }

    @Order(value=13)
    public boolean distributedJoins() {
        return this.qry.distributedJoins();
    }

    @Order(value=14)
    public boolean enforceJoinOrder() {
        return this.qry.enforceJoinOrder();
    }

    @Order(value=15)
    public boolean lazy() {
        return this.qry.lazy();
    }

    @Order(value=16)
    public String label() {
        return this.qry.label();
    }
}

