/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorMemoryPolicyConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String name;
    private long maxSize;
    private long initSize;
    private String swapFilePath;
    private DataPageEvictionMode pageEvictionMode;
    private double evictionThreshold;
    private int emptyPagesPoolSize;

    public VisorMemoryPolicyConfiguration() {
    }

    public VisorMemoryPolicyConfiguration(DataRegionConfiguration plc) {
        assert (plc != null);
        this.name = plc.getName();
        this.maxSize = plc.getMaxSize();
        this.initSize = plc.getInitialSize();
        this.swapFilePath = plc.getSwapPath();
        this.pageEvictionMode = plc.getPageEvictionMode();
        this.evictionThreshold = plc.getEvictionThreshold();
        this.emptyPagesPoolSize = plc.getEmptyPagesPoolSize();
    }

    public String getName() {
        return this.name;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public long getInitialSize() {
        return this.initSize;
    }

    public String getSwapFilePath() {
        return this.swapFilePath;
    }

    public DataPageEvictionMode getPageEvictionMode() {
        return this.pageEvictionMode;
    }

    public double getEvictionThreshold() {
        return this.evictionThreshold;
    }

    public int getEmptyPagesPoolSize() {
        return this.emptyPagesPoolSize;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.name);
        out.writeLong(this.initSize);
        out.writeLong(this.maxSize);
        U.writeString(out, this.swapFilePath);
        U.writeEnum(out, this.pageEvictionMode);
        out.writeDouble(this.evictionThreshold);
        out.writeInt(this.emptyPagesPoolSize);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = U.readString(in);
        this.initSize = in.readLong();
        this.maxSize = in.readLong();
        this.swapFilePath = U.readString(in);
        this.pageEvictionMode = DataPageEvictionMode.fromOrdinal(in.readByte());
        this.evictionThreshold = in.readDouble();
        this.emptyPagesPoolSize = in.readInt();
    }

    public String toString() {
        return S.toString(VisorMemoryPolicyConfiguration.class, this);
    }
}

