/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.tostring;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.ignite.internal.util.tostring.GridToStringFieldDescriptor;

class GridToStringClassDescriptor {
    private final String sqn;
    private final String fqn;
    private ArrayList<GridToStringFieldDescriptor> fields = new ArrayList();

    GridToStringClassDescriptor(Class<?> cls) {
        assert (cls != null);
        this.fqn = cls.getName();
        this.sqn = cls.getSimpleName();
    }

    void addField(GridToStringFieldDescriptor field) {
        assert (field != null);
        this.fields.add(field);
    }

    void sortFields() {
        this.fields.trimToSize();
        this.fields.sort(Comparator.comparingInt(GridToStringFieldDescriptor::getOrder));
    }

    String getSimpleClassName() {
        return this.sqn;
    }

    String getFullyQualifiedClassName() {
        return this.fqn;
    }

    List<GridToStringFieldDescriptor> getFields() {
        return this.fields;
    }
}

