/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.scanner;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.scanner.PrintToFileHandler;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.lang.IgniteBiTuple;

public class PrintRawToFileHandler
extends PrintToFileHandler {
    private final RecordSerializer serializer;

    public PrintRawToFileHandler(File file, RecordSerializer serializer) {
        super(file, null);
        this.serializer = serializer;
    }

    @Override
    protected byte[] getBytes(IgniteBiTuple<WALPointer, WALRecord> record) {
        try {
            WALRecord walRec = record.get2();
            ByteBuffer buf = ByteBuffer.allocate(this.serializer.size(walRec));
            this.serializer.writeRecord(walRec, buf);
            return buf.array();
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    protected byte[] getHeader() {
        ByteBuffer buf = ByteBuffer.allocate(29);
        buf.order(ByteOrder.nativeOrder());
        FileWriteAheadLogManager.prepareSerializerVersionBuffer(0L, this.serializer.version(), false, buf);
        return buf.array();
    }
}

