/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.reader;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleSegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneIgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneWalRecordsIterator;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteWalIteratorFactory {
    protected final IgniteLogger log;
    private final SegmentFileInputFactory segmentFileInputFactory = new SimpleSegmentFileInputFactory();

    public IgniteWalIteratorFactory() {
        this(ConsoleLogger.INSTANCE);
    }

    public IgniteWalIteratorFactory(@NotNull IgniteLogger log) {
        this.log = log;
    }

    public WALIterator iterator(File ... filesOrDirs) throws IgniteCheckedException, IllegalArgumentException {
        return this.iterator(new IteratorParametersBuilder().filesOrDirs(filesOrDirs));
    }

    public WALIterator iterator(@NotNull FileWALPointer replayFrom, File ... filesOrDirs) throws IgniteCheckedException, IllegalArgumentException {
        return this.iterator(new IteratorParametersBuilder().from(replayFrom).filesOrDirs(filesOrDirs));
    }

    public WALIterator iterator(String ... filesOrDirs) throws IgniteCheckedException, IllegalArgumentException {
        return this.iterator(new IteratorParametersBuilder().filesOrDirs(filesOrDirs));
    }

    public WALIterator iterator(@NotNull FileWALPointer replayFrom, String ... filesOrDirs) throws IgniteCheckedException, IllegalArgumentException {
        return this.iterator(new IteratorParametersBuilder().from(replayFrom).filesOrDirs(filesOrDirs));
    }

    public WALIterator iterator(@NotNull IteratorParametersBuilder iteratorParametersBuilder) throws IgniteCheckedException, IllegalArgumentException {
        iteratorParametersBuilder.validate();
        return new StandaloneWalRecordsIterator(iteratorParametersBuilder.log == null ? this.log : iteratorParametersBuilder.log, iteratorParametersBuilder.sharedCtx == null ? this.prepareSharedCtx(iteratorParametersBuilder) : iteratorParametersBuilder.sharedCtx, iteratorParametersBuilder.ioFactory, this.resolveWalFiles(iteratorParametersBuilder), iteratorParametersBuilder.filter, iteratorParametersBuilder.lowBound, iteratorParametersBuilder.highBound, iteratorParametersBuilder.keepBinary, iteratorParametersBuilder.bufferSize, iteratorParametersBuilder.strictBoundsCheck);
    }

    public List<T2<Long, Long>> hasGaps(String ... filesOrDirs) throws IllegalArgumentException {
        return this.hasGaps(new IteratorParametersBuilder().filesOrDirs(filesOrDirs));
    }

    public List<T2<Long, Long>> hasGaps(File ... filesOrDirs) throws IllegalArgumentException {
        return this.hasGaps(new IteratorParametersBuilder().filesOrDirs(filesOrDirs));
    }

    public List<T2<Long, Long>> hasGaps(@NotNull IteratorParametersBuilder iteratorParametersBuilder) throws IllegalArgumentException {
        iteratorParametersBuilder.validate();
        return this.hasGaps(this.resolveWalFiles(iteratorParametersBuilder));
    }

    public List<T2<Long, Long>> hasGaps(@NotNull List<FileDescriptor> descriptors) throws IllegalArgumentException {
        ArrayList<T2<Long, Long>> gaps = new ArrayList<T2<Long, Long>>();
        Iterator<FileDescriptor> it = descriptors.iterator();
        FileDescriptor prevFd = null;
        while (it.hasNext()) {
            FileDescriptor nextFd = it.next();
            if (prevFd == null) {
                prevFd = nextFd;
                continue;
            }
            if (prevFd.idx() + 1L != nextFd.idx()) {
                gaps.add(new T2<Long, Long>(prevFd.idx(), nextFd.idx()));
            }
            prevFd = nextFd;
        }
        return gaps;
    }

    public List<FileDescriptor> resolveWalFiles(final IteratorParametersBuilder iteratorParametersBuilder) {
        File[] filesOrDirs = iteratorParametersBuilder.filesOrDirs;
        if (filesOrDirs == null || filesOrDirs.length == 0) {
            return Collections.emptyList();
        }
        final TreeSet<FileDescriptor> descriptors = new TreeSet<FileDescriptor>();
        for (File file : filesOrDirs) {
            if (file.isDirectory()) {
                try {
                    Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            IgniteWalIteratorFactory.this.addFileDescriptor(path.toFile(), descriptors, iteratorParametersBuilder);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            if (exc instanceof NoSuchFileException) {
                                return FileVisitResult.CONTINUE;
                            }
                            return super.visitFileFailed(file, exc);
                        }
                    });
                }
                catch (IOException e) {
                    U.error(this.log, "Failed to walk directories from root [" + file + "]. Skipping this directory.", e);
                }
                continue;
            }
            this.addFileDescriptor(file, descriptors, iteratorParametersBuilder);
        }
        return new ArrayList<FileDescriptor>(descriptors);
    }

    private void addFileDescriptor(File file, Collection<FileDescriptor> descriptors, IteratorParametersBuilder params) {
        Optional.ofNullable(this.getFileDescriptor(file, params.ioFactory)).filter(desc -> desc.idx() >= params.lowBound.index() && desc.idx() <= params.highBound.index()).ifPresent(descriptors::add);
    }

    private FileDescriptor getFileDescriptor(File file, FileIOFactory ioFactory) {
        if (file.length() < 29L) {
            return null;
        }
        String fileName = file.getName();
        if (!FileWriteAheadLogManager.WAL_NAME_PATTERN.matcher(fileName).matches() && !FileWriteAheadLogManager.WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(fileName).matches()) {
            return null;
        }
        return this.readFileDescriptor(file, ioFactory);
    }

    /*
     * Exception decompiling
     */
    private FileDescriptor readFileDescriptor(File file, FileIOFactory ioFactory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    protected GridCacheSharedContext prepareSharedCtx(IteratorParametersBuilder iteratorParametersBuilder) throws IgniteCheckedException {
        StandaloneGridKernalContext kernalCtx = new StandaloneGridKernalContext(this.log, iteratorParametersBuilder.binaryMetadataFileStoreDir, iteratorParametersBuilder.marshallerMappingFileStoreDir);
        StandaloneIgniteCacheDatabaseSharedManager dbMgr = new StandaloneIgniteCacheDatabaseSharedManager();
        dbMgr.setPageSize(iteratorParametersBuilder.pageSize);
        return new GridCacheSharedContext(kernalCtx, null, null, null, null, null, null, dbMgr, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    private static class ConsoleLogger
    implements IgniteLogger {
        private static final ConsoleLogger INSTANCE = new ConsoleLogger();
        private static final PrintStream OUT = System.out;
        private static final PrintStream ERR = System.err;

        private ConsoleLogger() {
        }

        @Override
        public IgniteLogger getLogger(Object ctgr) {
            return this;
        }

        @Override
        public void trace(String msg) {
        }

        @Override
        public void debug(String msg) {
        }

        @Override
        public void info(String msg) {
            OUT.println(msg);
        }

        @Override
        public void warning(String msg, @Nullable Throwable e) {
            OUT.println(msg);
            if (e != null) {
                e.printStackTrace(OUT);
            }
        }

        @Override
        public void error(String msg, @Nullable Throwable e) {
            ERR.println(msg);
            if (e != null) {
                e.printStackTrace(ERR);
            }
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public boolean isQuiet() {
            return false;
        }

        @Override
        public String fileName() {
            return "SYSTEM.OUT";
        }
    }

    public static class IteratorParametersBuilder {
        private IgniteLogger log;
        public static final FileWALPointer DFLT_LOW_BOUND = new FileWALPointer(Long.MIN_VALUE, 0, 0);
        public static final FileWALPointer DFLT_HIGH_BOUND = new FileWALPointer(Long.MAX_VALUE, Integer.MAX_VALUE, 0);
        private File[] filesOrDirs;
        private int pageSize = 4096;
        private int bufferSize = 0x200000;
        private boolean keepBinary;
        private FileIOFactory ioFactory = new DataStorageConfiguration().getFileIOFactory();
        @Nullable
        private File binaryMetadataFileStoreDir;
        @Nullable
        private File marshallerMappingFileStoreDir;
        @Nullable
        private GridCacheSharedContext sharedCtx;
        @Nullable
        private IgniteBiPredicate<WALRecord.RecordType, WALPointer> filter;
        private FileWALPointer lowBound = DFLT_LOW_BOUND;
        private FileWALPointer highBound = DFLT_HIGH_BOUND;
        private boolean strictBoundsCheck;

        public static IteratorParametersBuilder withIteratorParameters() {
            return new IteratorParametersBuilder();
        }

        public IteratorParametersBuilder log(IgniteLogger log) {
            this.log = log;
            return this;
        }

        public IteratorParametersBuilder filesOrDirs(String ... filesOrDirs) {
            File[] filesOrDirs0 = new File[filesOrDirs.length];
            for (int i = 0; i < filesOrDirs.length; ++i) {
                filesOrDirs0[i] = new File(filesOrDirs[i]);
            }
            return this.filesOrDirs(filesOrDirs0);
        }

        public IteratorParametersBuilder filesOrDirs(File ... filesOrDirs) {
            this.filesOrDirs = this.filesOrDirs == null ? filesOrDirs : this.merge(this.filesOrDirs, filesOrDirs);
            return this;
        }

        public IteratorParametersBuilder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public IteratorParametersBuilder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public IteratorParametersBuilder keepBinary(boolean keepBinary) {
            this.keepBinary = keepBinary;
            return this;
        }

        public IteratorParametersBuilder ioFactory(FileIOFactory ioFactory) {
            this.ioFactory = ioFactory;
            return this;
        }

        public IteratorParametersBuilder binaryMetadataFileStoreDir(File binaryMetadataFileStoreDir) {
            this.binaryMetadataFileStoreDir = binaryMetadataFileStoreDir;
            return this;
        }

        public IteratorParametersBuilder marshallerMappingFileStoreDir(File marshallerMappingFileStoreDir) {
            this.marshallerMappingFileStoreDir = marshallerMappingFileStoreDir;
            return this;
        }

        public IteratorParametersBuilder sharedContext(GridCacheSharedContext sharedCtx) {
            this.sharedCtx = sharedCtx;
            return this;
        }

        public IteratorParametersBuilder filter(IgniteBiPredicate<WALRecord.RecordType, WALPointer> filter) {
            this.filter = filter;
            return this;
        }

        public IteratorParametersBuilder addFilter(IgniteBiPredicate<WALRecord.RecordType, WALPointer> filter) {
            this.filter = this.filter == null ? filter : this.filter.and(filter);
            return this;
        }

        public IteratorParametersBuilder from(FileWALPointer lowBound) {
            this.lowBound = lowBound;
            return this;
        }

        public IteratorParametersBuilder to(FileWALPointer highBound) {
            this.highBound = highBound;
            return this;
        }

        public IteratorParametersBuilder strictBoundsCheck(boolean flag) {
            this.strictBoundsCheck = flag;
            return this;
        }

        public IgniteLogger getLog() {
            return this.log;
        }

        public File[] getFilesOrDirs() {
            return this.filesOrDirs;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public boolean isKeepBinary() {
            return this.keepBinary;
        }

        public FileIOFactory getIoFactory() {
            return this.ioFactory;
        }

        public File getBinaryMetadataFileStoreDir() {
            return this.binaryMetadataFileStoreDir;
        }

        public File getMarshallerMappingFileStoreDir() {
            return this.marshallerMappingFileStoreDir;
        }

        public GridCacheSharedContext getSharedCtx() {
            return this.sharedCtx;
        }

        public IgniteBiPredicate<WALRecord.RecordType, WALPointer> getFilter() {
            return this.filter;
        }

        public FileWALPointer getLowBound() {
            return this.lowBound;
        }

        public FileWALPointer getHighBound() {
            return this.highBound;
        }

        public boolean isStrictBoundsCheck() {
            return this.strictBoundsCheck;
        }

        public IteratorParametersBuilder copy() {
            return new IteratorParametersBuilder().filesOrDirs(this.filesOrDirs).pageSize(this.pageSize).bufferSize(this.bufferSize).keepBinary(this.keepBinary).ioFactory(this.ioFactory).binaryMetadataFileStoreDir(this.binaryMetadataFileStoreDir).marshallerMappingFileStoreDir(this.marshallerMappingFileStoreDir).sharedContext(this.sharedCtx).from(this.lowBound).to(this.highBound).filter(this.filter).strictBoundsCheck(this.strictBoundsCheck);
        }

        public void validate() throws IllegalArgumentException {
            A.ensure(this.pageSize >= 1024 && this.pageSize <= 16384, "Page size must be between 1kB and 16kB.");
            A.ensure(U.isPow2(this.pageSize), "Page size must be a power of 2.");
            A.ensure(this.bufferSize >= this.pageSize * 2, "Buffer to small.");
            A.ensure(this.sharedCtx == null || this.binaryMetadataFileStoreDir == null && this.marshallerMappingFileStoreDir == null, "GridCacheSharedContext and binaryMetadataFileStoreDir/marshallerMappingFileStoreDir can't be specified in the same time");
        }

        private File[] merge(File[] f1, File[] f2) {
            File[] merged = new File[f1.length + f2.length];
            System.arraycopy(f1, 0, merged, 0, f1.length);
            System.arraycopy(f2, 0, merged, f1.length, f2.length);
            return merged;
        }
    }
}

