/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.pagemem.PageMetrics;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.IOVersions;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridStringBuilder;
import org.apache.ignite.internal.util.GridUnsafe;

public class PagePartitionCountersIO
extends PageIO {
    private static final int CNT_OFF = 40;
    private static final int LAST_FLAG_OFF = 42;
    private static final int NEXT_COUNTERS_PAGE_OFF = 43;
    private static final int ITEMS_OFF = 51;
    private static final int CACHE_ID_SIZE = 4;
    private static final int CACHE_SIZE_SIZE = 8;
    public static final int ITEM_SIZE = 12;
    private static final byte LAST_FLAG = 1;
    public static final IOVersions<PagePartitionCountersIO> VERSIONS = new IOVersions((PageIO[])new PagePartitionCountersIO[]{new PagePartitionCountersIO(1)});

    public PagePartitionCountersIO(int ver) {
        super(20, ver);
    }

    public byte[] serializeCacheSizes(Map<Integer, Long> cacheSizes) {
        byte[] data = new byte[cacheSizes.size() * 12];
        long off = GridUnsafe.BYTE_ARR_OFF;
        for (Map.Entry<Integer, Long> entry : cacheSizes.entrySet()) {
            GridUnsafe.putInt(data, off, entry.getKey());
            GridUnsafe.putLong(data, off += 4L, entry.getValue());
            off += 8L;
        }
        return data;
    }

    @Override
    public void initNewPage(long pageAddr, long pageId, int pageSize, PageMetrics metrics) {
        super.initNewPage(pageAddr, pageId, pageSize, metrics);
        this.setCount(pageAddr, 0);
        this.setNextCountersPageId(pageAddr, 0L);
    }

    public long getNextCountersPageId(long pageAddr) {
        return PageUtils.getLong(pageAddr, 43);
    }

    public void setNextCountersPageId(long pageAddr, long partMetaPageId) {
        this.assertPageType(pageAddr);
        PageUtils.putLong(pageAddr, 43, partMetaPageId);
    }

    public int writeCacheSizes(int pageSize, long pageAddr, byte[] cacheSizes, int itemsOff) {
        assert (cacheSizes != null);
        assert (cacheSizes.length % 12 == 0) : cacheSizes.length;
        this.assertPageType(pageAddr);
        int cap = this.getCapacity(pageSize);
        int items = cacheSizes.length / 12 - itemsOff;
        int write = Math.min(cap, items);
        if (write > 0) {
            PageUtils.putBytes(pageAddr, 51, cacheSizes, itemsOff * 12, write * 12);
        }
        this.setCount(pageAddr, write);
        this.setLastFlag(pageAddr, write == items);
        return write;
    }

    public boolean readCacheSizes(long pageAddr, Map<Integer, Long> res) {
        int cnt = this.getCount(pageAddr);
        assert (cnt >= 0 && cnt <= Short.MAX_VALUE) : cnt;
        if (cnt == 0) {
            return true;
        }
        int off = 51;
        for (int i = 0; i < cnt; ++i) {
            int cacheId = PageUtils.getInt(pageAddr, off);
            off += 4;
            assert (cacheId != 0);
            long cacheSize = PageUtils.getLong(pageAddr, off);
            off += 8;
            assert (cacheSize >= 0L) : cacheSize;
            Long old = res.put(cacheId, cacheSize);
            assert (old == null);
        }
        return this.getLastFlag(pageAddr);
    }

    private boolean getLastFlag(long pageAddr) {
        return PageUtils.getByte(pageAddr, 42) == 1;
    }

    private void setLastFlag(long pageAddr, boolean last) {
        this.assertPageType(pageAddr);
        PageUtils.putByte(pageAddr, 42, last ? (byte)1 : -2);
    }

    private int getCount(long pageAddr) {
        return PageUtils.getShort(pageAddr, 40);
    }

    private void setCount(long pageAddr, int cnt) {
        assert (cnt >= 0 && cnt <= Short.MAX_VALUE) : cnt;
        this.assertPageType(pageAddr);
        PageUtils.putShort(pageAddr, 40, (short)cnt);
    }

    private int getCapacity(int pageSize) {
        return (pageSize - 51) / 12;
    }

    @Override
    protected void printPage(long addr, int pageSize, GridStringBuilder sb) throws IgniteCheckedException {
        sb.a("PagePartitionCounters [\n\tcount=").a(this.getCount(addr)).a(",\n\tlastFlag=").a(this.getLastFlag(addr)).a(",\n\tnextCountersPageId=").appendHex(this.getNextCountersPageId(addr)).a(",\n\tsize={");
        HashMap<Integer, Long> sizes = new HashMap<Integer, Long>();
        this.readCacheSizes(addr, sizes);
        for (Map.Entry e : sizes.entrySet()) {
            sb.a("\n\t\t").a(e.getKey()).a("=").a(e.getValue());
        }
        sb.a("\n\t}\n]");
    }
}

