/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.migration;

import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.IgniteCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheOffheapManager;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.IndexStorage;
import org.apache.ignite.internal.processors.cache.persistence.RootPage;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.tree.PendingEntriesTree;
import org.apache.ignite.internal.processors.cache.tree.PendingRow;
import org.apache.ignite.internal.util.IgniteTree;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class UpgradePendingTreeToPerPartitionTask
implements IgniteCallable<Boolean> {
    private static final String PENDING_ENTRIES_TREE_NAME = "PendingEntries";
    private static final long serialVersionUID = 0L;
    public static final int BATCH_SIZE = 500;
    @IgniteInstanceResource
    private IgniteEx node;
    @LoggerResource
    private IgniteLogger log;

    @Override
    public Boolean call() throws IgniteException {
        GridCacheSharedContext sharedCtx = this.node.context().cache().context();
        for (CacheGroupContext grp : sharedCtx.cache().cacheGroups()) {
            if (!grp.persistenceEnabled() || !grp.affinityNode()) {
                if (!grp.persistenceEnabled()) {
                    this.log.info("Skip pending tree upgrade for non-persistent cache group: [grpId=" + grp.groupId() + ", grpName=" + grp.name() + ']');
                    continue;
                }
                this.log.info("Skip pending tree upgrade on non-affinity node for cache group: [grpId=" + grp.groupId() + ", grpName=" + grp.name() + ']');
                continue;
            }
            try {
                this.processCacheGroup(grp);
            }
            catch (Exception ex) {
                if (Thread.interrupted() || X.hasCause((Throwable)ex, InterruptedException.class)) {
                    this.log.info("Upgrade pending tree has been cancelled.");
                } else {
                    this.log.warning("Failed to upgrade pending tree for cache group:  [grpId=" + grp.groupId() + ", grpName=" + grp.name() + ']', ex);
                }
                return false;
            }
            if (!Thread.interrupted()) continue;
            this.log.info("Upgrade pending tree has been cancelled.");
            return false;
        }
        this.log.info("All pending trees upgraded successfully.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCacheGroup(CacheGroupContext grp) throws IgniteCheckedException {
        PendingEntriesTree oldPendingTree;
        assert (grp.offheap() instanceof GridCacheOffheapManager);
        IgniteCacheDatabaseSharedManager db = grp.shared().database();
        db.checkpointReadLock();
        try {
            IndexStorage indexStorage = ((GridCacheOffheapManager)grp.offheap()).getIndexStorage();
            RootPage pendingRootPage = indexStorage.allocateIndex(PENDING_ENTRIES_TREE_NAME);
            if (pendingRootPage.isAllocated()) {
                this.log.info("No pending tree found for cache group: [grpId=" + grp.groupId() + ", grpName=" + grp.name() + ']');
                indexStorage.dropIndex(PENDING_ENTRIES_TREE_NAME);
                return;
            }
            oldPendingTree = new PendingEntriesTree(grp, PENDING_ENTRIES_TREE_NAME, grp.dataRegion().pageMemory(), pendingRootPage.pageId().pageId(), ((GridCacheOffheapManager)grp.offheap()).reuseListForIndex(null), false, grp.shared().diagnostic().pageLockTracker(), 2);
        }
        finally {
            db.checkpointReadUnlock();
        }
        this.processPendingTree(grp, oldPendingTree);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        db.checkpointReadLock();
        try {
            oldPendingTree.destroy();
        }
        finally {
            db.checkpointReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingTree(CacheGroupContext grp, PendingEntriesTree oldPendingEntries) throws IgniteCheckedException {
        PageMemory pageMemory = grp.dataRegion().pageMemory();
        IgniteCacheDatabaseSharedManager db = grp.shared().database();
        Set<Integer> cacheIds = grp.cacheIds();
        PendingRow row = null;
        int processedEntriesCnt = 0;
        int skippedEntries = 0;
        while (!Thread.currentThread().isInterrupted()) {
            int cnt = 0;
            db.checkpointReadLock();
            try {
                GridCursor cursor = oldPendingEntries.find(row, null, PendingEntriesTree.WITHOUT_KEY);
                while (cnt++ < 500 && cursor.next()) {
                    GridCacheEntryEx entry;
                    row = (PendingRow)cursor.get();
                    assert (row.link != 0L && row.expireTime != 0L) : row;
                    if (!cacheIds.contains(row.cacheId) || (entry = this.getEntry(grp, row)) == null) {
                        ++skippedEntries;
                        oldPendingEntries.removex(row);
                        continue;
                    }
                    entry.lockEntry();
                    try {
                        if (this.processRow(pageMemory, grp, row)) {
                            ++processedEntriesCnt;
                        } else {
                            ++skippedEntries;
                        }
                    }
                    finally {
                        entry.unlockEntry();
                    }
                    oldPendingEntries.removex(row);
                }
                if (cnt >= 500) continue;
                break;
            }
            finally {
                db.checkpointReadUnlock();
            }
        }
        this.log.info("PendingTree upgraded: [grpId=" + grp.groupId() + ", grpName=" + grp.name() + ", processedEntries=" + processedEntriesCnt + ", failedEntries=" + skippedEntries + ']');
    }

    private GridCacheEntryEx getEntry(CacheGroupContext grp, PendingRow row) {
        try {
            CacheDataRowAdapter rowData = new CacheDataRowAdapter(row.link);
            rowData.initFromLink(grp, CacheDataRowAdapter.RowData.KEY_ONLY);
            GridCacheContext cctx = grp.shared().cacheContext(row.cacheId);
            assert (cctx != null);
            return cctx.cache().entryEx(rowData.key());
        }
        catch (Throwable ex) {
            if (Thread.currentThread().isInterrupted() || X.hasCause(ex, InterruptedException.class)) {
                throw new IgniteException(new InterruptedException());
            }
            this.log.warning("Failed to move old-version pending entry to per-partition PendingTree: key not found (skipping): [grpId=" + grp.groupId() + ", grpName=" + grp.name() + ", pendingRow=" + row + "]");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processRow(PageMemory pageMemory, CacheGroupContext grp, PendingRow row) {
        long pageId = PageIdUtils.pageId(row.link);
        int partition = PageIdUtils.partId(pageId);
        assert (partition >= 0);
        try {
            long page = pageMemory.acquirePage(grp.groupId(), pageId);
            long pageAddr = pageMemory.readLock(grp.groupId(), pageId, page);
            try {
                assert (PageIO.getType(pageAddr) != 0);
                assert (PageIO.getVersion(pageAddr) != 0);
                IgniteCacheOffheapManager.CacheDataStore store = grp.offheap().dataStore(grp.isLocal() ? null : grp.topology().localPartition(partition));
                if (store == null) {
                    this.log.warning("Failed to move old-version pending entry to per-partition PendingTree: Node has no partition anymore (skipping): [grpId=" + grp.groupId() + ", grpName=" + grp.name() + ", partId=" + partition + ", pendingRow=" + row + "]");
                    boolean bl = false;
                    return bl;
                }
                assert (store instanceof GridCacheOffheapManager.GridCacheDataStore);
                assert (store.pendingTree() != null);
                store.pendingTree().invoke(row, PendingEntriesTree.WITHOUT_KEY, new PutIfAbsentClosure(row));
                return true;
            }
            finally {
                pageMemory.readUnlock(grp.groupId(), pageId, page);
            }
        }
        catch (AssertionError | Exception ex) {
            if (Thread.currentThread().isInterrupted() || X.hasCause((Throwable)ex, InterruptedException.class)) {
                Thread.currentThread().interrupt();
                throw new IgniteException((Throwable)ex);
            }
            String msg = "Unexpected error occurs while moving old-version pending entry to per-partition PendingTree. Seems page doesn't longer exists (skipping): [grpId=" + grp.groupId() + ", grpName=" + grp.name() + ", partId=" + partition + ", pendingRow=" + row + ']';
            if (this.log.isDebugEnabled()) {
                this.log.warning(msg, (Throwable)ex);
                return false;
            }
            this.log.warning(msg);
            return false;
        }
    }

    private static class PutIfAbsentClosure
    implements IgniteTree.InvokeClosure<PendingRow> {
        private final PendingRow pendingRow;
        private IgniteTree.OperationType op;

        PutIfAbsentClosure(PendingRow pendingRow) {
            this.pendingRow = pendingRow;
        }

        @Override
        public void call(@Nullable PendingRow oldRow) throws IgniteCheckedException {
            this.op = oldRow == null ? IgniteTree.OperationType.PUT : IgniteTree.OperationType.NOOP;
        }

        @Override
        public PendingRow newRow() {
            return this.pendingRow;
        }

        @Override
        public IgniteTree.OperationType operationType() {
            return this.op;
        }
    }
}

