/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.atomic;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheIdMessage;
import org.apache.ignite.internal.processors.cache.GridCacheReturn;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.dht.atomic.UpdateErrors;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class GridDhtAtomicNearResponse
extends GridCacheIdMessage {
    private static final long serialVersionUID = 0L;
    public static final int CACHE_MSG_IDX = GridDhtAtomicNearResponse.nextIndexId();
    private int partId;
    private long futId;
    private UUID primaryId;
    @GridToStringExclude
    private byte flags;
    @GridToStringInclude
    private UpdateErrors errs;

    public GridDhtAtomicNearResponse() {
    }

    public GridDhtAtomicNearResponse(int cacheId, int partId, long futId, UUID primaryId, byte flags) {
        assert (primaryId != null);
        this.cacheId = cacheId;
        this.partId = partId;
        this.futId = futId;
        this.primaryId = primaryId;
        this.flags = flags;
    }

    @Nullable
    UpdateErrors errors() {
        return this.errs;
    }

    public void errors(UpdateErrors errs) {
        this.errs = errs;
    }

    UUID primaryId() {
        return this.primaryId;
    }

    @Override
    public int partition() {
        return this.partId;
    }

    public void addFailedKey(KeyCacheObject key, Throwable e) {
        if (this.errs == null) {
            this.errs = new UpdateErrors();
        }
        this.errs.addFailedKey(key, e);
    }

    public void addFailedKeys(Collection<KeyCacheObject> keys, Throwable e) {
        if (this.errs == null) {
            this.errs = new UpdateErrors();
        }
        this.errs.addFailedKeys(keys, e);
    }

    public GridCacheReturn result() {
        assert (this.hasResult()) : this;
        return new GridCacheReturn(true, true);
    }

    boolean hasResult() {
        return this.isFlag(8);
    }

    private boolean isFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    public long futureId() {
        return this.futId;
    }

    @Override
    public int lookupIndex() {
        return CACHE_MSG_IDX;
    }

    @Override
    public short directType() {
        return -48;
    }

    @Override
    public byte fieldsCount() {
        return 9;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public void prepareMarshal(GridCacheSharedContext ctx) throws IgniteCheckedException {
        super.prepareMarshal(ctx);
        if (this.errs != null) {
            this.errs.prepareMarshal(this, ctx.cacheContext(this.cacheId));
        }
    }

    @Override
    public void finishUnmarshal(GridCacheSharedContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        super.finishUnmarshal(ctx, ldr);
        if (this.errs != null) {
            this.errs.finishUnmarshal(this, ctx.cacheContext(this.cacheId), ldr);
        }
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 4: {
                if (!writer.writeMessage("errs", this.errs)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeLong("futId", this.futId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeInt("partId", this.partId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeUuid("primaryId", this.primaryId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 4: {
                this.errs = (UpdateErrors)reader.readMessage("errs");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.futId = reader.readLong("futId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.partId = reader.readInt("partId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.primaryId = reader.readUuid("primaryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtAtomicNearResponse.class);
    }

    @Override
    public String toString() {
        StringBuilder flags = new StringBuilder();
        if (this.hasResult()) {
            this.appendFlag(flags, "hasRes");
        }
        return S.toString(GridDhtAtomicNearResponse.class, this, "flags", (Object)flags.toString());
    }
}

