/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.query.schema.operation.SchemaAddQueryEntityOperation;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

@GridToStringExclude
public class GridCacheContextInfo<K, V> {
    private final boolean clientCache;
    private final IgniteUuid dynamicDeploymentId;
    private volatile CacheConfiguration<K, V> config;
    private final int groupId;
    private final int cacheId;
    @Nullable
    private volatile GridCacheContext<K, V> cctx;

    public GridCacheContextInfo(GridCacheContext<K, V> cctx, boolean clientCache) {
        this.config = cctx.config();
        this.dynamicDeploymentId = null;
        this.groupId = cctx.groupId();
        this.cacheId = cctx.cacheId();
        this.clientCache = clientCache;
        this.cctx = cctx;
    }

    public GridCacheContextInfo(DynamicCacheDescriptor cacheDesc) {
        this.config = cacheDesc.cacheConfiguration();
        this.dynamicDeploymentId = cacheDesc.deploymentId();
        this.groupId = cacheDesc.groupId();
        this.cacheId = CU.cacheId(this.config.getName());
        this.clientCache = true;
    }

    public CacheConfiguration<K, V> config() {
        return this.config;
    }

    public String name() {
        return this.config.getName();
    }

    public String groupName() {
        return CacheGroupContext.cacheOrGroupName(this.config);
    }

    public int groupId() {
        return this.groupId;
    }

    public int cacheId() {
        return this.cacheId;
    }

    public boolean affinityNode() {
        return this.cctx != null && this.cctx.affinityNode();
    }

    @Nullable
    public GridCacheContext<K, V> cacheContext() {
        return this.cctx;
    }

    public IgniteUuid dynamicDeploymentId() {
        GridCacheContext<K, V> cctx0 = this.cctx;
        if (cctx0 != null) {
            return cctx0.dynamicDeploymentId();
        }
        assert (this.dynamicDeploymentId != null) : "Deployment id is not set and cache context is not initialized: " + this;
        return this.dynamicDeploymentId;
    }

    public void initCacheContext(GridCacheContext<K, V> cctx) {
        assert (this.cctx == null) : this.cctx;
        assert (cctx != null);
        this.cctx = cctx;
    }

    public void clearCacheContext() {
        this.cctx = null;
    }

    public boolean isClientCache() {
        return this.clientCache;
    }

    public boolean isCacheContextInited() {
        return this.cctx != null;
    }

    public void onSchemaAddQueryEntity(SchemaAddQueryEntityOperation op) {
        if (this.cctx != null) {
            this.cctx.onSchemaAddQueryEntity(op);
            this.config = this.cctx.config();
        } else {
            CacheConfiguration<K, V> oldCfg = this.config;
            this.config = GridCacheUtils.patchCacheConfiguration(oldCfg, op);
        }
    }

    public String toString() {
        return "GridCacheContextInfo: " + this.name() + " " + (this.isCacheContextInited() ? "started" : "not started");
    }
}

