/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class CacheEntryInfoCollection
implements Message {
    private static final long serialVersionUID = 0L;
    @GridDirectCollection(value=GridCacheEntryInfo.class)
    private List<GridCacheEntryInfo> infos;
    private boolean historical;

    public CacheEntryInfoCollection() {
    }

    public CacheEntryInfoCollection(List<GridCacheEntryInfo> infos) {
        this.infos = infos;
    }

    public CacheEntryInfoCollection(boolean historical) {
        this.historical = historical;
    }

    public void init() {
        this.infos = new ArrayList<GridCacheEntryInfo>();
    }

    public List<GridCacheEntryInfo> infos() {
        return this.infos;
    }

    public void add(GridCacheEntryInfo info) {
        this.infos.add(info);
    }

    public boolean historical() {
        return this.historical;
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeBoolean("historical", this.historical)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeCollection("infos", this.infos, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.historical = reader.readBoolean("historical");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.infos = (List)reader.readCollection("infos", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(CacheEntryInfoCollection.class);
    }

    @Override
    public short directType() {
        return 92;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < this.infos().size(); ++i) {
            GridCacheEntryInfo info = this.infos().get(i);
            Object k = info.key().value(null, false);
            b.append("[key=").append((Object)(k == null ? "null" : k)).append(", ver=").append(info.version()).append(", val=").append(info.value()).append(']');
        }
        b.append(']');
        return b.toString();
    }
}

