/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.client.ClientOperationType;
import org.apache.ignite.internal.client.thin.ClientNotificationType;
import org.jetbrains.annotations.Nullable;

public enum ClientOperation {
    HANDSHAKE(-1),
    RESOURCE_CLOSE(0),
    HEARTBEAT(1),
    GET_IDLE_TIMEOUT(2),
    CACHE_GET_OR_CREATE_WITH_NAME(1052),
    CACHE_PUT(1001),
    CACHE_GET(1000),
    CACHE_CREATE_WITH_CONFIGURATION(1053),
    CACHE_GET_NAMES(1050),
    CACHE_DESTROY(1056),
    CACHE_GET_OR_CREATE_WITH_CONFIGURATION(1054),
    CACHE_CREATE_WITH_NAME(1051),
    CACHE_CONTAINS_KEY(1011),
    CACHE_CONTAINS_KEYS(1012),
    CACHE_GET_CONFIGURATION(1055),
    CACHE_GET_SIZE(1020),
    CACHE_PUT_ALL(1004),
    CACHE_GET_ALL(1003),
    CACHE_REPLACE_IF_EQUALS(1010),
    CACHE_REPLACE(1009),
    CACHE_REMOVE_KEY(1016),
    CACHE_REMOVE_IF_EQUALS(1017),
    CACHE_REMOVE_KEYS(1018),
    CACHE_REMOVE_ALL(1019),
    CACHE_GET_AND_PUT(1005),
    CACHE_GET_AND_REMOVE(1007),
    CACHE_GET_AND_REPLACE(1006),
    CACHE_PUT_IF_ABSENT(1002),
    CACHE_GET_AND_PUT_IF_ABSENT(1008),
    CACHE_CLEAR(1013),
    CACHE_CLEAR_KEY(1014),
    CACHE_CLEAR_KEYS(1015),
    CACHE_PARTITIONS(1101),
    QUERY_SCAN(2000),
    QUERY_SCAN_CURSOR_GET_PAGE(2001),
    QUERY_SQL(2002),
    QUERY_SQL_CURSOR_GET_PAGE(2003),
    QUERY_SQL_FIELDS(2004),
    QUERY_SQL_FIELDS_CURSOR_GET_PAGE(2005),
    QUERY_CONTINUOUS(2006),
    QUERY_CONTINUOUS_EVENT(2007, ClientNotificationType.CONTINUOUS_QUERY_EVENT),
    QUERY_INDEX(2008),
    QUERY_INDEX_CURSOR_GET_PAGE(2009),
    GET_BINARY_TYPE_NAME(3000),
    REGISTER_BINARY_TYPE_NAME(3001),
    GET_BINARY_TYPE(3002),
    PUT_BINARY_TYPE(3003),
    GET_BINARY_CONFIGURATION(3004),
    REMOVE_BINARY_TYPE(3005),
    GET_BINARY_TYPES(3006),
    TX_START(4000),
    TX_END(4001),
    CLUSTER_GET_STATE(5000),
    CLUSTER_CHANGE_STATE(5001),
    CLUSTER_GET_WAL_STATE(5003),
    CLUSTER_CHANGE_WAL_STATE(5002),
    CLUSTER_GROUP_GET_NODE_IDS(5100),
    CLUSTER_GROUP_GET_NODE_INFO(5101),
    CLUSTER_GROUP_GET_NODE_ENDPOINTS(5102),
    COMPUTE_TASK_EXECUTE(6000),
    COMPUTE_TASK_FINISHED(6001, ClientNotificationType.COMPUTE_TASK_FINISHED),
    SERVICE_INVOKE(7000),
    SERVICE_GET_DESCRIPTORS(7001),
    SERVICE_GET_DESCRIPTOR(7002),
    ATOMIC_LONG_CREATE(9000),
    ATOMIC_LONG_REMOVE(9001),
    ATOMIC_LONG_EXISTS(9002),
    ATOMIC_LONG_VALUE_GET(9003),
    ATOMIC_LONG_VALUE_ADD_AND_GET(9004),
    ATOMIC_LONG_VALUE_GET_AND_SET(9005),
    ATOMIC_LONG_VALUE_COMPARE_AND_SET(9006),
    ATOMIC_LONG_VALUE_COMPARE_AND_SET_AND_GET(9007),
    OP_SET_GET_OR_CREATE(9010),
    OP_SET_CLOSE(9011),
    OP_SET_EXISTS(9012),
    OP_SET_VALUE_ADD(9013),
    OP_SET_VALUE_ADD_ALL(9014),
    OP_SET_VALUE_REMOVE(9015),
    OP_SET_VALUE_REMOVE_ALL(9016),
    OP_SET_VALUE_CONTAINS(9017),
    OP_SET_VALUE_CONTAINS_ALL(9018),
    OP_SET_VALUE_RETAIN_ALL(9019),
    OP_SET_SIZE(9020),
    OP_SET_CLEAR(9021),
    OP_SET_ITERATOR_START(9022),
    OP_SET_ITERATOR_GET_PAGE(9023),
    ATOMIC_SEQUENCE_CREATE(9030),
    ATOMIC_SEQUENCE_REMOVE(9031),
    ATOMIC_SEQUENCE_EXISTS(9032),
    ATOMIC_SEQUENCE_VALUE_GET(9033),
    ATOMIC_SEQUENCE_VALUE_ADD_AND_GET(9034);

    private final int code;
    private final ClientNotificationType notificationType;
    private static final Map<Short, ClientOperation> map;

    private ClientOperation(int code) {
        this(code, null);
    }

    private ClientOperation(int code, ClientNotificationType notificationType) {
        this.code = code;
        this.notificationType = notificationType;
    }

    public short code() {
        return (short)this.code;
    }

    public ClientNotificationType notificationType() {
        return this.notificationType;
    }

    @Nullable
    public ClientOperationType toPublicOperationType() {
        switch (this) {
            case CACHE_GET_OR_CREATE_WITH_NAME: 
            case CACHE_GET_OR_CREATE_WITH_CONFIGURATION: {
                return ClientOperationType.CACHE_GET_OR_CREATE;
            }
            case CACHE_CREATE_WITH_CONFIGURATION: 
            case CACHE_CREATE_WITH_NAME: {
                return ClientOperationType.CACHE_CREATE;
            }
            case CACHE_PUT: {
                return ClientOperationType.CACHE_PUT;
            }
            case CACHE_GET: {
                return ClientOperationType.CACHE_GET;
            }
            case CACHE_GET_NAMES: {
                return ClientOperationType.CACHE_GET_NAMES;
            }
            case CACHE_DESTROY: {
                return ClientOperationType.CACHE_DESTROY;
            }
            case CACHE_CONTAINS_KEY: {
                return ClientOperationType.CACHE_CONTAINS_KEY;
            }
            case CACHE_CONTAINS_KEYS: {
                return ClientOperationType.CACHE_CONTAINS_KEYS;
            }
            case CACHE_GET_CONFIGURATION: {
                return ClientOperationType.CACHE_GET_CONFIGURATION;
            }
            case CACHE_GET_SIZE: {
                return ClientOperationType.CACHE_GET_SIZE;
            }
            case CACHE_PUT_ALL: {
                return ClientOperationType.CACHE_PUT_ALL;
            }
            case CACHE_GET_ALL: {
                return ClientOperationType.CACHE_GET_ALL;
            }
            case CACHE_REPLACE_IF_EQUALS: 
            case CACHE_REPLACE: {
                return ClientOperationType.CACHE_REPLACE;
            }
            case CACHE_REMOVE_KEY: 
            case CACHE_REMOVE_IF_EQUALS: {
                return ClientOperationType.CACHE_REMOVE_ONE;
            }
            case CACHE_REMOVE_KEYS: {
                return ClientOperationType.CACHE_REMOVE_MULTIPLE;
            }
            case CACHE_REMOVE_ALL: {
                return ClientOperationType.CACHE_REMOVE_EVERYTHING;
            }
            case CACHE_GET_AND_PUT: {
                return ClientOperationType.CACHE_GET_AND_PUT;
            }
            case CACHE_GET_AND_REMOVE: {
                return ClientOperationType.CACHE_GET_AND_REMOVE;
            }
            case CACHE_GET_AND_REPLACE: {
                return ClientOperationType.CACHE_GET_AND_REPLACE;
            }
            case CACHE_PUT_IF_ABSENT: {
                return ClientOperationType.CACHE_PUT_IF_ABSENT;
            }
            case CACHE_GET_AND_PUT_IF_ABSENT: {
                return ClientOperationType.CACHE_GET_AND_PUT_IF_ABSENT;
            }
            case CACHE_CLEAR: {
                return ClientOperationType.CACHE_CLEAR_EVERYTHING;
            }
            case CACHE_CLEAR_KEY: {
                return ClientOperationType.CACHE_CLEAR_ONE;
            }
            case CACHE_CLEAR_KEYS: {
                return ClientOperationType.CACHE_CLEAR_MULTIPLE;
            }
            case QUERY_SCAN: {
                return ClientOperationType.QUERY_SCAN;
            }
            case QUERY_SQL: 
            case QUERY_SQL_FIELDS: {
                return ClientOperationType.QUERY_SQL;
            }
            case QUERY_CONTINUOUS: {
                return ClientOperationType.QUERY_CONTINUOUS;
            }
            case QUERY_INDEX: {
                return ClientOperationType.QUERY_INDEX;
            }
            case TX_START: {
                return ClientOperationType.TRANSACTION_START;
            }
            case CLUSTER_GET_STATE: {
                return ClientOperationType.CLUSTER_GET_STATE;
            }
            case CLUSTER_CHANGE_STATE: {
                return ClientOperationType.CLUSTER_CHANGE_STATE;
            }
            case CLUSTER_GET_WAL_STATE: {
                return ClientOperationType.CLUSTER_GET_WAL_STATE;
            }
            case CLUSTER_CHANGE_WAL_STATE: {
                return ClientOperationType.CLUSTER_CHANGE_WAL_STATE;
            }
            case CLUSTER_GROUP_GET_NODE_IDS: 
            case CLUSTER_GROUP_GET_NODE_INFO: {
                return ClientOperationType.CLUSTER_GROUP_GET_NODES;
            }
            case COMPUTE_TASK_EXECUTE: {
                return ClientOperationType.COMPUTE_TASK_EXECUTE;
            }
            case SERVICE_INVOKE: {
                return ClientOperationType.SERVICE_INVOKE;
            }
            case SERVICE_GET_DESCRIPTORS: {
                return ClientOperationType.SERVICE_GET_DESCRIPTORS;
            }
            case SERVICE_GET_DESCRIPTOR: {
                return ClientOperationType.SERVICE_GET_DESCRIPTOR;
            }
            case ATOMIC_LONG_CREATE: {
                return ClientOperationType.ATOMIC_LONG_CREATE;
            }
            case ATOMIC_LONG_REMOVE: {
                return ClientOperationType.ATOMIC_LONG_REMOVE;
            }
            case ATOMIC_LONG_EXISTS: {
                return ClientOperationType.ATOMIC_LONG_EXISTS;
            }
            case ATOMIC_LONG_VALUE_GET: {
                return ClientOperationType.ATOMIC_LONG_VALUE_GET;
            }
            case ATOMIC_LONG_VALUE_ADD_AND_GET: {
                return ClientOperationType.ATOMIC_LONG_VALUE_ADD_AND_GET;
            }
            case ATOMIC_LONG_VALUE_GET_AND_SET: {
                return ClientOperationType.ATOMIC_LONG_VALUE_GET_AND_SET;
            }
            case ATOMIC_LONG_VALUE_COMPARE_AND_SET: 
            case ATOMIC_LONG_VALUE_COMPARE_AND_SET_AND_GET: {
                return ClientOperationType.ATOMIC_LONG_VALUE_COMPARE_AND_SET;
            }
            case OP_SET_GET_OR_CREATE: {
                return ClientOperationType.SET_GET_OR_CREATE;
            }
            case OP_SET_CLOSE: {
                return ClientOperationType.SET_REMOVE;
            }
            case OP_SET_EXISTS: {
                return ClientOperationType.SET_EXISTS;
            }
            case OP_SET_VALUE_ADD: {
                return ClientOperationType.SET_VALUE_ADD;
            }
            case OP_SET_VALUE_ADD_ALL: {
                return ClientOperationType.SET_VALUE_ADD_ALL;
            }
            case OP_SET_VALUE_REMOVE: {
                return ClientOperationType.SET_VALUE_REMOVE;
            }
            case OP_SET_VALUE_REMOVE_ALL: {
                return ClientOperationType.SET_VALUE_REMOVE_ALL;
            }
            case OP_SET_VALUE_CONTAINS: {
                return ClientOperationType.SET_VALUE_CONTAINS;
            }
            case OP_SET_VALUE_CONTAINS_ALL: {
                return ClientOperationType.SET_VALUE_CONTAINS_ALL;
            }
            case OP_SET_VALUE_RETAIN_ALL: {
                return ClientOperationType.SET_VALUE_RETAIN_ALL;
            }
            case OP_SET_SIZE: {
                return ClientOperationType.SET_SIZE;
            }
            case OP_SET_CLEAR: {
                return ClientOperationType.SET_CLEAR;
            }
            case OP_SET_ITERATOR_START: {
                return ClientOperationType.SET_ITERATOR;
            }
            case ATOMIC_SEQUENCE_CREATE: {
                return ClientOperationType.ATOMIC_SEQUENCE_CREATE;
            }
            case ATOMIC_SEQUENCE_REMOVE: {
                return ClientOperationType.ATOMIC_SEQUENCE_REMOVE;
            }
            case ATOMIC_SEQUENCE_EXISTS: {
                return ClientOperationType.ATOMIC_SEQUENCE_EXISTS;
            }
            case ATOMIC_SEQUENCE_VALUE_GET: {
                return ClientOperationType.ATOMIC_SEQUENCE_VALUE_GET;
            }
            case ATOMIC_SEQUENCE_VALUE_ADD_AND_GET: {
                return ClientOperationType.ATOMIC_SEQUENCE_VALUE_ADD_AND_GET;
            }
        }
        return null;
    }

    @Nullable
    public static ClientOperation fromCode(short code) {
        return map.get(code);
    }

    static {
        map = new HashMap<Short, ClientOperation>();
        for (ClientOperation op : ClientOperation.values()) {
            map.put(op.code(), op);
        }
    }
}

