/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.txdr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.processors.cache.database.txdr.DebugMode;
import org.gridgain.grid.internal.processors.cache.database.txdr.TransactionalDrProcessorImpl;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorReplicationDebugTask
extends VisorMultiNodeTask<DebugMode, Map<Object, IgniteException>, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<DebugMode, Void> job(DebugMode arg) {
        return new VisorReplicationDebugJob(arg, this.debug);
    }

    @Nullable
    protected Map<Object, IgniteException> reduce0(List<ComputeJobResult> results) {
        HashMap<Object, IgniteException> map = new HashMap<Object, IgniteException>();
        for (ComputeJobResult res : results) {
            if (res.getException() == null) continue;
            map.put(res.getNode().consistentId(), res.getException());
        }
        return map;
    }

    private static class VisorReplicationDebugJob
    extends VisorJob<DebugMode, Void> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;

        protected VisorReplicationDebugJob(@Nullable DebugMode mode, boolean debug) {
            super((Object)mode, debug);
        }

        protected Void run(@Nullable DebugMode mode) throws IgniteException {
            if (!(this.ignite.context().txDr() instanceof TransactionalDrProcessorImpl)) {
                throw new IgniteException("Transactional data center replication is not configured or incompatible TransactionalDrProcessor implementation.");
            }
            TransactionalDrProcessorImpl txDr = (TransactionalDrProcessorImpl)this.ignite.context().txDr();
            txDr.debugMode(mode);
            return null;
        }
    }
}

