/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.txdr;

import java.io.File;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.txdr.BootstrapMasterParameters;
import org.gridgain.grid.internal.txdr.ClusterRole;
import org.gridgain.grid.internal.txdr.TransactionalDr;
import org.gridgain.grid.internal.visor.txdr.VisorReplicationInfo;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorReplicationBootstrapTask
extends VisorOneNodeTask<VisorReplicationInfo, VisorReplicationInfo> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<VisorReplicationInfo, VisorReplicationInfo> job(VisorReplicationInfo arg) {
        return new VisorBootstrapJob(arg, this.debug);
    }

    private static class VisorBootstrapJob
    extends VisorJob<VisorReplicationInfo, VisorReplicationInfo> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;
        private IgniteFuture ccFut;

        VisorBootstrapJob(VisorReplicationInfo info, boolean debug) {
            super((Object)info, debug);
        }

        protected VisorReplicationInfo run(@Nullable VisorReplicationInfo arg) throws IgniteException {
            if (this.ccFut == null) {
                if (!(this.ignite.context().txDr() instanceof TransactionalDr)) {
                    throw new IgniteException("Transactional data center replication is not configured.");
                }
                TransactionalDr txDr = (TransactionalDr)this.ignite.context().txDr();
                try {
                    this.ccFut = arg.role() == ClusterRole.MASTER ? txDr.bootstrap(new BootstrapMasterParameters.Builder().withSnapshotFolder(arg.snapshotFolder()).withParallelism(arg.parallelism()).withCompressionOption(arg.compressionOption()).withCompressionLevel(arg.compressionLevel()).withSingleFileCopy(arg.singleFileCopy()).build()) : txDr.bootstrap(new File(arg.snapshotFolder()), arg.sessionId());
                    if (!this.ccFut.isDone()) {
                        this.jobCtx.holdcc();
                        this.ccFut.listen((IgniteInClosure)new IgniteInClosure<IgniteFuture>(){

                            public void apply(IgniteFuture f) {
                                jobCtx.callcc();
                            }
                        });
                        return null;
                    }
                }
                catch (Exception cause) {
                    throw new IgniteException("Failed to bootstrap the replication session.", (Throwable)cause);
                }
            }
            this.ccFut.get();
            if (arg.role() == ClusterRole.MASTER) {
                IgniteFuture resFut = this.ccFut;
                return new VisorReplicationInfo.Builder().withSessionId((Long)resFut.get()).withRole(ClusterRole.MASTER).withSnapshotFolder(arg.snapshotFolder()).build();
            }
            return new VisorReplicationInfo.Builder().withSessionId(arg.sessionId()).withRole(ClusterRole.REPLICA).withSnapshotFolder(arg.snapshotFolder()).build();
        }

        public String toString() {
            return S.toString(VisorBootstrapJob.class, (Object)((Object)this));
        }
    }
}

