/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.visor.txdr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.compute.ComputeJobContext;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.resources.JobContextResource;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.visor.txdr.VisorConsistentCutInfo;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorApplyConsistentCutTask
extends VisorMultiNodeTask<VisorConsistentCutInfo, Map<Object, IgniteException>, Void> {
    private static final long serialVersionUID = 0L;

    protected VisorJob<VisorConsistentCutInfo, Void> job(VisorConsistentCutInfo arg) {
        return new VisorApplyConsistentCutJob(arg, this.debug);
    }

    @Nullable
    protected Map<Object, IgniteException> reduce0(List<ComputeJobResult> results) {
        HashMap<Object, IgniteException> map = new HashMap<Object, IgniteException>();
        for (ComputeJobResult res : results) {
            if (res.getException() == null) continue;
            map.put(res.getNode().consistentId(), res.getException());
        }
        return map;
    }

    private static class VisorApplyConsistentCutJob
    extends VisorJob<VisorConsistentCutInfo, Void> {
        private static final long serialVersionUID = 0L;
        @JobContextResource
        private ComputeJobContext jobCtx;

        VisorApplyConsistentCutJob(VisorConsistentCutInfo info, boolean debug) {
            super((Object)info, debug);
        }

        protected Void run(@Nullable VisorConsistentCutInfo arg) throws IgniteException {
            GridCacheSnapshotManager snpMgr = this.snapshotManager();
            try {
                snpMgr.applyConsistentCut(arg.lastAppliedId(), arg.id(), true, null);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Consistent cut(s) cannot be applied due to error [cutId=" + arg.id() + ", lastAppliedId=" + arg.lastAppliedId() + ", err=" + (Object)((Object)e) + "]", (Throwable)e);
            }
            return null;
        }

        private GridCacheSnapshotManager snapshotManager() {
            GridCacheSnapshotManager snapMgr = (GridCacheSnapshotManager)this.ignite.context().cache().context().snapshot();
            if (snapMgr == null) {
                throw new IgniteException("GridGain snapshot manager is not configured.");
            }
            return snapMgr;
        }

        public String toString() {
            return S.toString(VisorApplyConsistentCutJob.class, (Object)((Object)this));
        }
    }
}

