/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr.recovery;

import java.io.File;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.MemoryRecoveryRecord;
import org.apache.ignite.internal.pagemem.wal.record.TimeStampRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.IgniteWalIteratorFactory;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteBiTuple;

class TimeResolver {
    private final IgniteLogger log;
    private final IgniteWalIteratorFactory iterFactory;
    private final IgniteWalIteratorFactory.IteratorParametersBuilder params;
    private final File walDir;
    private final FileWALPointer startPtr;
    private static final EnumSet<WALRecord.RecordType> RECORD_TYPES_WITH_TIME = EnumSet.of(WALRecord.RecordType.EXCHANGE, new WALRecord.RecordType[]{WALRecord.RecordType.TX_RECORD, WALRecord.RecordType.MVCC_TX_RECORD, WALRecord.RecordType.DATA_RECORD, WALRecord.RecordType.DATA_RECORD_V2, WALRecord.RecordType.MVCC_DATA_RECORD, WALRecord.RecordType.MEMORY_RECOVERY});

    public static long getLocalMaxTime(IgniteLogger log, IgniteWalIteratorFactory.IteratorParametersBuilder params, File walDir, FileWALPointer startPtr) throws IgniteCheckedException {
        TimeResolver tr = new TimeResolver(log, params, walDir, startPtr);
        long time = tr.getMaxTime();
        return time;
    }

    private TimeResolver(IgniteLogger log, IgniteWalIteratorFactory.IteratorParametersBuilder params, File walDir, FileWALPointer startPtr) {
        this.log = log;
        this.iterFactory = new IgniteWalIteratorFactory(log);
        this.params = params;
        this.walDir = walDir;
        this.startPtr = startPtr;
    }

    private long getMaxTime() throws IgniteCheckedException {
        FileDescriptor desc;
        List<FileDescriptor> descriptors = this.getDescriptors();
        long time = 0L;
        for (int i = descriptors.size() - 1; i >= 0 && (desc = descriptors.get(i)).idx() >= this.startPtr.index() && (time = this.getWalMaxTime(desc)) == 0L; --i) {
        }
        return time;
    }

    private long getWalMaxTime(FileDescriptor desc) throws IgniteCheckedException {
        long maxTime = 0L;
        try (WALIterator it = this.walIterator(desc);){
            while (it.hasNext()) {
                long time;
                WALRecord rec = (WALRecord)((IgniteBiTuple)it.next()).get2();
                if (rec instanceof TimeStampRecord) {
                    time = ((TimeStampRecord)rec).timestamp();
                } else {
                    if (!(rec instanceof MemoryRecoveryRecord)) continue;
                    time = ((MemoryRecoveryRecord)rec).time();
                }
                if (maxTime >= time) continue;
                maxTime = time;
            }
        }
        return maxTime;
    }

    private WALIterator walIterator(FileDescriptor desc) throws IgniteCheckedException {
        IgniteWalIteratorFactory.IteratorParametersBuilder params0 = this.params.copy().filesOrDirs(new File[]{desc.file()}).from(this.startPtr).filter((IgniteBiPredicate & Serializable)(type, ptr) -> RECORD_TYPES_WITH_TIME.contains(type) && ((FileWALPointer)ptr).compareTo(this.startPtr) > 0);
        return this.iterFactory.iterator(params0);
    }

    private List<FileDescriptor> getDescriptors() {
        IgniteWalIteratorFactory.IteratorParametersBuilder params0 = this.params.copy().from(this.startPtr).filesOrDirs(new File[]{this.walDir});
        return this.iterFactory.resolveWalFiles(params0);
    }
}

