/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.txdr;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.gridgain.grid.internal.processors.cache.database.txdr.NodeLastEvents;
import org.gridgain.grid.internal.processors.cache.database.txdr.TopologyEventsTracker;

public class TopologyEventsSnapshot
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final TopologyEventsSnapshot EMPTY_SNAPSHOT = new TopologyEventsSnapshot();
    private final long cutId;
    private final AffinityTopologyVersion topVer;
    @GridToStringInclude
    @GridDirectMap(keyType=Object.class, valueType=TopologyEventsTracker.LogEvents.class)
    final Map<Object, TopologyEventsTracker.LogEvents> bltNodesLastEvts;

    public TopologyEventsSnapshot() {
        this(-1L, AffinityTopologyVersion.NONE, Collections.EMPTY_MAP);
    }

    public TopologyEventsSnapshot(long cutId, AffinityTopologyVersion topVer, Map<Object, TopologyEventsTracker.LogEvents> bltNodesLastEvts) {
        this.cutId = cutId;
        this.topVer = topVer;
        this.bltNodesLastEvts = bltNodesLastEvts;
    }

    public long cutId() {
        return this.cutId;
    }

    public AffinityTopologyVersion topology() {
        return this.topVer;
    }

    public Map<Object, NodeLastEvents> nodeLastEvents() {
        return this.bltNodesLastEvts.entrySet().stream().collect(Collectors.toMap(e -> e.getKey(), e -> new NodeLastEvents(((TopologyEventsTracker.LogEvents)e.getValue()).leftCutId(), ((TopologyEventsTracker.LogEvents)e.getValue()).joinCutId())));
    }

    public String toString() {
        return S.toString(TopologyEventsSnapshot.class, (Object)this);
    }
}

