/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotOperation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotSchedule;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.MoveSnapshotParams;
import org.gridgain.grid.persistentstore.SnapshotPath;

public class ScheduledSnapshotsMoving
extends ScheduledSnapshotOperation {
    private static final long serialVersionUID = 0L;

    public ScheduledSnapshotsMoving(Ignite ignite, SnapshotSchedule schedule) {
        super(ignite, schedule);
    }

    public ScheduledSnapshotsMoving(Ignite ignite, SnapshotScheduleV2 schedule) {
        super(ignite, schedule);
    }

    @Override
    public void run0(GridSnapshot snapshot) {
        List<Long> filteredSnapIds = this.filteredSnapshots(snapshot);
        if (!filteredSnapIds.isEmpty()) {
            SnapshotPath dest;
            U.log((IgniteLogger)this.log, (Object)("Found snapshots to move: " + filteredSnapIds.size()));
            if (this.schedule.getDestination().startsWith("sftp://")) {
                try {
                    dest = SnapshotPath.sftp().keyAlias(this.schedule.getKeyAlias()).uri(new URI(this.schedule.getDestination())).build();
                }
                catch (URISyntaxException e) {
                    U.warn((IgniteLogger)this.log, (Object)("Incorrect SFTP destination: " + this.schedule.getDestination() + " Reason: " + e.getMessage()));
                    return;
                }
            } else {
                dest = SnapshotPath.file().path(new File(this.schedule.getDestination())).build();
            }
            for (Long id : filteredSnapIds) {
                try {
                    snapshot.move(new MoveSnapshotParams().snapshotId(id.longValue()).destinationPath(dest).message(this.message())).get();
                }
                catch (Exception e) {
                    U.warn((IgniteLogger)this.log, (Object)("Snapshot [" + id + "] cannot be moved: " + e.getMessage()));
                }
            }
        } else {
            U.warn((IgniteLogger)this.log, (Object)"Nothing to move");
        }
    }
}

