/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.SnapshotUpdateOperationParameters;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotOperation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotSchedule;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;

public class ScheduledSnapshotsDeletion
extends ScheduledSnapshotOperation {
    private static final long serialVersionUID = 0L;

    public ScheduledSnapshotsDeletion(Ignite ignite, SnapshotSchedule schedule) {
        super(ignite, schedule);
    }

    public ScheduledSnapshotsDeletion(Ignite ignite, SnapshotScheduleV2 schedule) {
        super(ignite, schedule);
    }

    @Override
    public void run0(GridSnapshot snapshot) {
        List<Long> filteredSnapIds = this.filteredSnapshots(snapshot);
        if (!filteredSnapIds.isEmpty()) {
            U.log((IgniteLogger)this.log, (Object)("Found snapshots to delete: " + filteredSnapIds.size()));
            for (Long id : filteredSnapIds) {
                try {
                    SnapshotFuture fut = snapshot.deleteSnapshot(id.longValue(), (SnapshotUpdateOperationParameters)null, this.message());
                    fut.get();
                }
                catch (Exception e) {
                    U.warn((IgniteLogger)this.log, (Object)("Snapshot [" + id + "] cannot be deleted: " + e.getMessage()));
                }
            }
        } else {
            U.warn((IgniteLogger)this.log, (Object)"Nothing to delete");
        }
    }
}

