/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot.schedule;

import org.apache.ignite.Ignite;
import org.gridgain.grid.internal.processors.cache.database.GridSnapshotEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CustomStagesConfiguration;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledIncrementalSnapshotAwareOperation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotChainedCreation;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotCheck;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotsDeletion;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.ScheduledSnapshotsMoving;
import org.gridgain.grid.internal.processors.cache.database.snapshot.schedule.SnapshotScheduleV2;
import org.gridgain.grid.persistentstore.GridSnapshot;
import org.gridgain.grid.persistentstore.SnapshotFuture;
import org.gridgain.grid.persistentstore.SnapshotOperationType;

public class ScheduledSnapshotOperationChain
extends ScheduledIncrementalSnapshotAwareOperation {
    private static final long serialVersionUID = 0L;

    protected ScheduledSnapshotOperationChain(Ignite ignite, SnapshotScheduleV2 schedule, boolean fullSnapshotCreation) {
        super(ignite, schedule, fullSnapshotCreation);
    }

    public Runnable wrapScheduleToRunnable(Ignite ignite, SnapshotScheduleV2 schedule) {
        if (schedule.getOperationType() == SnapshotOperationType.CREATE) {
            return new ScheduledSnapshotChainedCreation(ignite, schedule, this.fullSnapshotCreation, this.incrementalSnapshotNeeded());
        }
        if (schedule.getOperationType() == SnapshotOperationType.DELETE) {
            return new ScheduledSnapshotsDeletion(ignite, schedule);
        }
        if (schedule.getOperationType() == SnapshotOperationType.MOVE) {
            return new ScheduledSnapshotsMoving(ignite, schedule);
        }
        if (schedule.getOperationType() == SnapshotOperationType.CHECK) {
            return new ScheduledSnapshotCheck(ignite, schedule);
        }
        throw new IllegalArgumentException("Inapplicable operation type: " + schedule.getOperationType());
    }

    private CustomStagesConfiguration buildStagesConfiguration() {
        CustomStagesConfiguration res = new CustomStagesConfiguration();
        res.addStage((CustomStage)new ScheduledSnapshotOperationStage(this.wrapScheduleToRunnable(this.ignite, this.schedule)));
        for (SnapshotScheduleV2 s : this.schedule.followingSchedules()) {
            res.addStage((CustomStage)new ScheduledSnapshotOperationStage(this.wrapScheduleToRunnable(this.ignite, s)));
        }
        return res;
    }

    @Override
    protected void runWhenFullSnapshotNeeded(GridSnapshot snapshot) {
        this.runInternal(snapshot);
    }

    @Override
    protected void runWhenIncrementalSnapshotNeeded(GridSnapshot snapshot) {
        this.runInternal(snapshot);
    }

    @Override
    protected boolean incrementalSnapshotNeeded() {
        return this.schedule.incrementalSnapshotNeeded();
    }

    private void runInternal(GridSnapshot snapshot) {
        GridSnapshotEx snapshotEx = (GridSnapshotEx)snapshot;
        SnapshotFuture fut = snapshotEx.customSnapshotOperation(this.buildStagesConfiguration(), null);
        fut.get();
        if (this.fullSnapshotCreation) {
            this.snapshotScheduler().lastFullSnapshotId(this.schedule.getName(), fut.snapshotOperation().snapshotId());
        }
    }
}

