/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.cluster.NodeOrderComparator;
import org.apache.ignite.internal.managers.encryption.GroupKeyEncrypted;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.resource.GridResourceProcessor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.IgniteThrowableFunction;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.spi.encryption.EncryptionSpi;
import org.apache.ignite.spi.encryption.noop.NoopEncryptionSpi;
import org.apache.ignite.thread.IgniteThreadPoolExecutor;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainFeatures;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.AtomicLongSnapshotProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CacheSnapshotMetadata;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ResultOfOperationWithSnapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptor;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotInputStream;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.SnapshotOperationIssue;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SnapshotRestoreAndCheckFuture<R>
extends SnapshotOperationFuture<R> {
    protected AtomicReference<ResultOfOperationWithSnapshot> resultOfOperation = new AtomicReference();
    protected final ConcurrentLinkedQueue<SnapshotOperationIssue> snapshotOperationIssues = new ConcurrentLinkedQueue();
    private boolean exchangelessSnapshot;
    private int parallelism;

    protected SnapshotRestoreAndCheckFuture(int protocolVersion, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter<Void> clientInitFut, @Nullable GridFutureAdapter<R> clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protocolVersion, id, initiator, initiatorId, clientInitFut, clientDoneFut, snapMgr, cctx, snapConf, snapshotMetrics);
    }

    @Override
    public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
        int snapshotOperationParallelismLevel;
        super.init(snapshotInfo);
        this.parallelism = snapshotOperationParallelismLevel = GridSnapshotOperationAttrs.getSnapshotOperationParallelism((GridSnapshotOperationEx)snapshotInfo.snapshotOperation());
        int poolSize = Math.max(1, this.parallelism - 1);
        this.executorSrvc = new IgniteThreadPoolExecutor("snapshot-restore-worker", this.cctx.igniteInstanceName(), poolSize, poolSize, 0L, new LinkedBlockingQueue());
    }

    @Override
    protected void processPayloadFromNode(UUID nodeId, byte[] payload) throws IgniteCheckedException {
        ResultOfOperationWithSnapshot unmarshal;
        if (this.stage() == this.stageForResultOfOperation() && payload != null && payload.length > 0 && (unmarshal = (ResultOfOperationWithSnapshot)((Object)this.unmarshal(payload))) != null) {
            List<SnapshotOperationIssue> issues = unmarshal.operationIssue();
            this.snapshotOperationIssues.addAll(issues);
            this.mergeWithCurrent(unmarshal);
        }
    }

    @Override
    protected byte[] getPayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        if (stage == this.stageForResultOfOperation()) {
            ResultOfOperationWithSnapshot payload = this.resultOfOperation.get();
            int issueSize = this.snapshotOperationIssues.size();
            if (issueSize != 0 && (payload.operationIssue() == null || payload.operationIssue().size() != issueSize)) {
                assert (issueSize > payload.operationIssue().size()) : "issueSize=" + issueSize + ", result.issue.size=" + payload.operationIssue().size();
                payload = new ResultOfOperationWithSnapshot(payload.partitionCountForCacheGroup(), payload.partitionIdsForCacheGroup(), new ArrayList<SnapshotOperationIssue>(this.snapshotOperationIssues));
            }
            return U.marshal((Marshaller)this.cctx.marshaller(), (Object)((Object)payload));
        }
        return super.getPayload(stage);
    }

    protected void doOperation(SnapshotRestoreStrategy stgy) throws IgniteCheckedException {
        long totalPageCntForOperation;
        SnapshotMetadataV2 metadata;
        GridKernalContext kctx = this.cctx.kernalContext();
        ClusterNode locNode = kctx.discovery().localNode();
        if (locNode.isClient() || locNode.isDaemon()) {
            this.resultOfOperation.compareAndSet(null, new ResultOfOperationWithSnapshot());
            return;
        }
        GridSnapshotOperationEx snapshotOperation = this.snapshotInfo.snapshotOperation();
        Set cacheGrpIds = snapshotOperation.cacheGroupIds();
        long snapshotId = this.snapshotInfo.snapshotId();
        IgniteBiClosure c = snapshotOperation.cacheConfigClo();
        if (c != null) {
            kctx.resource().injectGeneric((Object)c);
        }
        this.onBeforeSnapshotRead();
        Collection<SnapshotPath> paths = SnapshotPathFactory.create(GridSnapshotOperationAttrs.getOptionalPathsParameter((GridSnapshotOperationEx)snapshotOperation), this.log, this.snapMgr.config().getSftpConfiguration());
        Snapshot snapshot = this.dbSnapshotSpi.snapshot(snapshotId, paths, snapshotOperation.cacheConfigClo(), false, GridSnapshotOperationAttrs.getSecurityLevel((GridSnapshotOperationEx)snapshotOperation), true);
        if (snapshot == null) {
            if (stgy == SnapshotRestoreStrategy.RESTORE_BY_AFFINITY) {
                this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), "<whole snapshot>", -1, "No snapshot on node = " + this.cctx.localNode()));
            }
            this.onNoSnapshotOnNode(snapshotId, stgy);
            this.resultOfOperation.compareAndSet(null, new ResultOfOperationWithSnapshot());
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Doing " + this.type() + " on  snapshot: " + snapshot);
        }
        try {
            metadata = snapshot.verifiedMetadata();
            this.exchangelessSnapshot = metadata.exchangelessSnapshot();
        }
        catch (IgniteCheckedException ex) {
            this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), "<whole snapshot>", -1, ex.getMessage()));
            if (this.failFast()) {
                throw ex;
            }
            this.resultOfOperation.compareAndSet(null, new ResultOfOperationWithSnapshot());
            return;
        }
        try {
            this.beforeOperationStarted(kctx, snapshot);
        }
        catch (IgniteException ex) {
            this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), "<whole snapshot>", -1, "Couldn't read or merge snapshot metadata (workDir = " + this.dbSnapshotSpi.snapshotWorkingDirectory() + ")"));
            if (this.failFast()) {
                throw ex;
            }
            this.resultOfOperation.compareAndSet(null, new ResultOfOperationWithSnapshot());
            return;
        }
        Collection<ClusterNode> allNodes = this.getTopologyForAssignmentCalculation(this.cctx, this.topVer);
        assert (!F.isEmpty(allNodes));
        HashMap<Integer, BitSet> assignmentForGroups = new HashMap<Integer, BitSet>();
        if (stgy == SnapshotRestoreStrategy.RESTORE_BY_CONSISTENT_ID_MAPPING) {
            Set<Object> oldCIds = this.getLocalConsistentIdToRestore();
            if (F.isEmpty(oldCIds)) {
                return;
            }
            HashSet<String> oldMaskedCIds = new HashSet<String>();
            for (Object cId : oldCIds) {
                oldMaskedCIds.add(U.maskForFileName((CharSequence)cId.toString()));
            }
            assert (metadata.cacheGroupIds().equals(cacheGrpIds));
            totalPageCntForOperation = this.calcGrpPartRestoreParamsAndTotalPageCnt(metadata, oldMaskedCIds, assignmentForGroups);
        } else {
            totalPageCntForOperation = this.calculatePartitionsAndTheirSizesForGroups(snapshotId, stgy, metadata, assignmentForGroups, cacheGrpIds, allNodes);
        }
        Set assignmentGroupIds = assignmentForGroups.entrySet().stream().map((? super T entry) -> {
            Integer grpId = (Integer)entry.getKey();
            if (stgy == SnapshotRestoreStrategy.RESTORE_BY_CONSISTENT_ID_MAPPING) {
                return grpId;
            }
            BitSet partitions = (BitSet)entry.getValue();
            if (partitions != null && partitions.cardinality() != 0) {
                return grpId;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        boolean hasBrokenMetadata = false;
        IgniteCheckedException firstMetadataException = null;
        for (Snapshot previosSnapshot : snapshot.getPreviousSnapshots(assignmentGroupIds, paths)) {
            try {
                previosSnapshot.verifiedMetadata();
            }
            catch (IgniteCheckedException ex) {
                if (!hasBrokenMetadata) {
                    hasBrokenMetadata = true;
                    firstMetadataException = ex;
                } else {
                    firstMetadataException.addSuppressed((Throwable)ex);
                }
                this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), "<whole snapshot>", -1, ex.getMessage()));
            }
        }
        if (hasBrokenMetadata) {
            if (this.failFast()) {
                throw firstMetadataException;
            }
            this.resultOfOperation.compareAndSet(null, new ResultOfOperationWithSnapshot());
            return;
        }
        for (Integer grpId : assignmentGroupIds) {
            BitSet partitions = (BitSet)assignmentForGroups.get(grpId);
            if (partitions == null || partitions.cardinality() == 0) continue;
            this.doOperationOnGroup(snapshot, stgy, grpId, partitions, this.context((SnapshotProgressCalculator)new AtomicLongSnapshotProgressCalculator(totalPageCntForOperation)));
        }
        this.mergeWithCurrent(new ResultOfOperationWithSnapshot(this.getPartitionNumberForCacheGroups(metadata), assignmentForGroups, new ArrayList<SnapshotOperationIssue>(this.snapshotOperationIssues)));
    }

    protected abstract SnapshotOperationStage stageForResultOfOperation();

    protected boolean isRestoreOwnConsistentIdStrategyAvailable() {
        return GridGainFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().aliveServerNodes(), (GridGainFeatures)GridGainFeatures.SNAPSHOT_RESTORE_OWN_CONSISTENT_ID_STRATEGY);
    }

    protected Map<Integer, Set<Integer>> checkOperationResultOnCrd(Map<Integer, BitSet> partIdsForCacheGrp, Map<Integer, Integer> partCountForCacheGrp) {
        HashMap<Integer, Set<Integer>> issues = new HashMap<Integer, Set<Integer>>();
        Map<Integer, String> cacheGrpDesc = null;
        for (Map.Entry<Integer, BitSet> entry : partIdsForCacheGrp.entrySet()) {
            String descMsg;
            int grpId = entry.getKey();
            BitSet bitSet = entry.getValue();
            int partCnt = bitSet.cardinality();
            Integer partCntFromCfg = partCountForCacheGrp.get(grpId);
            if (partCntFromCfg == null) {
                if (cacheGrpDesc == null) {
                    cacheGrpDesc = this.collectCacheDescMsg();
                }
                descMsg = cacheGrpDesc.containsKey(grpId) ? cacheGrpDesc.get(grpId) : "GroupId = " + grpId;
                issues.put(grpId, null);
                this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), descMsg, -1, "Assembled snapshot from all nodes doesn't contain any partition for cache."));
                continue;
            }
            if (partCnt == partCntFromCfg) continue;
            if (cacheGrpDesc == null) {
                cacheGrpDesc = this.collectCacheDescMsg();
            }
            descMsg = cacheGrpDesc.containsKey(grpId) ? cacheGrpDesc.get(grpId) : "CacheId = " + grpId;
            ArrayList<Integer> parts = new ArrayList<Integer>();
            for (int i = 0; i < partCntFromCfg; ++i) {
                if (bitSet.get(i)) continue;
                issues.computeIfAbsent(grpId, x -> new TreeSet()).add(i);
                parts.add(i);
            }
            if (parts.isEmpty()) continue;
            this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), descMsg, -1, "Assembled snapshot from all nodes doesn't contain partitions: " + Arrays.toString(parts.toArray())));
        }
        return issues.isEmpty() ? null : issues;
    }

    protected Set<Integer> resolveGroupIds(Set<Integer> dfltCacheGrpIds) {
        Set<Integer> cacheGrpIds = this.snapshotInfo.snapshotOperation().cacheGroupIds();
        return cacheGrpIds != null ? cacheGrpIds : dfltCacheGrpIds;
    }

    private Map<Integer, String> collectCacheDescMsg() {
        HashMap<Integer, String> cacheGrpDesc = new HashMap<Integer, String>();
        GridSnapshotOperationEx op = this.snapshotInfo.snapshotOperation();
        try {
            SnapshotDescriptor desc = this.snapMgr.getSnapshotDescriptorFromCluster(op.snapshotId(), GridSnapshotOperationAttrs.getOptionalPathsParameter((GridSnapshotOperationEx)op), (IgniteBiClosure<String, CacheConfiguration, CacheConfiguration>)op.cacheConfigClo());
            if (desc == null || desc.snapshotMetadata() == null) {
                throw new IgniteException("Failed to collect snapshot descriptor: " + desc);
            }
            for (Integer cacheGroupId : this.resolveGroupIds(desc.snapshotMetadata().cacheMetadata().keySet())) {
                CacheSnapshotMetadata csm = (CacheSnapshotMetadata)desc.snapshotMetadata().cacheMetadata().get(cacheGroupId);
                Iterator iter = csm.cacheConfigurations().iterator();
                CacheConfiguration firstCfg = (CacheConfiguration)iter.next();
                SB grpDesc = new SB();
                if (!F.isEmpty((String)firstCfg.getGroupName())) {
                    grpDesc.a(firstCfg.getGroupName()).a(" [id = ").a(CU.cacheId((String)firstCfg.getGroupName())).a(", caches = [");
                }
                grpDesc.a(firstCfg.getName()).a(" [id = ").a(CU.cacheId((String)firstCfg.getName())).a("]");
                if (!iter.hasNext() && !F.isEmpty((String)firstCfg.getGroupName())) {
                    grpDesc.a("]");
                }
                while (iter.hasNext()) {
                    CacheConfiguration cCfg = (CacheConfiguration)iter.next();
                    grpDesc.a(", ").a(cCfg.getName()).a(" [id = ").a(CU.cacheId((String)cCfg.getName())).a("]");
                    if (iter.hasNext()) continue;
                    grpDesc.a("]");
                }
                grpDesc.a("]");
                cacheGrpDesc.put(cacheGroupId, grpDesc.toString());
            }
        }
        catch (IgniteCheckedException e) {
            this.log.warning("Failed to get snapshot description with id " + op.snapshotId(), (Throwable)e);
        }
        return cacheGrpDesc;
    }

    private Map<Integer, Integer> getPartitionNumberForCacheGroups(SnapshotMetadataV2 metadata) {
        if (metadata == null) {
            return null;
        }
        Set<Integer> actualCacheGrpIds = this.resolveGroupIds(metadata.cacheGroupIds());
        HashMap<Integer, Integer> partCntForCache = new HashMap<Integer, Integer>();
        for (Integer cacheGroupId : actualCacheGrpIds) {
            CacheSnapshotMetadata csm = (CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(cacheGroupId);
            CacheConfiguration firstCfg = (CacheConfiguration)csm.cacheConfigurations().iterator().next();
            int partCnt = firstCfg.getAffinity().partitions();
            partCntForCache.put(cacheGroupId, partCnt);
        }
        return partCntForCache;
    }

    private void doOperationOnGroup(Snapshot snapshot, SnapshotRestoreStrategy stgy, Integer grpId, BitSet partitions, SnapshotOperationContext context) {
        SnapshotMetadataV2 metadata = snapshot.metadata();
        CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId);
        CacheConfiguration cacheCfg = (CacheConfiguration)cacheMeta.cacheConfigurations().iterator().next();
        int pageSize = this.snapMgr.pageSize();
        if (pageSize != metadata.pageSize()) {
            throw new IgniteException("Snapshot and current configuration have different page size [current=" + pageSize + ", savedInMeta=" + metadata.pageSize() + ']');
        }
        String cId = U.maskForFileName((CharSequence)this.cctx.localNode().consistentId().toString());
        String cacheOrGrpName = cacheMeta.cacheOrGroupName();
        int partCnt = this.getTotalPartitionCount(cacheMeta);
        if (this.log.isInfoEnabled()) {
            this.log.info("Doing " + this.type() + " on cache group [grpName=" + cacheMeta.cacheOrGroupName() + ", grpId=" + grpId + ", snapshotId=" + metadata.id() + ", parts=" + partitions + ", cId=" + cId + ", stgy=" + stgy);
        }
        OperationOnGroup operationOnGroup = null;
        GridSnapshotOperationEx snapshotOperation = this.snapshotInfo.snapshotOperation();
        EncryptionSpi encSpi = this.cctx.kernalContext().config().getEncryptionSpi();
        GroupKeyEncrypted key = null;
        Map encryptionKeys = GridSnapshotOperationAttrs.getRestoreEncryptionKeys((GridSnapshotOperationEx)snapshotOperation);
        if (encryptionKeys != null) {
            assert (!(encSpi instanceof NoopEncryptionSpi));
            key = (GroupKeyEncrypted)encryptionKeys.get(grpId);
        }
        try {
            operationOnGroup = this.startOperationOnGroup(stgy, snapshot, grpId, cacheOrGrpName, cacheCfg, partitions, cId, pageSize, key, encSpi);
            operationOnGroup.init();
            OperationOnGroup finalOperationOnGroup = operationOnGroup;
            List partitionsList = IntStream.range(0, partCnt).boxed().collect(Collectors.toList());
            IgniteUtils.doInParallel((int)this.parallelism, (ExecutorService)this.executorSrvc, partitionsList, (IgniteThrowableFunction & Serializable)part -> {
                if (partitions != null && !partitions.get((int)part)) {
                    return true;
                }
                SnapshotUtils.checkSnapshotCancellation(context);
                try (SnapshotInputStream stream = this.getSnapshotInputStream(snapshot, grpId, cacheMeta, (Integer)part, cId, stgy);){
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Doing " + this.type() + " for partition: " + stream);
                    }
                    int pageCnt = finalOperationOnGroup.doJobOnPartition(stream, (int)part);
                    Map idToCntMap = (Map)cacheMeta.partitionSizesPerNode().get(part);
                    String consistentId = stream.consistentId();
                    if (!$assertionsDisabled && consistentId == null) {
                        if (consistentId != null) throw new AssertionError((Object)("consistentId=" + consistentId + ", pageCnt=" + pageCnt));
                        if (pageCnt != 0) {
                            throw new AssertionError((Object)("consistentId=" + consistentId + ", pageCnt=" + pageCnt));
                        }
                    }
                    if (consistentId == null && (idToCntMap == null || idToCntMap.isEmpty())) {
                        Boolean bl = true;
                        return bl;
                    }
                    Integer cntFromMeta = (Integer)idToCntMap.get(consistentId);
                    if (cntFromMeta == null) {
                        if (pageCnt == 0) {
                            boolean hasExpiryPlc = cacheCfg.getExpiryPolicyFactory() != null;
                            long emptyNodesCnt = idToCntMap.values().stream().filter(size -> size == 0).count();
                            if (hasExpiryPlc && emptyNodesCnt == 0L || !hasExpiryPlc && emptyNodesCnt < (long)idToCntMap.size()) {
                                this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), cacheOrGrpName, part.intValue(), "Partition was not found!"));
                                finalOperationOnGroup.onNotAnyPageReadWhileShould(grpId, (int)part);
                            }
                            Boolean bl = true;
                            return bl;
                        }
                        this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), cacheOrGrpName, part.intValue(), "Count of pages in metadata doesn't not matches with saved pages count."));
                        finalOperationOnGroup.onMetadataBroken(grpId, (int)part);
                    }
                    if (pageCnt != cntFromMeta) {
                        if (pageCnt == 0) {
                            this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), cacheOrGrpName, part.intValue(), "Partition was not found!"));
                            finalOperationOnGroup.onNotAnyPageReadWhileShould(grpId, (int)part);
                        } else {
                            this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), cacheOrGrpName, part.intValue(), "Count of pages in metadata doesn't not matches with saved pages count."));
                            finalOperationOnGroup.onNotAllPageRead(grpId, (int)part, pageCnt, cntFromMeta);
                        }
                    }
                    context.reportWork((long)pageCnt);
                    return true;
                }
                catch (Exception e) {
                    this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), cacheOrGrpName, part.intValue(), e.getMessage()));
                    finalOperationOnGroup.onError(e, (int)part);
                }
                return true;
            });
        }
        catch (Exception e) {
            throw new IgniteException((Throwable)e);
        }
        finally {
            if (operationOnGroup != null) {
                operationOnGroup.finish();
            }
        }
    }

    protected abstract OperationOnGroup startOperationOnGroup(SnapshotRestoreStrategy var1, Snapshot var2, Integer var3, String var4, CacheConfiguration var5, BitSet var6, String var7, int var8, GroupKeyEncrypted var9, EncryptionSpi var10) throws Exception;

    protected abstract boolean beforeOperationStarted(GridKernalContext var1, Snapshot var2) throws IgniteCheckedException;

    protected void onBeforeOperationStartedFailed(IgniteException ex) {
    }

    protected void onNoSnapshotOnNode(long snapshotId, SnapshotRestoreStrategy stgy) throws IgniteCheckedException {
    }

    protected void onBeforeSnapshotRead() throws IgniteCheckedException {
    }

    protected Set<Object> getLocalConsistentIdToRestore() throws IgniteCheckedException {
        Map<Object, Set<Object>> consistentIdMapping = this.getConsistentIdMapping();
        if (consistentIdMapping == null) {
            throw new IgniteCheckedException("No consistentIdMapping for stgy = RESTORE_BY_CONSISTENT_ID_MAPPING, extraParam=" + this.snapshotInfo.snapshotOperation().extraParameter());
        }
        return consistentIdMapping.get(this.cctx.localNode().consistentId());
    }

    protected Map<Object, Set<Object>> getConsistentIdMapping() {
        return (Map)((Map)this.snapshotInfo.snapshotOperation().extraParameter()).get("CONSISTENT_ID_MAPPING");
    }

    protected final int calcGrpPartRestoreParamsAndTotalPageCnt(SnapshotMetadataV2 metadata, Set<String> oldMaskedCIds, Map<Integer, BitSet> groupPartitionRestoreParams) {
        int totalPageCntForRestore = 0;
        for (Map.Entry e : metadata.cacheGroupsMetadata().entrySet()) {
            Integer grpId = (Integer)e.getKey();
            BitSet partitions = new BitSet();
            block1: for (Map.Entry e0 : ((CacheSnapshotMetadata)e.getValue()).partitionSizesPerNode().entrySet()) {
                Map cId2Cnt = (Map)e0.getValue();
                for (String oldCId : oldMaskedCIds) {
                    Integer cntr = (Integer)cId2Cnt.get(oldCId);
                    if (cntr == null) continue;
                    partitions.set((Integer)e0.getKey());
                    if (cntr < 0) {
                        for (Integer cntr0 : cId2Cnt.values()) {
                            if (cntr0 < 0) continue;
                            cntr = cntr0;
                            break;
                        }
                    }
                    assert (cntr >= 0) : "cntr is negative for partId=" + e0.getKey() + " of grpId=" + grpId + ", cntr=" + cntr + ", metadata=" + metadata;
                    totalPageCntForRestore += cntr.intValue();
                    continue block1;
                }
            }
            groupPartitionRestoreParams.put(grpId, partitions);
        }
        return totalPageCntForRestore;
    }

    protected int getTotalPartitionCount(CacheSnapshotMetadata cacheMeta) {
        return ((CacheConfiguration)cacheMeta.cacheConfigurations().stream().findFirst().get()).getAffinity().partitions();
    }

    protected Collection<ClusterNode> getTopologyForAssignmentCalculation(GridCacheSharedContext cctx, AffinityTopologyVersion topVer) {
        List baselineNodes = cctx.discovery().baselineNodes(topVer);
        if (baselineNodes == null) {
            return cctx.discovery().nodes(topVer);
        }
        ArrayList<ClusterNode> res = new ArrayList<ClusterNode>(baselineNodes);
        res.sort(NodeOrderComparator.getInstance());
        return res;
    }

    protected SnapshotInputStream getSnapshotInputStream(Snapshot snapshot, Integer grpId, CacheSnapshotMetadata cacheMeta, Integer partition, String consistentId, SnapshotRestoreStrategy strategy) {
        if (strategy == SnapshotRestoreStrategy.RESTORE_OWN_CONSISTENT_ID) {
            return snapshot.cacheInputStreams(grpId.intValue(), cacheMeta.cacheOrGroupName(), consistentId, partition.intValue());
        }
        return snapshot.cacheInputStreams(grpId.intValue(), cacheMeta.cacheOrGroupName(), partition.intValue());
    }

    protected SnapshotInputStream getSnapshotIndexStream(Snapshot snapshot, Integer grpId, BitSet partitions, String cId, SnapshotRestoreStrategy stgy) {
        if (stgy == SnapshotRestoreStrategy.RESTORE_OWN_CONSISTENT_ID) {
            return snapshot.indexStream(grpId.intValue(), cId);
        }
        return snapshot.indexStream(grpId.intValue(), partitions);
    }

    protected long calculatePageCount(CacheSnapshotMetadata cacheMeta, BitSet partitions, boolean fail) throws IgniteCheckedException {
        long totalPageCntForRestore = 0L;
        int partCnt = this.getTotalPartitionCount(cacheMeta);
        Map partCounters = cacheMeta.partitionSizesPerNode();
        block0: for (int p = 0; p < partCnt; ++p) {
            if (!partitions.get(p)) continue;
            Map map = (Map)partCounters.get(p);
            if (F.isEmpty((Map)map)) {
                if (!fail) continue;
                String msg = "Failed to find partition data on local node [partId=" + p + ", grpName=" + cacheMeta.cacheOrGroupName() + ", grpId =" + cacheMeta.groupId() + ", locNode=" + this.cctx.localNode() + ']';
                this.log.error(msg);
                throw new IgniteCheckedException(msg);
            }
            for (Integer sizeInPages : map.values()) {
                assert (sizeInPages != null);
                if (sizeInPages < 0) continue;
                totalPageCntForRestore += (long)sizeInPages.intValue();
                continue block0;
            }
        }
        return totalPageCntForRestore;
    }

    @NotNull
    protected Set<String> collectUnknownLogicalCachesToDestroy(@NotNull IgniteLogger log, @NotNull GridCacheSharedContext cctx, @NotNull Iterable<Integer> cacheGrpIds, @NotNull Collection<String> cacheNames) {
        TreeSet<String> cacheToDestroy = new TreeSet<String>();
        for (Integer cacheGrpId : cacheGrpIds) {
            CacheGroupContext grpCtx = cctx.cache().cacheGroup(cacheGrpId.intValue());
            if (grpCtx == null) {
                if (!log.isInfoEnabled()) continue;
                log.info("Group id= " + cacheGrpId + " is provided in snapshot  but not available at node.cid=" + cctx.localNode().consistentId() + ", it was probably destroyed locally");
                continue;
            }
            for (GridCacheContext cacheCtx : grpCtx.caches()) {
                String cacheName = cacheCtx.name();
                if (cacheNames.contains(cacheName) || cacheToDestroy.contains(cacheName)) continue;
                U.warn((IgniteLogger)log, (Object)("Cache group [" + grpCtx.cacheOrGroupName() + "] contains cache [" + cacheName + "] not presented in snapshot.  Cache [" + cacheName + "] is to be stopped before snapshot RESTORE"));
                cacheToDestroy.add(cacheName);
                this.snapshotOperationIssues.add(new SnapshotOperationIssue(cctx.localNodeId(), cacheName, -1, "Cache groups in snapshot contains cache [" + cacheName + "], which is not presented in snapshot. Please set snapshot restore force option or manually destroy cache : " + cacheName));
            }
        }
        return cacheToDestroy;
    }

    protected long calculatePartitionsAndTheirSizesForGroups(long snapshotId, SnapshotRestoreStrategy stgy, SnapshotMetadataV2 metadata, Map<Integer, BitSet> assignmentForGroupsAccumulator, Set<Integer> cacheGrpIds, Collection<ClusterNode> allNodes) throws IgniteCheckedException {
        long totalPageCntToRead = 0L;
        for (Integer cacheGroupId : cacheGrpIds) {
            BitSet partForGroup;
            CacheSnapshotMetadata cacheMeta = (CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(cacheGroupId);
            Collection ccfgs = cacheMeta.cacheConfigurations();
            assert (!ccfgs.isEmpty()) : "empty cache group " + cacheGroupId;
            CacheConfiguration ccfg = (CacheConfiguration)ccfgs.iterator().next();
            try {
                partForGroup = this.calcPartitions(this.cctx.localNode(), stgy, metadata, allNodes, cacheGroupId, ccfg, this.topVer, this.cctx.kernalContext().resource());
                if (partForGroup.cardinality() == 0) {
                    assignmentForGroupsAccumulator.put(CU.cacheId((String)cacheMeta.cacheOrGroupName()), partForGroup);
                    this.log.warning("No partition mapping found for cache during snapshot restore [nodeId=" + this.cctx.localNodeId() + ", cacheGroup=" + cacheMeta.cacheOrGroupName() + "]");
                    continue;
                }
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException("Can't calculate affinity assignment during " + this.type() + ", snapshotId=" + snapshotId + ", cache group=" + cacheMeta.cacheOrGroupName(), (Throwable)e);
            }
            if (stgy == SnapshotRestoreStrategy.RESTORE_BY_AFFINITY) {
                this.checkPresenceOfPartitions(cacheMeta, partForGroup);
            }
            assignmentForGroupsAccumulator.put(CU.cacheId((String)cacheMeta.cacheOrGroupName()), partForGroup);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Checking cache group: " + cacheMeta.groupId());
            }
            totalPageCntToRead += this.calculatePageCount(cacheMeta, partForGroup, this.failFast());
        }
        return totalPageCntToRead;
    }

    protected boolean failFast() {
        return this.type() != SnapshotOperationType.CHECK;
    }

    private void checkPresenceOfPartitions(CacheSnapshotMetadata cacheMeta, BitSet partitions) {
        Map partCounters = cacheMeta.partitionSizesPerNode();
        int partCnt = this.getTotalPartitionCount(cacheMeta);
        for (int i = 0; i < partCnt; ++i) {
            if (!partitions.get(partCnt) || partCounters.containsKey(i)) continue;
            this.snapshotOperationIssues.add(new SnapshotOperationIssue(this.cctx.localNodeId(), cacheMeta.cacheOrGroupName(), i, "Node doesn't contain partition which belong its by restore strategy (node = " + this.cctx.localNode() + ")"));
        }
    }

    @NotNull
    protected BitSet calcPartitions(ClusterNode locNode, SnapshotRestoreStrategy stgy, SnapshotMetadataV2 metadata, Collection<ClusterNode> allNodes, Integer grpId, CacheConfiguration<?, ?> firstCfg, AffinityTopologyVersion ver, GridResourceProcessor resourceProcessor) throws IgniteCheckedException {
        switch (stgy) {
            case RESTORE_BY_AFFINITY: {
                return this.calcOwningPartitionsForNode(resourceProcessor, allNodes, locNode, firstCfg, ver);
            }
            case RESTORE_LOCAL_PARTITIONS: {
                BitSet partitions = this.getNodePartititons(locNode, metadata, grpId);
                if (partitions.cardinality() != 0) {
                    return partitions;
                }
                partitions = new BitSet();
                Set partitionFromMeta = ((CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId)).partitionSizesPerNode().keySet();
                for (Integer integer : partitionFromMeta) {
                    partitions.set(integer);
                }
                return partitions;
            }
            case RESTORE_OWN_CONSISTENT_ID: {
                return this.getNodePartititons(locNode, metadata, grpId);
            }
        }
        throw new IgniteCheckedException("Unknown strategy " + stgy);
    }

    @NotNull
    private BitSet getNodePartititons(ClusterNode node, SnapshotMetadataV2 metadata, Integer grpId) {
        Object consistentId = node.consistentId();
        if (metadata.topology() == null) {
            throw new IgniteException("Snapshot metadata is broken! snapshotId=" + metadata.id() + ", node=" + node);
        }
        boolean participant = false;
        for (ClusterNode clusterNode : metadata.topology()) {
            if (!clusterNode.consistentId().equals(consistentId)) continue;
            participant = true;
            break;
        }
        if (!participant) {
            return new BitSet();
        }
        String cId = U.maskForFileName((CharSequence)consistentId.toString());
        BitSet partitions = new BitSet();
        for (Map.Entry e : ((CacheSnapshotMetadata)metadata.cacheGroupsMetadata().get(grpId)).partitionSizesPerNode().entrySet()) {
            if (!((Map)e.getValue()).containsKey(cId)) continue;
            partitions.set((Integer)e.getKey());
        }
        return partitions;
    }

    @NotNull
    private BitSet calcOwningPartitionsForNode(GridResourceProcessor rsrc, Collection<ClusterNode> allNodes, ClusterNode locNode, CacheConfiguration<?, ?> cfg, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        ArrayList<ClusterNode> filteredSubgrid = new ArrayList<ClusterNode>(allNodes.size());
        HashMap<UUID, BitSet> nodesToParts = new HashMap<UUID, BitSet>();
        for (ClusterNode node : allNodes) {
            if (!node.isClient() && !node.isDaemon() && cfg.getNodeFilter().apply((Object)node)) {
                filteredSubgrid.add(node);
                nodesToParts.put(node.id(), new BitSet());
                continue;
            }
            if (!node.equals(locNode)) continue;
            return new BitSet();
        }
        List<List<ClusterNode>> assignment = SnapshotUtils.calcAffinityAssignment(rsrc, filteredSubgrid, cfg, topVer);
        for (int part = 0; part < assignment.size(); ++part) {
            List<ClusterNode> nodes = assignment.get(part);
            assert (nodes != null && !nodes.isEmpty()) : String.format("The distribution by nodes could not be found for the partition, check affinity [cacheConfiguration=%s, topVer=%s, allNodes=%s, assignment=%s, part=%d]", cfg, topVer, allNodes, assignment, part);
            for (ClusterNode node : nodes) {
                BitSet parts = (BitSet)nodesToParts.get(node.id());
                parts.set(part);
            }
        }
        return (BitSet)nodesToParts.get(locNode.id());
    }

    public static ResultOfOperationWithSnapshot merge(ResultOfOperationWithSnapshot md1, ResultOfOperationWithSnapshot md2) throws IgniteCheckedException {
        if (md1 == null) {
            return md2;
        }
        if (md2 == null) {
            return md1;
        }
        HashMap<Integer, Integer> partCntForCache = new HashMap<Integer, Integer>(md1.partitionCountForCacheGroup());
        HashMap<Integer, BitSet> partForCache = new HashMap<Integer, BitSet>(md1.partitionIdsForCacheGroup());
        for (Map.Entry<Integer, Integer> entry : md2.partitionCountForCacheGroup().entrySet()) {
            Integer partCnt = entry.getValue();
            Integer prev = partCntForCache.put(entry.getKey(), partCnt);
            if (prev == null || partCnt.intValue() == prev.intValue()) continue;
            throw new IgniteCheckedException();
        }
        for (Map.Entry<Integer, Serializable> entry : md2.partitionIdsForCacheGroup().entrySet()) {
            BitSet bitSet = (BitSet)partForCache.get(entry.getKey());
            if (bitSet != null) {
                bitSet.or((BitSet)entry.getValue());
                continue;
            }
            partForCache.put(entry.getKey(), (BitSet)entry.getValue());
        }
        ArrayList<SnapshotOperationIssue> operationIssue = new ArrayList<SnapshotOperationIssue>(md1.operationIssue());
        operationIssue.addAll(md2.operationIssue());
        return new ResultOfOperationWithSnapshot(partCntForCache, partForCache, operationIssue);
    }

    private void mergeWithCurrent(ResultOfOperationWithSnapshot unmarshal) throws IgniteCheckedException {
        ResultOfOperationWithSnapshot old;
        while (!this.resultOfOperation.compareAndSet(old = this.resultOfOperation.get(), SnapshotRestoreAndCheckFuture.merge(old, unmarshal))) {
        }
    }

    protected boolean exchangelessSnapshot() {
        return this.exchangelessSnapshot;
    }

    protected static abstract class OperationOnGroup {
        private final ThreadLocal<ByteBuffer> readBuf = ThreadLocal.withInitial(this::createBuffer);
        final GroupKeyEncrypted encryptionKey;
        final EncryptionSpi encSpi;

        protected OperationOnGroup(int pageSize, GroupKeyEncrypted encryptionKey, EncryptionSpi encSpi) {
            this.encryptionKey = encryptionKey;
            this.encSpi = encSpi;
        }

        ByteBuffer readBuf() {
            return this.readBuf.get();
        }

        abstract ByteBuffer createBuffer();

        void init() throws Exception {
        }

        void finish() {
        }

        abstract int doJobOnPartition(SnapshotInputStream var1, int var2) throws IOException, IgniteCheckedException;

        void onError(Exception e, int part) throws IgniteCheckedException {
        }

        void onMetadataBroken(Integer grpId, int part) {
        }

        void onNotAnyPageReadWhileShould(Integer grpId, int part) {
        }

        void onNotAllPageRead(Integer grpId, int part, int pageCnt, Integer cntFromMeta) {
        }
    }
}

