/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteFutureTimeoutCheckedException;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.StoredCacheData;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.recovery.GridRecovery;
import org.gridgain.grid.internal.processors.cache.database.recovery.PITRParameters;
import org.gridgain.grid.internal.processors.cache.database.recovery.RecoveryCoordinatorLeftException;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.Snapshot;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotDescriptorV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotMetadataV2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotRestoreStrategy;
import org.gridgain.grid.internal.processors.cache.database.snapshot.file.SnapshotPath;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.snapshot.file.FileSnapshot;
import org.gridgain.grid.persistentstore.snapshot.file.remote.SnapshotPathFactory;
import org.jetbrains.annotations.Nullable;

public class SnapshotRecoveryFuture
extends SnapshotRestoreFuture {
    private static final long RECOVERY_TIME_OUT_INTERVAL = 60000L;
    private volatile IgniteInternalFuture<Set<Object>> scanForLeftNodesFut;
    private volatile SnapshotMetadataV2 metadata;
    private volatile SnapshotPath snapshotPath;
    private final Set<Object> leftNodes = new HashSet<Object>();
    private volatile IgniteInternalFuture<?> recoveryFut;
    @Nullable
    private volatile Boolean locSnapshot;

    SnapshotRecoveryFuture(int protoVer, @Nullable IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter<?> clientInitFut, @Nullable GridFutureAdapter<?> clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext<?, ?> cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        super(protoVer, id, initiator, initiatorId, (GridFutureAdapter)clientInitFut, (GridFutureAdapter)clientDoneFut, snapMgr, (GridCacheSharedContext)cctx, snapConf, snapshotMetrics);
    }

    @Override
    public SnapshotOperationType type() {
        return SnapshotOperationType.RECOVERY;
    }

    @Override
    public boolean doFirstStage() throws Exception {
        boolean fetch;
        super.doFirstStage();
        long id = this.snapshotInfo.snapshotId();
        GridSnapshotOperationEx op = this.snapshotInfo.snapshotOperation();
        Snapshot snapshot = this.dbSnapshotSpi.snapshot(id, SnapshotPathFactory.create(GridSnapshotOperationAttrs.getOptionalPathsParameter((GridSnapshotOperationEx)op), this.log, this.snapMgr.config().getSftpConfiguration()), op.cacheConfigClo(), false, GridSnapshotOperationAttrs.getSecurityLevel((GridSnapshotOperationEx)op), true);
        SnapshotMetadataV2 snpMetadata = null;
        Object locNodeConstId = this.cctx.localNode().consistentId();
        if (snapshot == null || (snpMetadata = snapshot.metadata()) == null) {
            fetch = true;
        } else {
            this.snapshotPath = ((FileSnapshot)snapshot).snapshotDirectory();
            this.locSnapshot = ((FileSnapshot)snapshot).isDefaultPath();
            if (GridSnapshotOperationAttrs.getRestoreStrategy((GridSnapshotOperationEx)this.snapshotInfo().snapshotOperation()) == SnapshotRestoreStrategy.RESTORE_BY_CONSISTENT_ID_MAPPING) {
                fetch = false;
            } else {
                BaselineTopology snpBlt = snpMetadata.baselineTopology();
                assert (snpBlt != null);
                boolean bl = fetch = !snpMetadata.walPoints().containsKey(snpBlt.resolveShortConsistentId(locNodeConstId));
            }
        }
        if (fetch) {
            GridCacheSnapshotManager snp = (GridCacheSnapshotManager)this.cctx.snapshot();
            try {
                SnapshotDescriptorV2 desc;
                if (this.log != null) {
                    this.log.warning("Local node does not have snapshot metadata local, try to fetch metadata from grid, localNodeConstId=" + locNodeConstId);
                }
                if ((desc = snp.getMergedSnapshotDescriptorFromClusterV2(id, null, null)) == null) {
                    throw new IgniteException("Can't find metadata in cluster for snapshot [snapshotId=" + id + "]");
                }
                snpMetadata = desc.snapshotMetadata();
                assert (snpMetadata != null);
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)("Error during fetch metadata localNodeConstId=" + locNodeConstId), (Throwable)e);
            }
        }
        this.metadata = snpMetadata;
        return true;
    }

    @Override
    protected synchronized void onNodeLeft0(ClusterNode node, boolean crd) throws IgniteCheckedException {
        super.onNodeLeft0(node, crd);
        if (!this.cctx.localNode().isClient()) {
            try {
                this.recovery().onNodeLeft(node, true);
            }
            catch (RecoveryCoordinatorLeftException e) {
                throw new IgniteCheckedException("Error during handling onNodeLeft in recovery future", (Throwable)((Object)e));
            }
        }
    }

    @Override
    protected void afterMappingsWasRestored() throws IgniteCheckedException {
        Map<Object, Object> oldNodeConsistentIdMappingOnActualConsistentId;
        Set<Object> locConsistentIds;
        SnapshotRestoreStrategy restoreStgy = GridSnapshotOperationAttrs.getRestoreStrategy((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation());
        assert (restoreStgy != null);
        Object locNodeConstId = this.cctx.localNode().consistentId();
        switch (restoreStgy) {
            case RESTORE_BY_CONSISTENT_ID_MAPPING: {
                locConsistentIds = this.getLocalConsistentIdToRestore();
                oldNodeConsistentIdMappingOnActualConsistentId = this.getMappingOldConsistentIdOnNewOne();
                break;
            }
            case RESTORE_LOCAL_PARTITIONS: {
                locConsistentIds = Collections.singleton(locNodeConstId);
                oldNodeConsistentIdMappingOnActualConsistentId = Collections.singletonMap(locNodeConstId, locNodeConstId);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported strategy = " + restoreStgy));
            }
        }
        GridRecovery recovery = this.recovery();
        assert (recovery != null);
        if (!F.isEmpty(locConsistentIds)) {
            recovery.initRecovery(new PITRParameters(this.snapshotInfo.snapshotId(), this.snapshotInfo.cacheNames(), GridSnapshotOperationAttrs.getPointInTimeParameter((GridSnapshotOperationEx)this.snapshotInfo.snapshotOperation()), this.metadata, this.topVer, locConsistentIds, oldNodeConsistentIdMappingOnActualConsistentId, this.snapshotPath, this.id, restoreStgy, this.locSnapshot));
            this.scanForLeftNodesFut = recovery.scanForLeftNodes();
            this.doneFut.listen((IgniteInClosure & Serializable)fut -> {
                try {
                    fut.get();
                    this.recovery().onRecoveryFinish(null);
                }
                catch (IgniteCheckedException e) {
                    this.recovery().onRecoveryFinish((Throwable)e);
                }
            });
            if (this.scanForLeftNodesFut.isDone() && this.scanForLeftNodesFut.error() != null) {
                throw new IgniteCheckedException(this.scanForLeftNodesFut.error());
            }
        }
    }

    @Override
    protected boolean doThirdStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        Set res;
        IgniteInternalFuture<Set<Object>> scanForLeftNodesFut;
        if (this.cctx.localNode().isClient()) {
            return true;
        }
        boolean success = this.success();
        this.completeSnapshotRestore(success);
        if (success && !this.noSnapshot && (scanForLeftNodesFut = this.scanForLeftNodesFut) != null && !F.isEmpty((Collection)(res = (Set)scanForLeftNodesFut.get()))) {
            this.leftNodes.addAll(res);
        }
        return true;
    }

    @Override
    protected boolean onThirdStageDoneCrdHook() throws IgniteCheckedException {
        if (this.leftNodes.size() > this.minBackups || this.leftNodes.size() >= this.metadata.baselineTopology().size()) {
            this.error0("WAL disabled", new UnsupportedOperationException("WAL disabled"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean onFourthStageDoneCrdHook() throws IgniteCheckedException {
        Collection<StoredCacheData> start = this.getConfigurationsToStart();
        this.startCaches(true, start, false);
        return true;
    }

    @Override
    protected boolean doFourthStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        Set unmarshal = (Set)this.unmarshal(msg.payload());
        if (unmarshal == null) {
            throw new IllegalStateException("Didn't receive collected left nodes set from crd");
        }
        if (this.scanForLeftNodesFut != null) {
            this.recovery().continueTxStateCommunication(unmarshal, this.context(null));
            this.recovery().onPartitionRestored().get();
        }
        return true;
    }

    @Override
    public void onPartitionStatesRestored(GridDhtPartitionsExchangeFuture fut) {
        if (this.stage() == SnapshotOperationStage.FOURTH) {
            try {
                this.applyWALRecords(fut);
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFinalStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws IgniteCheckedException {
        if (this.cctx.localNode().isClient() && this.scanForLeftNodesFut == null) {
            this.cctx.cache().restartProxies();
            return;
        }
        if (this.resetBranchingHistory(msg.operationId().globalId().getLeastSignificantBits())) {
            GridRecovery recovery = this.recovery();
            final CountDownLatch latch = new CountDownLatch(1);
            GridDhtPartitionsExchangeFuture fut = this.cctx.exchange().lastTopologyFuture();
            fut.listen((IgniteInClosure)new CI1<IgniteInternalFuture>(){

                public void apply(IgniteInternalFuture f) {
                    try {
                        f.get();
                    }
                    catch (IgniteCheckedException e) {
                        U.error((IgniteLogger)SnapshotRecoveryFuture.this.log, (Object)"", (Throwable)e);
                    }
                    latch.countDown();
                }
            });
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new IgniteCheckedException("Interrupt during awaiting latch", (Throwable)e);
            }
            U.log((IgniteLogger)this.log, (Object)("Start local recovery on topVer=" + fut.exchangeId().topologyVersion()));
            IgniteInternalFuture recoveryFut0 = this.recoveryFut = recovery.recoveryLocalUpdates(this.context(null));
            try {
                while (true) {
                    try {
                        recoveryFut0.get(60000L);
                    }
                    catch (IgniteFutureTimeoutCheckedException ignore) {
                        if (!this.log.isInfoEnabled()) continue;
                        this.log.info("Waiting for applying updates");
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.cctx.cache().restartProxies();
            }
        }
    }

    @Override
    protected void onFinish(Object res, Throwable err) {
        if (this.cctx.localNode().isClient() || this.cctx.localNode().isDaemon()) {
            return;
        }
        if (err == null) {
            GridSnapshotOperationEx op = this.snapshotInfo.snapshotOperation();
            for (Integer grpId : op.cacheGroupIds()) {
                CacheGroupContext c = this.cctx.cache().cacheGroup(grpId.intValue());
                if (c == null) continue;
                for (GridCacheContext cc : c.caches()) {
                    try {
                        cc.cache().rebalance().get();
                    }
                    catch (IgniteCheckedException e) {
                        U.log((IgniteLogger)this.log, (Object)("Fail wait rebalance on recovery for cache=" + cc.name() + " grp=" + c.name()), (Object)((Object)e));
                    }
                }
            }
        }
    }

    @Override
    protected SnapshotOperationStage nextStage(SnapshotOperationStage stage, boolean success) {
        if (!success) {
            return SnapshotOperationStage.CANCELLED;
        }
        switch (stage) {
            case FIRST: {
                return SnapshotOperationStage.SECOND;
            }
            case SECOND: {
                return SnapshotOperationStage.THIRD;
            }
            case THIRD: {
                return SnapshotOperationStage.FOURTH;
            }
            case FOURTH: {
                return SnapshotOperationStage.FINISH;
            }
            case CANCELLED: {
                return SnapshotOperationStage.CANCELLED;
            }
        }
        throw new AssertionError((Object)("Unexpected stage in nextStage, passed stage=" + (Object)((Object)stage)));
    }

    @Override
    protected void cancelComplete(boolean force) throws IgniteCheckedException {
        if (!this.nodeShouldSkipActiveActions() && !force) {
            GridRecovery recovery = this.recovery();
            IgniteInternalFuture<?> recoveryFut0 = this.recoveryFut;
            if (recoveryFut0 != null) {
                recoveryFut0.get();
            }
        }
        this.cctx.cache().restartProxies();
    }

    @Override
    protected byte[] getPayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        if (stage == SnapshotOperationStage.THIRD) {
            return this.cctx.marshaller().marshal(this.leftNodes);
        }
        return super.getPayload(stage);
    }

    @Override
    protected byte[] getClusterWidePayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        if (stage == SnapshotOperationStage.THIRD) {
            return this.cctx.marshaller().marshal(this.leftNodes);
        }
        return null;
    }

    @Override
    protected void processPayloadFromNode(UUID nodeId, byte[] payload) throws IgniteCheckedException {
        block6: {
            try {
                if (this.stage() == SnapshotOperationStage.THIRD) {
                    Set unmarshal;
                    try {
                        unmarshal = (Set)this.unmarshal(payload);
                    }
                    catch (ClassCastException e) {
                        this.log.error("Error while casting unmarshalled object to needed class", (Throwable)e);
                        unmarshal = null;
                    }
                    if (unmarshal != null) {
                        this.leftNodes.addAll(unmarshal);
                    }
                    break block6;
                }
                super.processPayloadFromNode(nodeId, payload);
            }
            catch (Exception ex) {
                throw new IgniteCheckedException("Error while processing payload =" + Arrays.toString(payload) + ", from node " + nodeId, (Throwable)ex);
            }
        }
    }

    @Override
    protected double adjustProgress(SnapshotOperationStage stage, double progress) {
        switch (stage) {
            case THIRD: {
                return 0.25 + progress * 0.25;
            }
            case FOURTH: {
                return 0.5 + progress * 0.25;
            }
            case FINISH: {
                return 0.75 + progress * 0.25;
            }
        }
        return progress * 0.25;
    }

    @Override
    protected boolean needExchangeOnFinish() {
        return true;
    }

    private GridRecovery recovery() {
        GridGainImpl gg = (GridGainImpl)this.cctx.kernalContext().grid().plugin("GridGain");
        return gg.provider().recovery();
    }

    @Override
    protected void updateError0(Throwable th) {
        if (this.scanForLeftNodesFut != null) {
            try {
                this.scanForLeftNodesFut.cancel();
                this.recovery().onRecoveryFinish(th);
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)"Error during cancelling WAL scan future", (Throwable)e);
            }
        }
    }

    private Map<Object, Object> getMappingOldConsistentIdOnNewOne() {
        Map<Object, Set<Object>> consistentIdMapping = this.getConsistentIdMapping();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<Object, Set<Object>> e : consistentIdMapping.entrySet()) {
            Object newCId = e.getKey();
            for (Object oldCId : e.getValue()) {
                map.put(oldCId, newCId);
            }
        }
        return map;
    }
}

