/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.pagemem.store.IgnitePageStoreManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperation;
import org.apache.ignite.internal.util.F0;
import org.apache.ignite.internal.util.GridLeanSet;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.gridgain.grid.configuration.SnapshotConfiguration;
import org.gridgain.grid.events.SnapshotEvent;
import org.gridgain.grid.internal.GridGainImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotMetricsMXBeanImpl;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationCollectStartStateFuture;
import org.gridgain.grid.internal.processors.cache.database.SnapshotOperationStage;
import org.gridgain.grid.internal.processors.cache.database.SnapshotTaskBase;
import org.gridgain.grid.internal.processors.cache.database.messages.AbstractSnapshotLifecycleMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.CancelSnapshotOperationFailedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.CancelSnapshotOperationMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.ChunkOfWorkAssignmentMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.ChunkOfWorkInProgressMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideCancelSnapshotOperationMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.ClusterWideSnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.FinishSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotIssueMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStageFinishedMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStartStateMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotProgressMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.CompressionOption;
import org.gridgain.grid.internal.processors.cache.database.snapshot.DatabaseSnapshotSpi;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationContext;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationInfoImpl;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotProgressCalculator;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotUtils;
import org.gridgain.grid.internal.processors.cache.database.snapshot.catalog.SnapshotsCatalogMessageEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.catalog.SnapshotsCatalogMessageState;
import org.gridgain.grid.internal.processors.cache.database.snapshot.catalog.SnapshotsCatalogProcessor;
import org.gridgain.grid.persistentstore.SnapshotOperationInfo;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.gridgain.grid.persistentstore.SnapshotProgress;
import org.gridgain.grid.persistentstore.SnapshotStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SnapshotOperationFuture<R>
implements IgniteInternalFuture<R> {
    public static final int SEND_REPEAT_CNT = 10;
    public static final String SNAPSHOT_OPERATION_IN_NON_CANCELABLE_STATE_MSG = "Snapshot operation in non-cancelable state!";
    public static final String SNAPSHOT_SFTP_UPLOAD_IS_NOT_SUPPORTED_MSG = "Not all nodes support upload via SFTP feature!";
    private static final int CANCEL_FAILED_STATUS = 3;
    private static final int CANCEL_SUCCEED_STATUS = 2;
    private static final int CANCEL_INITIALIZED_STATUS = 1;
    private static final int NO_CANCEL_ACTIVITY = 0;
    protected final IgniteUuid id;
    protected final int snapshotOperationParallelismLevel;
    protected volatile ExecutorService executorSrvc;
    protected final GridCacheSnapshotManager snapMgr;
    protected final GridCacheSharedContext cctx;
    protected final int protoVer;
    private final boolean initiator;
    private final UUID initiatorId;
    protected volatile ClusterNode crd;
    protected ClusterNode startCrd;
    private SnapshotOperationCollectStartStateFuture startStateFut;
    protected SnapshotOperationStartStateMessage startStateMsg;
    private final GridFutureAdapter<Void> clientInitFut;
    protected final GridFutureAdapter<Void> initFut = new GridFutureAdapter();
    protected final GridFutureAdapter<R> doneFut;
    protected volatile SnapshotOperationInfoImpl snapshotInfo;
    protected volatile AffinityTopologyVersion topVer;
    private volatile Collection<UUID> requiredAcks;
    private volatile Collection<UUID> requiredNonBltAcks;
    private volatile Collection<UUID> receivedAcks;
    protected final Map<UUID, SnapshotProgress> progressPerNode = new ConcurrentHashMap<UUID, SnapshotProgress>();
    private volatile boolean initialized;
    private volatile boolean snapNodesSetCalculated;
    protected final Object stageFieldsLock = new Object();
    protected SnapshotOperationStage stageInProgress;
    protected SnapshotOperationStage previousStage = SnapshotOperationStage.NONE;
    protected volatile R res;
    protected final AtomicReference<Throwable> error = new AtomicReference();
    protected final IgniteLogger log;
    protected volatile long lastProcessed;
    protected volatile long lastTotal;
    private volatile long lastMsgTs;
    protected final AtomicReference<T2<Boolean, GridFutureAdapter<Boolean>>> cancelFut = new AtomicReference();
    protected final AtomicBoolean checkingDoneInProgress = new AtomicBoolean();
    private volatile AffinityTopologyVersion lastKnownVer;
    protected final long snapshotThrottlingInterval;
    private final SnapshotMetricsMXBeanImpl snapshotMetrics;
    protected final GridFutureAdapter<?> crdChangeFut = new GridFutureAdapter();
    protected volatile long startTime;
    private volatile long startStageTime;
    protected final DatabaseSnapshotSpi dbSnapshotSpi;
    protected final AtomicBoolean started = new AtomicBoolean();
    protected final AtomicBoolean cpComplete = new AtomicBoolean();
    private final AtomicInteger cancelStatus = new AtomicInteger();
    protected volatile boolean notInBaseline;
    protected final AtomicBoolean destroyed = new AtomicBoolean();
    protected final AtomicBoolean cancelGuard = new AtomicBoolean();
    private final List<StageDescriptor> previousStages = new ArrayList<StageDescriptor>();

    protected SnapshotOperationFuture(int protoVer, IgniteUuid id, boolean initiator, UUID initiatorId, @Nullable GridFutureAdapter<Void> clientInitFut, @Nullable GridFutureAdapter<R> clientDoneFut, GridCacheSnapshotManager snapMgr, GridCacheSharedContext cctx, SnapshotConfiguration snapConf, SnapshotMetricsMXBeanImpl snapshotMetrics) {
        this.protoVer = protoVer;
        this.id = id;
        this.initiator = initiator;
        this.initiatorId = initiatorId;
        this.clientInitFut = clientInitFut;
        this.snapMgr = snapMgr;
        this.cctx = cctx;
        this.snapshotMetrics = snapshotMetrics;
        this.dbSnapshotSpi = snapMgr.snapshotSpi();
        GridFutureAdapter gridFutureAdapter = this.doneFut = clientDoneFut != null ? clientDoneFut : new GridFutureAdapter();
        assert (cctx != null);
        this.log = cctx.logger(SnapshotOperationFuture.class);
        assert (initiator == (clientInitFut != null));
        assert (!initiator || clientDoneFut != null);
        this.receivedAcks = new HashSet<UUID>();
        this.snapshotThrottlingInterval = snapConf.getSnapshotProgressThrottlingInterval();
        this.snapshotOperationParallelismLevel = snapConf.getSnapshotOperationParallelism();
        this.doneFut.listen((IgniteInClosure)(CI1 & Serializable)f -> {
            T2<Boolean, GridFutureAdapter<Boolean>> cancelFut = this.cancelFut.get();
            if (cancelFut != null) {
                ((GridFutureAdapter)cancelFut.get2()).onDone((Object)(f.error() != null ? 1 : 0));
            }
        });
    }

    public boolean isNotInBaseline() {
        return this.notInBaseline;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public void topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
    }

    public synchronized void map(AffinityTopologyVersion topVer) {
        assert (topVer != null) : "topVer should be not null";
        this.notInBaseline = SnapshotUtils.nodeIsNotInBaseline(this.cctx.localNode(), this.cctx, topVer);
        DiscoCache cache = this.cctx.discovery().discoCache(topVer);
        Set aliveBltNodes = cache.aliveBaselineNodes() == null ? Collections.emptySet() : cache.aliveBaselineNodes().stream().map((? super T node) -> node.id()).collect(Collectors.toSet());
        Collection aliveSrvNodes = cache.aliveServerNodes();
        HashSet<UUID> requiredAcks = new HashSet<UUID>();
        HashSet<UUID> requiredNonBltAcks = new HashSet<UUID>();
        for (ClusterNode node2 : aliveSrvNodes) {
            requiredAcks.add(node2.id());
            if (!cache.baselineNode(node2)) {
                requiredNonBltAcks.add(node2.id());
            }
            assert (!node2.isClient()) : node2;
            UUID nodeId = node2.id();
            if (!aliveBltNodes.contains(nodeId)) continue;
            int initProgress = this.receivedAcks.contains(nodeId) ? 1 : 0;
            this.progressPerNode.put(nodeId, new SnapshotProgress((long)initProgress, 1L, this.adjustProgress(SnapshotOperationStage.FIRST, initProgress), 0L));
        }
        this.requiredAcks = requiredAcks;
        this.requiredNonBltAcks = requiredNonBltAcks;
        this.crd = SnapshotUtils.getSnapshotCrd(topVer, this.cctx);
        this.topVer = topVer;
        this.snapNodesSetCalculated = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Snapshot operation future topology version is updated: requiredAcksSize=" + requiredAcks.size());
        }
    }

    public boolean initialized() {
        return this.initialized;
    }

    public GridFutureAdapter<Void> initFuture() {
        return this.initFut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentStageFinished() {
        Object object = this.stageFieldsLock;
        synchronized (object) {
            return this.stageInProgress == null;
        }
    }

    public boolean initiator() {
        return this.initiator;
    }

    public UUID initiatorNodeId() {
        return this.initiatorId;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public boolean isDone() {
        return this.doneFut.isDone();
    }

    public boolean started() {
        return this.started.get();
    }

    public SnapshotStatus snapshotStatus() {
        return new SnapshotStatus(this.id, (SnapshotOperationInfo)this.snapshotInfo, this.getProgress(), this.startTime, this.startStageTime, this.stage().ordinal(), !this.cancelable());
    }

    protected Map<UUID, SnapshotProgress> getProgress() {
        return this.progressPerNode;
    }

    public SnapshotOperationInfoImpl snapshotInfo() {
        return this.snapshotInfo;
    }

    public AffinityTopologyVersion lastKnownVersion() {
        return this.lastKnownVer;
    }

    public long startTime() {
        return this.startTime;
    }

    public abstract SnapshotOperationType type();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(SnapshotOperationInfoImpl snapshotInfo) {
        Throwable error;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Object object = this.stageFieldsLock;
        synchronized (object) {
            if (this.stageInProgress == null) {
                if (this.previousStage != SnapshotOperationStage.CANCELLED) {
                    this.stageInProgress = SnapshotOperationStage.FIRST;
                }
            } else assert (this.stageInProgress == SnapshotOperationStage.CANCELLED) : "Unexpected stage! [stageInProgress=" + (Object)((Object)this.stageInProgress) + ']';
        }
        this.snapshotInfo = snapshotInfo;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Snapshot operation has been initialized: snapshotOperation=" + this.snapshotInfo().snapshotOperation());
        }
        if (!this.success()) {
            this.error0(null, null);
        }
        if ((error = this.error()) == null) {
            this.initFut.onDone();
        } else {
            this.initFut.onDone(error);
        }
        this.fireSnapshotEvent(SnapshotOperationLifecycleStage.OP_STARTED, error);
    }

    protected void checkSecurityLevel(UUID initiatorId, GridSnapshotOperationEx snapshotOperation) throws IgniteCheckedException {
    }

    public synchronized boolean checkStartMessage(StartSnapshotOperationDiscoveryMessage msg, boolean mutableMsg) {
        if (this.isDone()) {
            return true;
        }
        if (mutableMsg) {
            try {
                this.checkSecurityLevel(msg.initiatorNodeId(), msg.snapshotOperation());
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)e.getMessage());
                msg.error((Exception)((Object)new IgniteCheckedException(e.getMessage())));
                return false;
            }
        }
        return true;
    }

    public synchronized boolean checkStartAckMessage(StartSnapshotOperationAckDiscoveryMessage msg, boolean mutableMsg) {
        return true;
    }

    public void notifyCheckpointComplete() {
        if (!this.cpComplete.compareAndSet(false, true)) {
            throw new IllegalStateException("Checkpoint complete called second time");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(AffinityTopologyVersion topVer) {
        GridSnapshotOperationEx snapOp;
        SnapshotOperationStage stageInProgress;
        boolean skipActiveActions;
        T2<Boolean, GridFutureAdapter<Boolean>> cancelPair;
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Start called second time");
        }
        if (topVer != null) {
            this.map(topVer);
        }
        assert (this.topVer != null);
        this.startStageTime = this.startTime = System.currentTimeMillis();
        if (this.crd == null) {
            this.finishWhenCoordinatorLeft();
            return;
        }
        if (this.crd.isLocal()) {
            this.crdChangeFut.onDone();
        }
        if ((cancelPair = this.cancelFut.get()) != null) {
            this.sendCancelMsg((Boolean)cancelPair.get1(), null);
        }
        if (skipActiveActions = this.nodeShouldSkipActiveActions()) {
            this.completeStagesLocally(null);
        } else {
            this.checkCurrentStageDone();
        }
        Object object = this.stageFieldsLock;
        synchronized (object) {
            stageInProgress = this.stageInProgress;
        }
        this.clientInitFutDone(null, true);
        if (this.snapshotMetrics != null && !GridSnapshotOperationAttrs.implicitSnapshotOperation((SnapshotOperation)(snapOp = this.snapshotInfo.snapshotOperation()))) {
            this.snapshotMetrics.snapshotStarted(snapOp.snapshotId(), snapOp.type());
        }
        if (stageInProgress == SnapshotOperationStage.FIRST) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Snapshot operation has been started " + this.snapshotInfo().snapshotOperation());
            }
            this.start0();
        } else if (!skipActiveActions) {
            U.warn((IgniteLogger)this.log, (Object)("Unexpected stage=" + (Object)((Object)stageInProgress) + " on snapshot operation start, locNode=" + this.cctx.localNode()));
            this.completeStagesLocally(null);
        }
    }

    private void start0() {
        UUID nid = this.cctx.localNodeId();
        final GridSnapshotOperationEx snapOp = this.snapshotInfo.snapshotOperation();
        if (this.nodeShouldSkipActiveActions()) {
            return;
        }
        if (nid.equals(this.crd.id())) {
            this.addSnapshotCatalogMessagesOnHook(this::crdStartHook);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("Snapshot worker started new snapshot operation: " + snapOp);
        }
        if (!this.notInBaseline) {
            this.submitTaskToSnapshotExecutor(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean proceedFurther;
                        if (!SnapshotOperationFuture.this.cctx.discovery().mutableCustomMessages()) {
                            SnapshotOperationFuture.this.checkSecurityLevel(SnapshotOperationFuture.this.initiatorId, snapOp);
                        }
                        if (!(proceedFurther = SnapshotOperationFuture.this.doFirstStage())) {
                            return;
                        }
                        SnapshotOperationFuture.this.logStageFinish(SnapshotOperationStage.FIRST);
                        SnapshotOperationFuture.this.completeStagesLocally(null);
                    }
                    catch (Throwable e) {
                        String msg = "Error occur while " + snapOp.type() + " snapshot operation with id = " + snapOp.snapshotId();
                        SnapshotOperationFuture.this.log.error(msg, e);
                        SnapshotOperationFuture.this.error0(msg, e);
                    }
                }
            });
        } else {
            this.logStageFinish(SnapshotOperationStage.FIRST);
            this.completeStagesLocally(null);
        }
    }

    protected final boolean tryStartCancellation() {
        return this.cancelStatus.compareAndSet(0, 1);
    }

    protected abstract boolean doFirstStage() throws Exception;

    protected boolean doSecondStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        return true;
    }

    protected boolean doThirdStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        return this.doSecondStage(msg);
    }

    protected boolean doFourthStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        return this.doSecondStage(msg);
    }

    protected boolean doFifthStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        return this.doSecondStage(msg);
    }

    protected boolean doCustomStage(ClusterNode node, ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
        return this.doSecondStage(msg);
    }

    protected void doFinalStage(ClusterWideSnapshotOperationStageFinishedMessage msg) throws Exception {
    }

    public void onMessage(UUID senderNodeId, final Object msg) {
        if (this.isDone()) {
            return;
        }
        if (msg instanceof AbstractSnapshotLifecycleMessage && !this.id.equals((Object)((AbstractSnapshotLifecycleMessage)msg).operationId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Skip message due to wrong operation id, operationId = " + this.id + ", msg= " + msg);
            }
            return;
        }
        final ClusterNode senderNode = this.cctx.node(senderNodeId);
        if (senderNode == null) {
            this.log.warning("Couldn't handle message from node " + senderNodeId + ", no cluster node for this nodeId, msg=" + msg);
            return;
        }
        if (msg instanceof SnapshotOperationStartStateMessage) {
            this.onMessage(senderNodeId, (SnapshotOperationStartStateMessage)msg);
        } else {
            this.initFut.listen((IgniteInClosure & Serializable)future -> {
                if (msg instanceof SnapshotOperationStageFinishedMessage) {
                    this.submitTaskToSnapshotExecutor(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotOperationFuture.this.onMessage(senderNode, (SnapshotOperationStageFinishedMessage)msg);
                        }
                    });
                } else if (msg instanceof ClusterWideSnapshotOperationStageFinishedMessage) {
                    this.submitTaskToSnapshotExecutor(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotOperationFuture.this.onMessage(senderNode, (ClusterWideSnapshotOperationStageFinishedMessage)msg);
                        }
                    });
                } else if (msg instanceof ClusterWideCancelSnapshotOperationMessage) {
                    this.onMessage(senderNode, (ClusterWideCancelSnapshotOperationMessage)msg);
                } else if (msg instanceof SnapshotProgressMessage) {
                    this.onMessage(senderNode, (SnapshotProgressMessage)msg);
                } else if (msg instanceof CancelSnapshotOperationMessage) {
                    this.onMessage(senderNode, (CancelSnapshotOperationMessage)msg);
                } else if (msg instanceof CancelSnapshotOperationFailedMessage) {
                    this.onMessage(senderNode, (CancelSnapshotOperationFailedMessage)msg);
                } else if (msg instanceof ChunkOfWorkInProgressMessage) {
                    this.onMessage(senderNodeId, (ChunkOfWorkInProgressMessage)msg);
                } else if (msg instanceof ChunkOfWorkAssignmentMessage) {
                    this.onMessage(senderNodeId, (ChunkOfWorkAssignmentMessage)msg);
                } else {
                    this.submitTaskToSnapshotExecutor(new Runnable(){

                        @Override
                        public void run() {
                            SnapshotOperationFuture.this.onMessage(senderNode, msg);
                        }
                    });
                }
            });
        }
    }

    protected boolean cancelable() {
        return this.stage() != SnapshotOperationStage.FINISH || !this.isSupportCancelProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error0(String msg, Throwable error) {
        SnapshotOperationStage stageInProgress;
        if (this.destroyed.get()) {
            return;
        }
        if (msg != null) {
            error = error != null ? new IgniteException(msg + ": " + error.getMessage(), error) : new IgniteException(msg);
        }
        Object object = this.stageFieldsLock;
        synchronized (object) {
            stageInProgress = this.stageInProgress;
        }
        if (this.error.get() != null && stageInProgress == null) {
            return;
        }
        this.log.warning("Snapshot operation was locally failed, error = " + error);
        if (stageInProgress != null && this.initiator) {
            assert (this.clientInitFut != null);
            this.clientInitFutDone(error, false);
        }
        this.updateError(error);
        if (stageInProgress != SnapshotOperationStage.CANCELLED) {
            this.sendLocalStageFinishMessage(stageInProgress, error, false);
        }
    }

    protected void onFinish(R res, Throwable err) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(FinishSnapshotOperationAckDiscoveryMessage msg) {
        this.shutdownExecutorService();
        if (this.isDone()) {
            return;
        }
        Object object = this.stageFieldsLock;
        synchronized (object) {
            assert (this.stageInProgress == null || this.nodeShouldSkipActiveActions()) : "stageInProgress=" + (Object)((Object)this.stageInProgress) + ", nodeShouldSkipActiveActions=" + this.nodeShouldSkipActiveActions();
        }
        if (msg != null && !msg.success()) {
            this.updateError(new IgniteException("Snapshot operation failed:" + msg.message()));
        }
        Throwable err = this.error.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Finish snapshot operation, error =  " + err + ", snapshotOperation = " + this.snapshotInfo().snapshotOperation());
        }
        if (this.clientInitFut != null && !this.clientInitFut.isDone()) {
            assert (this.nodeShouldSkipActiveActions()) : this.cctx.localNode();
            this.clientInitFutDone(null, false);
        }
        if (err != null) {
            this.cctx.cache().resetRestartingProxies();
            this.initFut.onDone(err);
            this.doneFut.onDone(err);
        } else if (this.res == null) {
            this.doneFut.onDone();
        } else {
            this.doneFut.onDone(this.res);
        }
        this.fireSnapshotEvent(SnapshotOperationLifecycleStage.OP_FINISHED, err);
        this.onFinish(this.res, err);
    }

    private void fireSnapshotEvent(SnapshotOperationLifecycleStage lifecycleStage, Throwable error) {
        Integer eventType;
        if (!GridSnapshotOperationAttrs.implicitSnapshotOperation((SnapshotOperation)this.snapshotInfo.snapshotOperation()) && (eventType = this.snapshotEventType(lifecycleStage)) != null && this.cctx.kernalContext().event().isRecordable(eventType.intValue())) {
            this.cctx.kernalContext().event().record((Event)new SnapshotEvent(this.cctx.localNode(), null, eventType.intValue(), this.snapshotInfo.snapshotId(), error));
        }
    }

    @Nullable
    protected Integer snapshotEventType(SnapshotOperationLifecycleStage lifecycleStage) {
        return null;
    }

    protected void shutdownExecutorService() {
        ExecutorService srvc = this.executorSrvc;
        if (srvc != null) {
            srvc.shutdownNow();
            try {
                srvc.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.log.warning("Exception while waiting for executor service stop", (Throwable)e);
            }
            this.executorSrvc = null;
        }
    }

    public synchronized void sendProgress(long processed, long total) {
        if (this.isDone()) {
            return;
        }
        try {
            if (this.isRequiredToSendProgress()) {
                this.lastMsgTs = U.currentTimeMillis();
                SnapshotProgressMessage msg = new SnapshotProgressMessage(this.id, processed, total);
                this.cctx.gridIO().sendToGridTopic(this.crd, GridTopic.TOPIC_SNAPSHOT, (Message)msg, (byte)2);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Sent SnapshotProgressMessage, msg = " + msg);
                }
            }
            this.lastProcessed = processed;
            this.lastTotal = total;
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send SnapshotProgressMessage.", (Throwable)e);
        }
    }

    public synchronized void onNodeLeft(final ClusterNode node, DiscoCache discoCache) {
        this.collectStartStateOnNodeLeft(node, discoCache);
        if (!this.initialized || this.isDone()) {
            return;
        }
        if (!this.snapNodesSetCalculated) {
            this.crdChangeFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

                public void apply(IgniteInternalFuture<?> fut) {
                    SnapshotOperationFuture.this.onNodeLeft(node);
                }
            });
            return;
        }
        this.onNodeLeft(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNodeLeft(ClusterNode node) {
        U.warn((IgniteLogger)this.log, (Object)("Handling node left during snapshot operation, node = " + node));
        boolean crdChanged = node.equals(this.crd);
        if (crdChanged) {
            this.crd = SnapshotUtils.getSnapshotCrd(AffinityTopologyVersion.NONE, this.cctx);
        }
        if (!this.requiredAcks.remove(node.id())) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Left node " + node + " is not in the list of requiredAcks");
            }
            return;
        }
        if (this.requiredNonBltAcks.remove(node.id())) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Left node " + node + " is not in the baseline. There is no need for special handling.");
            }
            return;
        }
        try {
            this.onNodeLeft0(node, crdChanged);
        }
        catch (IgniteCheckedException e) {
            this.error0("Error during onNodeLeft0(" + node + ')', e);
            if (crdChanged && this.crdIsLocal()) {
                this.crdChangeFut.onDone();
            }
            return;
        }
        if (crdChanged) {
            SnapshotOperationStage previousStage;
            SnapshotOperationStage stageInProgress;
            if (this.crd == null) {
                this.finishWhenCoordinatorLeft();
                return;
            }
            assert (this.requiredAcks.contains(this.crd.id()));
            if (this.crd.isLocal()) {
                this.crdChangeFut.onDone();
            }
            Object object = this.stageFieldsLock;
            synchronized (object) {
                stageInProgress = this.stageInProgress;
                previousStage = this.previousStage;
            }
            if (stageInProgress == null) {
                this.sendLocalStageFinishMessage(previousStage, null, this.success());
            } else if (!this.isNotInBaseline()) {
                this.sendProgress(this.lastProcessed, this.lastTotal);
            }
        } else if (this.crdIsLocal()) {
            this.checkCurrentStageDone();
        }
    }

    public IgniteInternalFuture<Boolean> cancelAsync(boolean force) {
        U.warn((IgniteLogger)this.log, (Object)"Cancel snapshot operation was called");
        if ((this.isDone() || !this.cancelable() && !force) && this.isSupportCancelProtocol()) {
            return new GridFinishedFuture((Throwable)new IgniteException("Snapshot operation in non-cancelable state! Operation stage = " + (Object)((Object)this.stage())));
        }
        GridFutureAdapter cancelFut = new GridFutureAdapter();
        if (this.cancelFut.compareAndSet(null, (T2<Boolean, GridFutureAdapter<Boolean>>)new T2((Object)force, (Object)cancelFut))) {
            if (this.doneFut.isDone()) {
                if (!cancelFut.isDone()) {
                    if (this.doneFut.error() != null) {
                        cancelFut.onDone(this.doneFut.error());
                    } else {
                        cancelFut.onDone((Throwable)new IgniteException("Snapshot operation in non-cancelable state! Operation stage = FINAL"));
                    }
                }
            } else {
                if (this.started.get() && !this.delayed() || this.initialized && this.delayed()) {
                    this.sendCancelMsg(force, null);
                }
                if (this.delayed() && !this.initialized) {
                    IgniteException err = new IgniteException("Snapshot operation has been cancelled");
                    this.initFut.onDone((Throwable)err);
                    this.doneFut.onDone((Throwable)err);
                }
            }
            return cancelFut;
        }
        return (IgniteInternalFuture)this.cancelFut.get().getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy(Throwable ex) {
        if (!this.destroyed.compareAndSet(false, true)) {
            U.warn((IgniteLogger)this.log, (Object)("Future was already destroyed! Snapshot future=" + this));
            return;
        }
        this.shutdownExecutorService();
        Object object = this.stageFieldsLock;
        synchronized (object) {
            this.stageInProgress = null;
        }
        U.warn((IgniteLogger)this.log, (Object)("Failing snapshot operation future: " + ex));
        IllegalStateException err = new IllegalStateException(ex);
        this.clientInitFutDone(err, false);
        this.cctx.cache().resetRestartingProxies();
        if (!this.initialized) {
            this.initFut.onDone((Throwable)err);
        }
        if (this.doneFut != null) {
            this.doneFut.onDone((Throwable)err);
        }
        this.crdChangeFut.onDone((Throwable)err);
    }

    public R get() throws IgniteCheckedException {
        return (R)this.doneFut.get();
    }

    public R get(long timeout) throws IgniteCheckedException {
        return (R)this.doneFut.get(timeout);
    }

    public R get(long timeout, TimeUnit unit) throws IgniteCheckedException {
        return (R)this.doneFut.get(timeout, unit);
    }

    public R getUninterruptibly() throws IgniteCheckedException {
        return (R)this.doneFut.getUninterruptibly();
    }

    public boolean cancel() throws IgniteCheckedException {
        return (Boolean)this.cancelAsync(false).get();
    }

    public boolean isCancelled() {
        return this.stage() == SnapshotOperationStage.CANCELLED || this.error.get() != null && this.cancelable() || this.destroyed.get();
    }

    public void listen(IgniteInClosure<? super IgniteInternalFuture<R>> lsnr) {
        this.doneFut.listen(lsnr);
    }

    public <T> IgniteInternalFuture<T> chain(IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb) {
        return this.doneFut.chain(doneCb);
    }

    public <T> IgniteInternalFuture<T> chain(IgniteClosure<? super IgniteInternalFuture<R>, T> doneCb, Executor exec) {
        return this.doneFut.chain(doneCb, exec);
    }

    public <T> IgniteInternalFuture<T> chainCompose(IgniteClosure<? super IgniteInternalFuture<R>, IgniteInternalFuture<T>> doneCb) {
        return this.doneFut.chainCompose(doneCb);
    }

    public <T> IgniteInternalFuture<T> chainCompose(IgniteClosure<? super IgniteInternalFuture<R>, IgniteInternalFuture<T>> doneCb, Executor exec) {
        return this.doneFut.chainCompose(doneCb, exec);
    }

    public Throwable error() {
        return this.doneFut.error();
    }

    public R result() {
        return (R)this.doneFut.result();
    }

    @NotNull
    protected SnapshotOperationContext context(SnapshotProgressCalculator progressCalculator) {
        return new SnapshotOperationContextImpl(progressCalculator);
    }

    protected SnapshotOperationStage nextStage(SnapshotOperationStage stage, boolean success) {
        if (!success && this.isSupportCancelProtocol()) {
            return SnapshotOperationStage.CANCELLED;
        }
        switch (stage) {
            case FIRST: {
                return SnapshotOperationStage.FINISH;
            }
            case CANCELLED: {
                return SnapshotOperationStage.CANCELLED;
            }
        }
        throw new AssertionError((Object)("Unexpected stage in nextStage, passed stage=" + (Object)((Object)stage)));
    }

    protected void onMessage(ClusterNode node, SnapshotProgressMessage msg) {
        SnapshotProgress oldVal;
        if (!this.ensureOperationIdIsCorrect(msg)) {
            return;
        }
        long processed = msg.getProcessed();
        long total = msg.getTotal();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received new progress = " + processed + "/" + total + ", from node=" + node);
        }
        if (this.isDone()) {
            return;
        }
        double newProgress = this.adjustProgress(this.stage(), (double)processed / (double)total);
        SnapshotProgress newVal = new SnapshotProgress(processed, total, newProgress, 0L);
        while (!((oldVal = this.progressPerNode.get(node.id())) == null ? this.progressPerNode.putIfAbsent(node.id(), newVal) == null : oldVal.compareTo(newVal) >= 0 || this.progressPerNode.replace(node.id(), oldVal, newVal))) {
        }
    }

    protected void crdStartHook(Collection<SnapshotsCatalogMessageEx> snapMsgs) {
        if (GridSnapshotOperationAttrs.implicitSnapshotOperation((SnapshotOperation)this.snapshotInfo.snapshotOperation())) {
            return;
        }
        snapMsgs.add(new SnapshotsCatalogMessageEx(this.snapshotInfo.snapshotOperation(), this.snapshotStatus(), SnapshotsCatalogMessageState.STARTED, this.snapshotInfo.initiatorNodeId(), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCurrentStageDone() {
        if (this.checkingDoneInProgress.get()) {
            return;
        }
        if (this.requiredAcks != null && this.receivedAcks.containsAll(this.requiredAcks)) {
            SnapshotOperationStage previousStage;
            SnapshotOperationStage stageInProgress;
            assert (this.started.get() || this.stage() == SnapshotOperationStage.CANCELLED) : "started=" + this.started.get() + ", stage=" + (Object)((Object)this.stage());
            Object object = this.stageFieldsLock;
            synchronized (object) {
                stageInProgress = this.stageInProgress;
                previousStage = this.previousStage;
            }
            if (stageInProgress != null) {
                assert (stageInProgress == SnapshotOperationStage.CANCELLED) : stageInProgress;
                return;
            }
            assert (this.crdIsLocal() && this.requiredAcks.contains(this.crd.id())) : "crd=" + this.crdIsLocal() + ", requiredAcks contains crd?" + (this.crd != null && this.requiredAcks.contains(this.crd.id())) + ", notInBaseline=" + this.notInBaseline;
            this.completeStageOnCrd(previousStage);
        } else if (this.log.isDebugEnabled()) {
            HashSet<UUID> uuids = new HashSet<UUID>(this.requiredAcks);
            uuids.removeAll(this.receivedAcks);
            this.log.debug("Still waiting for responses from next nodes: " + uuids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeStageOnCrd(SnapshotOperationStage stage) {
        if (!this.checkingDoneInProgress.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info("Stage is completed cluster-wide " + this.stageStr(stage) + ", start finishing actions on coordinator");
            }
            switch (stage) {
                case FIRST: {
                    boolean proceedFurther = this.onFirstStageDoneCrdHook();
                    if (!proceedFurther) {
                        return;
                    }
                    break;
                }
                case SECOND: {
                    boolean proceedFurther = this.onSecondStageDoneCrdHook();
                    if (!proceedFurther) {
                        return;
                    }
                    break;
                }
                case THIRD: {
                    boolean proceedFurther = this.onThirdStageDoneCrdHook();
                    if (!proceedFurther) {
                        return;
                    }
                    break;
                }
                case FOURTH: {
                    boolean proceedFurther = this.onFourthStageDoneCrdHook();
                    if (!proceedFurther) {
                        return;
                    }
                    break;
                }
                case FIFTH: {
                    boolean proceedFurther = this.onFifthStageDoneCrdHook();
                    if (!proceedFurther) {
                        return;
                    }
                    break;
                }
                case CUSTOM: {
                    boolean proceedFurther = this.onCustomStageDoneCrdHook();
                    if (!proceedFurther) {
                        return;
                    }
                    break;
                }
                case CANCELLED: 
                case FINISH: {
                    try {
                        this.onLastStageDoneCrdHook(stage);
                    }
                    catch (IgniteCheckedException ex) {
                        this.updateError(ex);
                    }
                    this.sendFinishMessage();
                    return;
                }
                default: {
                    throw new AssertionError((Object)((Object)((Object)stage) + " is not supported yet!"));
                }
            }
        }
        catch (IgniteCheckedException ex) {
            this.error0("Error during checkCurrentStageDone for stage " + (Object)((Object)stage), ex);
            return;
        }
        finally {
            this.checkingDoneInProgress.set(false);
        }
        this.sendStageFinishMessage(stage);
    }

    protected boolean onFirstStageDoneCrdHook() throws IgniteCheckedException {
        return true;
    }

    protected boolean onSecondStageDoneCrdHook() throws IgniteCheckedException {
        return true;
    }

    protected boolean onThirdStageDoneCrdHook() throws IgniteCheckedException {
        return true;
    }

    protected boolean onFourthStageDoneCrdHook() throws IgniteCheckedException {
        return true;
    }

    protected boolean onFifthStageDoneCrdHook() throws IgniteCheckedException {
        return true;
    }

    protected boolean onCustomStageDoneCrdHook() {
        return true;
    }

    protected void onLastStageDoneCrdHook(SnapshotOperationStage stage) throws IgniteCheckedException {
    }

    protected boolean needExchangeOnFinish() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendClusterWideCancelMessage(boolean force, String cancelMsg) {
        assert (this.crdIsLocal());
        try {
            assert (this.isSupportCancelProtocol());
            Object object = this.stageFieldsLock;
            synchronized (object) {
                this.stageInProgress = SnapshotOperationStage.CANCELLED;
            }
            this.receivedAcks.clear();
            final ClusterWideCancelSnapshotOperationMessage msg = new ClusterWideCancelSnapshotOperationMessage(this.id, force, cancelMsg);
            Collection<ClusterNode> nodes = this.remoteNodesToSendClusterWideMessage();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending message about finishing next cluster-wide stage, msg = " + msg);
            }
            this.safeSend(nodes, msg, (byte)2);
            this.submitTaskToSnapshotExecutor(new Runnable(){

                @Override
                public void run() {
                    SnapshotOperationFuture.this.onMessage(SnapshotOperationFuture.this.crd.id(), (Object)msg);
                }
            });
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to send ClusterWideSnapshotOperationStageFinishedMessage [force=" + force + ", cancelMsg=" + cancelMsg + ']'), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void sendStageFinishMessage(SnapshotOperationStage stage) {
        AbstractSnapshotLifecycleMessage msg;
        boolean successStageToSnd;
        assert (this.crdIsLocal() && this.isCurrentStageFinished());
        if (this.isSupportCancelProtocol() && stage != SnapshotOperationStage.CANCELLED && this.cancelStatus.get() == 2) {
            return;
        }
        this.receivedAcks.clear();
        this.startStageTime = System.currentTimeMillis();
        boolean success = this.success();
        boolean bl = successStageToSnd = stage != SnapshotOperationStage.FINISH || success;
        if (!success && this.isSupportCancelProtocol() && this.cancelable()) {
            msg = new ClusterWideCancelSnapshotOperationMessage(this.id, false, this.getErrorMessage(null));
        } else {
            try {
                msg = !this.isSupportCancelProtocol() ? new ClusterWideSnapshotOperationStageFinishedMessage(this.id, success, success ? null : this.getErrorMessage(null), this.cctx.discovery().topologyVersionEx(), this.getSnapshotIssues(), stage, this.getClusterWidePayload(stage)) : new ClusterWideSnapshotOperationStageFinishedMessage(this.id, successStageToSnd, successStageToSnd ? null : this.getErrorMessage(null), this.cctx.discovery().topologyVersionEx(), this.getSnapshotIssues(), stage, this.getClusterWidePayload(stage));
            }
            catch (IgniteCheckedException e) {
                U.error((IgniteLogger)this.log, (Object)"Failed to serialize payload for message", (Throwable)e);
                return;
            }
        }
        Collection<ClusterNode> nodes = this.remoteNodesToSendClusterWideMessage();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending message about finishing next cluster-wide stage, msg = " + msg);
        }
        this.addPreviousStage(this.wrapPreviousStage());
        Object object = this.stageFieldsLock;
        synchronized (object) {
            this.stageInProgress = this.nextStage(this.previousStage, successStageToSnd);
        }
        try {
            this.safeSend(nodes, msg, (byte)2);
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send ClusterWideSnapshotOperationStageFinishedMessage.", (Throwable)e);
        }
        this.onMessage(this.crd.id(), (Object)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPreviousStage(StageDescriptor stageDescriptor) {
        List<StageDescriptor> list = this.previousStages;
        synchronized (list) {
            if (!this.previousStages.contains(stageDescriptor)) {
                this.previousStages.add(stageDescriptor);
            }
        }
    }

    protected List<SnapshotIssueMessage> getSnapshotIssues() {
        return Collections.emptyList();
    }

    private String getErrorMessage(Throwable th) {
        if (th == null) {
            th = this.error.get();
        }
        if (th == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        th.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    protected byte[] getClusterWidePayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        return null;
    }

    protected byte[] getPreviousClusterWidePayload(StageDescriptor prevStage) throws IgniteCheckedException {
        return this.getClusterWidePayload(prevStage.stage);
    }

    protected byte[] getPayload(SnapshotOperationStage stage) throws IgniteCheckedException {
        return null;
    }

    protected void processPayloadFromNode(UUID nodeId, byte[] payload) throws IgniteCheckedException {
    }

    protected Object unmarshal(byte[] payload) throws IgniteCheckedException {
        Object o = payload == null ? null : this.cctx.marshaller().unmarshal(payload, U.gridClassLoader());
        return o;
    }

    protected void crdFinishHook(Collection<SnapshotsCatalogMessageEx> snapMsgs) {
        if (GridSnapshotOperationAttrs.implicitSnapshotOperation((SnapshotOperation)this.snapshotInfo.snapshotOperation())) {
            return;
        }
        Throwable err = this.error.get();
        SnapshotsCatalogMessageState state = err == null ? SnapshotsCatalogMessageState.FINISHED : SnapshotsCatalogMessageState.FAILED;
        UUID nid = this.cctx.localNodeId();
        snapMsgs.add(new SnapshotsCatalogMessageEx(this.snapshotInfo.snapshotOperation(), this.snapshotStatus(), state, nid, err));
    }

    private void finalizeProgressForStage(UUID nodeId, SnapshotOperationStage stage, long finishTime) {
        SnapshotProgress progress = this.progressPerNode.get(nodeId);
        double totalProgress = this.adjustProgress(stage, 1.0);
        SnapshotProgress newProgress = progress != null ? new SnapshotProgress(progress.getTotal(), progress.getTotal(), totalProgress, finishTime) : new SnapshotProgress(1L, 1L, totalProgress, finishTime);
        this.progressPerNode.put(nodeId, newProgress);
    }

    protected double adjustProgress(SnapshotOperationStage stage, double progress) {
        return progress;
    }

    protected boolean isRequiredToSendProgress() {
        return this.snapshotThrottlingInterval < 0L || !this.isDone() && U.currentTimeMillis() - this.lastMsgTs > this.snapshotThrottlingInterval;
    }

    protected void onNodeLeft0(ClusterNode node, boolean crd) throws IgniteCheckedException {
    }

    private void updateError(Throwable th) {
        U.error((IgniteLogger)this.log, (Object)("Error during snapshot operation! " + (this.snapshotInfo == null ? "Snapshot operation is null" : this.snapshotInfo().snapshotOperation())), (Throwable)th);
        this.error.compareAndSet(null, th);
        this.updateError0(th);
    }

    protected void updateError0(Throwable th) {
    }

    protected static FilePageStoreManager getStoreMgr(GridCacheSharedContext cctx) {
        if (cctx.localNode().isClient() || cctx.localNode().isDaemon()) {
            return null;
        }
        IgnitePageStoreManager store = cctx.pageStore();
        assert (store instanceof FilePageStoreManager) : "Invalid page store manager was created: " + store;
        return (FilePageStoreManager)store;
    }

    private void safeSend(Collection<? extends ClusterNode> nodes, Message msg, byte plc) throws IgniteCheckedException {
        assert (nodes != null);
        assert (msg != null);
        if (nodes.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Message will not be sent as collection of nodes is empty: " + msg);
            }
            return;
        }
        if (this.cctx.kernalContext().isStopping()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending message [msg=" + msg + ", nodes=" + U.toShortString(nodes) + ']');
        }
        GridLeanSet leftIds = new GridLeanSet();
        int cnt = 0;
        while (cnt < 10) {
            boolean added;
            try {
                Collection nodesView = F.view(nodes, (IgnitePredicate[])new IgnitePredicate[]{new P1<ClusterNode>((Collection)leftIds){
                    final /* synthetic */ Collection val$leftIds;
                    {
                        this.val$leftIds = collection;
                    }

                    public boolean apply(ClusterNode e) {
                        return !this.val$leftIds.contains(e.id());
                    }
                }});
                this.cctx.gridIO().sendToGridTopic(nodesView, GridTopic.TOPIC_SNAPSHOT, msg, plc);
                added = false;
                for (ClusterNode clusterNode : nodes) {
                    if (leftIds.contains(clusterNode.id()) || this.cctx.discovery().alive(clusterNode.id())) continue;
                    leftIds.add(clusterNode.id());
                    added = true;
                }
                if (added && !F.exist((Iterable)F.nodeIds(nodes), (IgnitePredicate[])new IgnitePredicate[]{F0.not((IgnitePredicate[])new IgnitePredicate[]{F.contains((Collection)leftIds)})})) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Message will not be sent because all nodes left topology [msg=" + msg + ", nodes=" + U.toShortString(nodes) + ']');
                    }
                    return;
                }
                break;
            }
            catch (IgniteCheckedException e) {
                added = false;
                for (ClusterNode clusterNode : nodes) {
                    if (leftIds.contains(clusterNode.id()) || this.cctx.discovery().alive(clusterNode.id()) && this.cctx.discovery().pingNode(clusterNode.id())) continue;
                    leftIds.add(clusterNode.id());
                    added = true;
                }
                if (!added) {
                    if (++cnt == 10) {
                        throw e;
                    }
                    U.sleep((long)50L);
                }
                if (!F.exist((Iterable)F.nodeIds(nodes), (IgnitePredicate[])new IgnitePredicate[]{F0.not((IgnitePredicate[])new IgnitePredicate[]{F.contains((Collection)leftIds)})})) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Message will not be sent because all nodes left topology [msg=" + msg + ", nodes=" + U.toShortString(nodes) + ']');
                    }
                    return;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Message send will be retried [msg=" + msg + ", nodes=" + U.toShortString(nodes) + ", leftIds=" + leftIds + ']');
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sent cache message [msg=" + msg + ", nodes=" + U.toShortString(nodes) + ']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMessage(ClusterNode node, final ClusterWideCancelSnapshotOperationMessage msg) {
        if (!this.ensureOperationIdIsCorrect(msg)) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received ClusterWideCancelSnapshotOperationMessage from node = " + node + ", msg= " + msg);
        }
        assert (this.isSupportCancelProtocol());
        if (this.crd == null) {
            this.map(this.cctx.discovery().topologyVersionEx());
            assert (this.crd != null && !this.crd.isLocal()) : "crd=" + this.crd;
        }
        if (!this.cancelGuard.compareAndSet(false, true)) {
            U.warn((IgniteLogger)this.log, (Object)("Duplicated ClusterWideCancelSnapshotOperationMessage from node = " + node + " msg: " + msg));
            return;
        }
        if (!this.crd.isLocal()) {
            Object object = this.stageFieldsLock;
            synchronized (object) {
                this.stageInProgress = SnapshotOperationStage.CANCELLED;
            }
            this.cancelFut.compareAndSet(null, (T2<Boolean, GridFutureAdapter<Boolean>>)new T2((Object)msg.force(), (Object)new GridFutureAdapter()));
        }
        this.updateError(new IgniteException(msg.errorMessage()));
        this.submitTaskToSnapshotExecutor(new Runnable(){

            @Override
            public void run() {
                try {
                    SnapshotOperationFuture.this.doCancel(msg);
                }
                catch (Exception e) {
                    SnapshotOperationFuture.this.error0("Error during cancelling", e);
                }
            }
        });
    }

    private void onMessage(ClusterNode node, CancelSnapshotOperationFailedMessage msg) {
        if (!this.ensureOperationIdIsCorrect(msg)) {
            return;
        }
        T2<Boolean, GridFutureAdapter<Boolean>> adapter = this.cancelFut.get();
        if (adapter == null) {
            U.warn((IgniteLogger)this.log, (Object)("Received CancelSnapshotOperationFailedMessage but cancel future is null! msg=" + msg + ", sender=" + node));
            return;
        }
        ((GridFutureAdapter)adapter.get2()).onDone((Throwable)new IgniteException("Snapshot operation in non-cancelable state!, msg=" + msg.message()));
    }

    private void doCancel(ClusterWideCancelSnapshotOperationMessage msg) throws IgniteCheckedException {
        try {
            if (this.clientInitFut != null && !this.clientInitFut.isDone()) {
                this.clientInitFutDone(null, false);
            }
            this.shutdownExecutorService();
            this.cancelComplete(msg.force());
        }
        finally {
            this.sendLocalStageFinishedMessage0(SnapshotOperationStage.CANCELLED, false, new SnapshotOperationStageFinishedMessage(this.id, SnapshotOperationStage.CANCELLED, false, System.currentTimeMillis(), this.getErrorMessage(null), null));
        }
    }

    protected boolean nodeShouldSkipActiveActions() {
        return this.cctx.localNode().isClient() || this.cctx.localNode().isDaemon() || this.notInBaseline;
    }

    protected boolean nodeShouldSkipActiveActions(ClusterNode node) {
        return node.isClient() || node.isDaemon() || SnapshotUtils.nodeIsNotInBaseline(node, this.cctx, this.topVer);
    }

    protected boolean shouldParticipateInSnapshotOperation(UUID nodeId) {
        ClusterNode snd = this.cctx.discovery().discoCache(this.topVer).node(nodeId);
        return snd != null && !snd.isClient() && !snd.isDaemon() && !SnapshotUtils.nodeIsNotInBaseline(snd, this.cctx, this.topVer);
    }

    protected void cancelComplete(boolean force) throws IgniteCheckedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void onMessage(final ClusterNode node, final ClusterWideSnapshotOperationStageFinishedMessage msg) {
        if (!this.ensureOperationIdIsCorrect(msg)) {
            return;
        }
        SnapshotOperationStage localStage = this.stage();
        SnapshotOperationStage messageStage = msg.stage();
        StageDescriptor fullStageDescription = this.wrapStage(node, msg);
        if (this.previousStages.contains(fullStageDescription) && !this.crdIsLocal()) {
            return;
        }
        if (this.crdIsLocal() || localStage == messageStage || messageStage == SnapshotOperationStage.NONE || !msg.success()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received ClusterWideSnapshotOperationFinishedMessage from node = " + node + ", msg= " + msg);
            }
            assert (msg.success() || !this.isSupportCancelProtocol()) : "Cancel message should be used or Finish message to notify nodes about error, msg=" + msg;
            try {
                this.checkAsyncStageCompleteness(msg.success(), messageStage);
            }
            catch (IgniteCheckedException e) {
                this.error0(null, e);
                return;
            }
            this.addPreviousStage(fullStageDescription);
            if (!this.crdIsLocal()) {
                Object e = this.stageFieldsLock;
                synchronized (e) {
                    SnapshotOperationStage update = this.nextStage(this.previousStage, msg.success());
                    if (this.stageInProgress != null) {
                        assert (this.stageInProgress == SnapshotOperationStage.CANCELLED) : this.stageInProgress;
                        return;
                    }
                    this.stageInProgress = update;
                }
            }
            this.startStageTime = System.currentTimeMillis();
            this.lastKnownVer = msg.ver();
            if (!msg.success()) {
                assert (!this.isSupportCancelProtocol()) : "Cancel message should be sent if need to cancel operation with protocov v.2";
                this.updateError(new IgniteException(msg.errorMessage()));
                this.submitTaskToSnapshotExecutor(new Runnable(){

                    @Override
                    public void run() {
                        SnapshotOperationFuture.this.completeStagesLocally(msg);
                    }
                });
            } else {
                final boolean shouldSkipActiveActions = this.nodeShouldSkipActiveActions();
                assert (this.started.get() && this.initialized && !this.isCurrentStageFinished() || shouldSkipActiveActions) : "started = " + this.started.get() + ", initialized = " + this.initialized + ", isCurrentStageFinished = " + this.isCurrentStageFinished() + ", shouldSkipActiveActions = " + shouldSkipActiveActions + ", crd = " + this.crd.isLocal() + ", nodeId = " + node;
                this.submitTaskToSnapshotExecutor(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        SnapshotOperationStage stage;
                        Object object = SnapshotOperationFuture.this.stageFieldsLock;
                        synchronized (object) {
                            stage = SnapshotOperationFuture.this.stageInProgress;
                        }
                        assert (stage != null);
                        if (stage == SnapshotOperationStage.CANCELLED) {
                            return;
                        }
                        if (!shouldSkipActiveActions) {
                            boolean proceedFurther;
                            try {
                                switch (stage) {
                                    case SECOND: {
                                        proceedFurther = SnapshotOperationFuture.this.doSecondStage(msg);
                                        break;
                                    }
                                    case THIRD: {
                                        proceedFurther = SnapshotOperationFuture.this.doThirdStage(msg);
                                        break;
                                    }
                                    case FOURTH: {
                                        proceedFurther = SnapshotOperationFuture.this.doFourthStage(msg);
                                        break;
                                    }
                                    case FIFTH: {
                                        proceedFurther = SnapshotOperationFuture.this.doFifthStage(msg);
                                        break;
                                    }
                                    case FINISH: {
                                        proceedFurther = true;
                                        break;
                                    }
                                    case CUSTOM: {
                                        proceedFurther = SnapshotOperationFuture.this.doCustomStage(node, msg);
                                        break;
                                    }
                                    default: {
                                        throw new AssertionError();
                                    }
                                }
                                if (stage != SnapshotOperationStage.FINISH) {
                                    SnapshotOperationFuture.this.logStageFinish(stage);
                                }
                            }
                            catch (Throwable e) {
                                String errMsg = "Error occur while " + SnapshotOperationFuture.this.snapshotInfo.snapshotOperation().type() + " snapshot operation with id = " + SnapshotOperationFuture.this.snapshotInfo.snapshotId();
                                SnapshotOperationFuture.this.log.error(errMsg, e);
                                SnapshotOperationFuture.this.error0(errMsg, e);
                                return;
                            }
                            if (!proceedFurther) {
                                return;
                            }
                        }
                        SnapshotOperationFuture.this.completeStagesLocally(msg, stage);
                    }
                });
            }
        } else {
            U.warn((IgniteLogger)this.log, (Object)("Received message with wrong stage [curStage=" + (Object)((Object)localStage) + ", msg=" + msg + ", node=" + node + ']'));
        }
    }

    private boolean ensureOperationIdIsCorrect(AbstractSnapshotLifecycleMessage msg) {
        if (this.id.equals((Object)msg.operationId())) {
            return true;
        }
        this.error0("Received message with wrong id, operationId = " + this.id + ", msg = " + msg, null);
        return false;
    }

    protected void checkAsyncStageCompleteness(boolean success, SnapshotOperationStage stage) throws IgniteCheckedException {
    }

    protected void finishAsyncStage() {
        SnapshotOperationStage localStage = this.stage();
        this.markStageAsFinished(localStage, true);
        this.completeStageOnCrd(localStage);
    }

    private void completeStagesLocally(ClusterWideSnapshotOperationStageFinishedMessage msg) {
        this.completeStagesLocally(msg, this.stage());
    }

    protected void completeStagesLocally(ClusterWideSnapshotOperationStageFinishedMessage msg, SnapshotOperationStage localStageToComplete) {
        assert (this.started.get());
        if (this.log.isDebugEnabled()) {
            this.log.debug("Snapshot operation next stage was locally finished, stage=" + (Object)((Object)localStageToComplete));
        }
        if (localStageToComplete == SnapshotOperationStage.CANCELLED || localStageToComplete == SnapshotOperationStage.FINISH) {
            try {
                this.doFinalStage(msg);
            }
            catch (Exception e) {
                this.error0("Error during doing FINISH stage", e);
                try {
                    this.cancelComplete(false);
                }
                catch (IgniteCheckedException ex) {
                    this.error0("Error during cancelling local operation after FINISH stage failure", ex);
                }
                return;
            }
            this.logStageFinish(localStageToComplete);
        }
        this.snapMgr.notifyLocalStageCompletedListeners(this, localStageToComplete);
        this.sendLocalStageFinishMessage(localStageToComplete, null, this.success());
    }

    protected boolean success() {
        return this.error.get() == null;
    }

    private void sendLocalStageFinishMessage(SnapshotOperationStage stage, Throwable th, boolean success) {
        try {
            AbstractSnapshotLifecycleMessage msg = !success && this.isSupportCancelProtocol() && this.cancelable() ? new CancelSnapshotOperationMessage(this.id, false, this.getErrorMessage(th)) : new SnapshotOperationStageFinishedMessage(this.id, stage, success, System.currentTimeMillis(), this.getErrorMessage(th), this.getPayload(stage));
            this.sendLocalStageFinishedMessage0(stage, success, msg);
        }
        catch (IgniteCheckedException e) {
            this.error0("Error during sending stage finish message", e);
        }
    }

    private void sendLocalStageFinishedMessage0(SnapshotOperationStage stage, boolean success, Message msg) {
        this.markStageAsFinished(stage, success);
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info("Sending message about finishing local stage, msg = " + msg);
            }
            this.cctx.gridIO().sendToGridTopic(this.crd, GridTopic.TOPIC_SNAPSHOT, msg, (byte)2);
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send SnapshotOperationStageFinishedMessage.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markStageAsFinished(SnapshotOperationStage stage, boolean success) {
        Object object = this.stageFieldsLock;
        synchronized (object) {
            if (this.stageInProgress == stage) {
                this.stageInProgress = null;
                this.previousStage = stage;
            } else assert (!success || this.stageInProgress == SnapshotOperationStage.CANCELLED || this.stageInProgress == null) : this.stageInProgress;
        }
    }

    protected synchronized boolean cancelSnapshotOperationOnCrd(ClusterNode node, boolean force, String errorMsg, @Nullable Exception cause) {
        if (!this.cancelable() && !force) {
            this.cancelStatus.set(3);
            return false;
        }
        this.cancelStatus.set(2);
        String msg = "Failed to finish snapshot operation [operationId=" + this.id + ", operationType=" + this.type() + ", node=" + node + ", reason='" + errorMsg + "']";
        U.warn((IgniteLogger)this.log, (Object)("Cancel snapshot operation with msg = " + msg));
        IgniteCheckedException error = new IgniteCheckedException(msg, (Throwable)cause);
        this.updateError(error);
        this.cancelFut.compareAndSet(null, (T2<Boolean, GridFutureAdapter<Boolean>>)new T2((Object)force, (Object)new GridFutureAdapter()));
        if (this.isSupportCancelProtocol()) {
            this.sendClusterWideCancelMessage(force, msg);
        }
        return true;
    }

    private void sendCancelMsg(boolean force, String msg) {
        msg = F.isEmpty((String)msg) ? "Snapshot operation has been cancelled" : msg;
        try {
            if (this.isSupportCancelProtocol()) {
                if (this.crd != null) {
                    this.cctx.gridIO().sendToGridTopic(this.crd, GridTopic.TOPIC_SNAPSHOT, (Message)new CancelSnapshotOperationMessage(this.id, force, msg), (byte)2);
                }
            } else if (this.crd != null) {
                this.cctx.gridIO().sendToGridTopic(this.crd, GridTopic.TOPIC_SNAPSHOT, (Message)new SnapshotOperationStageFinishedMessage(this.id, this.stage(), false, System.currentTimeMillis(), "Snapshot operation has been cancelled", null), (byte)2);
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send SnapshotOperationStageFinishedMessage.", (Throwable)e);
        }
    }

    protected boolean isSupportCancelProtocol() {
        return true;
    }

    protected boolean isSupportSftpDestination() {
        return IgniteFeatures.allNodesSupports((GridKernalContext)this.cctx.kernalContext(), (Iterable)this.cctx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_SFTP_UPLOAD_V2);
    }

    private void finishWhenCoordinatorLeft() {
        this.updateError(new IgniteException("Failed to complete snapshot operation (all cache nodes left the grid): " + this.snapshotInfo));
        this.finish(null);
    }

    protected synchronized void onMessage(final ClusterNode senderNode, final SnapshotOperationStageFinishedMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received SnapshotOperationFinishedMessage from node = " + senderNode + ", msg= " + msg);
        }
        if (!this.ensureOperationIdIsCorrect(msg)) {
            return;
        }
        if (!this.crdIsLocal()) {
            this.crdChangeFut.listen((IgniteInClosure)new CI1<IgniteInternalFuture<?>>(){

                public void apply(IgniteInternalFuture<?> f) {
                    try {
                        f.get();
                        SnapshotOperationFuture.this.onMessage(senderNode, msg);
                    }
                    catch (IgniteCheckedException igniteCheckedException) {
                        // empty catch block
                    }
                }
            });
            return;
        }
        this.initFut.listen((IgniteInClosure & Serializable)lsnr -> {
            if (this.initFut.error() != null) {
                return;
            }
            SnapshotOperationStage localStage = this.stage();
            SnapshotOperationStage messageStage = msg.stage();
            if (this.id.equals((Object)msg.operationId())) {
                if (!msg.success() && this.cancelStatus.compareAndSet(0, 1)) {
                    if (!this.initialized) {
                        return;
                    }
                    if (this.cancelSnapshotOperationOnCrd(senderNode, false, msg.errorMessage(), null)) {
                        if (this.isSupportCancelProtocol()) {
                            return;
                        }
                    } else {
                        this.updateError(new IgniteException(msg.errorMessage()));
                    }
                }
                if (messageStage == localStage) {
                    if (!SnapshotUtils.nodeIsNotInBaseline(senderNode, this.cctx, null)) {
                        this.finalizeProgressForStage(senderNode.id(), messageStage, msg.getFinishTime());
                    }
                    try {
                        this.processPayloadFromNode(senderNode.id(), msg.payload());
                        this.onAckReceived(senderNode, messageStage);
                    }
                    catch (IgniteCheckedException e) {
                        this.error0("Error during handling SnapshotOperationStageFinishedMessage from node " + senderNode, e);
                    }
                } else if (messageStage == SnapshotOperationStage.CANCELLED) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Received message with stage=CANCELLED but success=true from node " + senderNode + ": " + msg);
                    }
                } else {
                    U.warn((IgniteLogger)this.log, (Object)("Received message with wrong stage [msg=" + msg + ", id=" + this.id + ", node=" + senderNode + "], local stage = " + (Object)((Object)localStage) + ", proceeding to stage recovery"));
                    this.handleMismatchedAckMessage(senderNode, msg);
                }
            } else {
                U.warn((IgniteLogger)this.log, (Object)("Received message with wrong id [msg=" + msg + ", id=" + this.id + ", node=" + senderNode + ']'));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleMismatchedAckMessage(ClusterNode senderNode, SnapshotOperationStageFinishedMessage msg) {
        byte[] payload;
        SnapshotOperationStage targetStage;
        boolean isBehind;
        if (this.nodeShouldSkipActiveActions(senderNode)) {
            return;
        }
        SnapshotOperationStage localStage = this.stage();
        SnapshotOperationStage messageStage = msg.stage();
        if (msg.stage() == SnapshotOperationStage.CANCELLED) {
            throw new IllegalArgumentException("A message with stage CANCELLED was received, it should not get here! " + msg);
        }
        StageDescriptor fullStageDescription = this.wrapStage(senderNode, msg);
        if (localStage == SnapshotOperationStage.CANCELLED) {
            return;
        }
        boolean bl = isBehind = !this.previousStages.contains(fullStageDescription);
        if (isBehind) {
            targetStage = localStage;
            if (this.log.isInfoEnabled()) {
                this.log.info("Coordinator is behind: stage = " + (Object)((Object)localStage) + ", message stage = " + (Object)((Object)messageStage) + ", node = " + senderNode);
            }
        } else {
            targetStage = messageStage;
            if (this.log.isInfoEnabled()) {
                this.log.info("Coordinator is ahead: stage = " + (Object)((Object)localStage) + ", message stage = " + (Object)((Object)messageStage) + ", node = " + senderNode);
            }
        }
        try {
            if (isBehind) {
                payload = this.getClusterWidePayload(targetStage);
            } else {
                if (this.previousStages.isEmpty()) {
                    U.error((IgniteLogger)this.log, (Object)"previousStages is empty");
                    return;
                }
                StageDescriptor lastSeenStage = this.previousStages.get(this.previousStages.size() - 1);
                payload = this.getPreviousClusterWidePayload(lastSeenStage);
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to serialize payload for message", (Throwable)e);
            return;
        }
        ClusterWideSnapshotOperationStageFinishedMessage recoveryMsg = new ClusterWideSnapshotOperationStageFinishedMessage(this.id, true, null, this.cctx.discovery().topologyVersionEx(), this.getSnapshotIssues(), targetStage, payload);
        if (isBehind) {
            this.receivedAcks.clear();
            this.addPreviousStage(this.wrapPreviousStage());
            Object object = this.stageFieldsLock;
            synchronized (object) {
                this.stageInProgress = this.nextStage(localStage, true);
            }
            this.onMessage(this.crd, recoveryMsg);
        }
        Collection<ClusterNode> nodes = this.remoteNodesToSendClusterWideMessage();
        if (this.log.isInfoEnabled()) {
            this.log.info("Sending a follow up recovery message about finishing cluster-wide stage, msg = " + recoveryMsg + ", nodes = " + nodes);
        }
        try {
            this.safeSend(nodes, recoveryMsg, (byte)2);
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send a follow up ClusterWideSnapshotOperationStageFinishedMessage.", (Throwable)e);
        }
        if (isBehind) {
            this.submitTaskToSnapshotExecutor(() -> this.onMessage(senderNode, msg));
        }
    }

    private Collection<ClusterNode> remoteNodesToSendClusterWideMessage() {
        ClusterNode initiator;
        HashSet<ClusterNode> nodes = this.cctx.discovery().remoteNodes();
        if (!this.initiator && (initiator = this.cctx.node(this.initiatorId)) != null && initiator.isClient() && this.cctx.discovery().alive(initiator)) {
            nodes = new HashSet<ClusterNode>(nodes);
            nodes.add(initiator);
        }
        return nodes;
    }

    public boolean crdIsLocal() {
        return this.crd != null && this.crd.isLocal();
    }

    private void onMessage(final ClusterNode node, final CancelSnapshotOperationMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received CancelSnapshotOperationMessage from node = " + node + ", msg= " + msg);
        }
        assert (this.isSupportCancelProtocol());
        if (!this.ensureOperationIdIsCorrect(msg)) {
            return;
        }
        if (!this.crdIsLocal()) {
            this.crdChangeFut.listen((IgniteInClosure)new CI1<IgniteInternalFuture<?>>(){

                public void apply(IgniteInternalFuture<?> f) {
                    try {
                        f.get();
                        SnapshotOperationFuture.this.onMessage(node, msg);
                    }
                    catch (IgniteCheckedException igniteCheckedException) {
                        // empty catch block
                    }
                }
            });
            return;
        }
        if (!this.initialized) {
            return;
        }
        if (!this.cancelable() && !msg.force()) {
            if (this.stage() == SnapshotOperationStage.CANCELLED) {
                return;
            }
            String msg0 = "Received snapshot operation cancel request while was in not cancelable state, stage=" + (Object)((Object)this.stage());
            U.warn((IgniteLogger)this.log, (Object)msg0);
            this.sendCancelFailedMessage(node, msg0);
            return;
        }
        if (this.tryStartCancellation() && !this.cancelSnapshotOperationOnCrd(node, msg.force(), msg.errorMessage(), (Exception)((Object)new IgniteCheckedException(msg.errorMessage())))) {
            this.sendCancelFailedMessage(node, "Cancel failed on coordinator.");
        }
    }

    private void sendCancelFailedMessage(ClusterNode node, String msg) {
        try {
            this.cctx.gridIO().sendToGridTopic(node, GridTopic.TOPIC_SNAPSHOT, (Message)new CancelSnapshotOperationFailedMessage(this.id, msg), (byte)2);
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)("Error while sending CancelSnapshotOperationFailedMessage to node=" + node), (Throwable)e);
        }
    }

    protected synchronized void onMessage(ClusterNode node, Object msg) {
    }

    private void logStageFinish(SnapshotOperationStage stage) {
        if (this.log.isInfoEnabled()) {
            GridSnapshotOperationEx snapOp = this.snapshotInfo.snapshotOperation();
            this.log.info("Finished " + this.stageStr(stage) + " stage of snapshot operation " + snapOp.type() + " " + this.stageStr(this.stage()) + " at " + SnapshotTaskBase.LOG_DATE_FORMAT.format(Instant.now()) + " [snapshotId=" + snapOp.snapshotId() + ", caches=" + snapOp.cacheNames() + ", " + SnapshotTaskBase.buildInitiatorMessage(this.cctx.localNodeId(), this.initiatorNodeId()) + ", msg='" + snapOp.message() + "']");
        }
    }

    protected String stageStr(SnapshotOperationStage stage) {
        return String.valueOf((Object)stage);
    }

    private void addSnapshotCatalogMessages(final Collection<SnapshotsCatalogMessageEx> snapMsgs) {
        this.submitTaskToSnapshotExecutor(new Runnable(){

            @Override
            public void run() {
                GridGainImpl gg = (GridGainImpl)SnapshotOperationFuture.this.cctx.kernalContext().grid().plugin("GridGain");
                SnapshotsCatalogProcessor catalog = (SnapshotsCatalogProcessor)gg.provider().getSnapshotsCatalog();
                if (catalog != null) {
                    catalog.addMessages(snapMsgs);
                }
            }
        });
    }

    private void addSnapshotCatalogMessagesOnHook(Consumer<Collection<SnapshotsCatalogMessageEx>> msgAdder) {
        ArrayList<SnapshotsCatalogMessageEx> msgs = new ArrayList<SnapshotsCatalogMessageEx>();
        msgAdder.accept(msgs);
        if (!msgs.isEmpty()) {
            this.addSnapshotCatalogMessages(msgs);
        }
    }

    protected final synchronized void onAckReceived(final ClusterNode node, final SnapshotOperationStage msgStage) {
        boolean added;
        if (this.isDone()) {
            return;
        }
        if (!this.crdChangeFut.isDone()) {
            this.crdChangeFut.listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

                public void apply(IgniteInternalFuture<?> fut) {
                    try {
                        fut.get();
                    }
                    catch (IgniteCheckedException e) {
                        U.warn((IgniteLogger)SnapshotOperationFuture.this.log, (Object)"Failed to get a new snapshot coordinator.", (Throwable)e);
                    }
                    SnapshotOperationFuture.this.onAckReceived(node, msgStage);
                }
            });
            return;
        }
        boolean bl = added = (this.stage() == msgStage || !this.isSupportCancelProtocol()) && this.receivedAcks.add(node.id());
        if (!added) {
            U.warn((IgniteLogger)this.log, (Object)("Duplicate message [node=" + node + ", name=" + node.hostNames() + ", stage=" + (Object)((Object)this.stage()) + ", msgState=" + (Object)((Object)msgStage) + ", receivedAcks=" + this.receivedAcks + ", requiredAcks=" + this.requiredAcks + "]"));
            return;
        }
        if (this.requiredAcks == null || !this.requiredAcks.contains(node.id())) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Not required ack received from [node=" + node + " , requiredAcks=" + this.requiredAcks + "]");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received ack from node " + node);
        }
        this.checkCurrentStageDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotOperationStage stage() {
        if (this.destroyed.get()) {
            return SnapshotOperationStage.CANCELLED;
        }
        Object object = this.stageFieldsLock;
        synchronized (object) {
            return this.stageInProgress == null ? this.previousStage : this.stageInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFinishMessage() {
        try {
            Object object = this.stageFieldsLock;
            synchronized (object) {
                assert (this.initialized && (this.started.get() || this.isCancelled()) && this.stageInProgress == null) : "Unexpected state while trying to send operation finish message: initialized=" + this.initialized + " && (started=" + this.started.get() + "|| isCancelled() =" + this.isCancelled() + ") && (stageInProgress == null? " + (Object)((Object)this.stageInProgress) + ")";
            }
            boolean success = this.success();
            FinishSnapshotOperationAckDiscoveryMessage msg = new FinishSnapshotOperationAckDiscoveryMessage(this.id, success, this.needExchangeOnFinish(), this.getErrorMessage(null));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Sending finish message, msg = " + msg);
            }
            this.cctx.discovery().sendCustomEvent((DiscoveryCustomMessage)msg);
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send FinishSnapshotOperationAckDiscoveryMessage.", (Throwable)e);
        }
        finally {
            this.addSnapshotCatalogMessagesOnHook(this::crdFinishHook);
        }
    }

    protected void sendWorkAssignmentMessage(UUID id, ChunkOfWorkAssignmentMessage msg) {
        try {
            this.cctx.gridIO().sendToGridTopic(id, GridTopic.TOPIC_SNAPSHOT, (Message)msg, (byte)2);
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send ChunkOfWorkAssignmentMessage.", (Throwable)e);
        }
    }

    protected void sendWorkInProgressMessage(ChunkOfWorkInProgressMessage msg) {
        assert (this.crd != null);
        try {
            this.cctx.gridIO().sendToGridTopic(this.crd, GridTopic.TOPIC_SNAPSHOT, (Message)msg, (byte)2);
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)"Failed to send ChunkOfWorkAssignmentMessage.", (Throwable)e);
        }
    }

    public boolean delayed() {
        return false;
    }

    private void collectStartStateOnNodeLeft(ClusterNode node, DiscoCache discoCache) {
        if (this.startStateFut != null) {
            this.startStateFut.onNodeLeft(node.id());
        } else if (this.startStateMsg != null && node.equals(this.startCrd)) {
            this.startCrd = this.cctx.discovery().oldestAliveServerNode(AffinityTopologyVersion.NONE);
            assert (this.startCrd != null);
            if (this.startCrd.isLocal()) {
                this.initStartStateFuture(discoCache);
            } else {
                this.sendStartStateMessage(this.startCrd, this.startStateMsg);
            }
        }
    }

    protected void sendStartStateMessage(ClusterNode crd, SnapshotOperationStartStateMessage startStateMsg) {
        try {
            this.cctx.gridIO().sendToGridTopic(crd, GridTopic.TOPIC_SNAPSHOT, (Message)startStateMsg, (byte)2);
        }
        catch (ClusterTopologyCheckedException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed to send start state message to coordinator, node failed [opId=" + this.id + ", crd=" + crd.id() + ']');
            }
        }
        catch (IgniteCheckedException e) {
            U.error((IgniteLogger)this.log, (Object)("Failed to send start state message to coordinator [opId=" + this.id + ']'), (Throwable)e);
        }
    }

    private void onMessage(UUID nodeId, SnapshotOperationStartStateMessage msg) {
        if (this.id.equals((Object)msg.operationId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received SnapshotOperationStartStateMessage [node=" + nodeId + ", msg=" + msg + ']');
            }
            if (this.startStateFut == null) {
                this.startStateFut = new SnapshotOperationCollectStartStateFuture(this.cctx);
            }
            this.startStateFut.onMessage(nodeId, msg);
        } else {
            U.warn((IgniteLogger)this.log, (Object)("Received SnapshotOperationStartStateMessage message with wrong id [node=" + nodeId + ", opId=" + this.id + ", msgOpId" + msg.operationId() + ", msg=" + msg + ']'));
        }
    }

    private void onMessage(UUID nodeId, ChunkOfWorkInProgressMessage msg) {
        if (this.id.equals((Object)msg.operationId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received ChunkOfWorkInProgressMessage [node=" + nodeId + ", msg=" + msg + ']');
            }
            this.onChunkOfWorkInProgressReceived(nodeId, msg);
        } else {
            U.warn((IgniteLogger)this.log, (Object)("Received ChunkOfWorkInProgressMessage message with wrong id [node=" + nodeId + ", opId=" + this.id + ", msgOpId" + msg.operationId() + ", msg=" + msg + ']'));
        }
    }

    protected void onChunkOfWorkInProgressReceived(UUID nodeId, ChunkOfWorkInProgressMessage msg) {
    }

    private void onMessage(UUID nodeId, ChunkOfWorkAssignmentMessage msg) {
        if (this.id.equals((Object)msg.operationId())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received ChunkOfWorkAssignmentMessage [node=" + nodeId + ", msg=" + msg + ']');
            }
            this.onChunkOfWorkAssignmentReceived(msg);
        } else {
            U.warn((IgniteLogger)this.log, (Object)("Received ChunkOfWorkAssignmentMessage message with wrong id [node=" + nodeId + ", opId=" + this.id + ", msgOpId" + msg.operationId() + ", msg=" + msg + ']'));
        }
    }

    protected void onChunkOfWorkAssignmentReceived(ChunkOfWorkAssignmentMessage msg) {
    }

    protected ClassLoader getLdr() {
        return U.resolveClassLoader((IgniteConfiguration)this.cctx.gridConfig());
    }

    protected void initStartStateFuture(DiscoCache discoCache) {
        assert (this.startStateMsg != null);
        if (this.startStateFut == null) {
            this.startStateFut = new SnapshotOperationCollectStartStateFuture(this.cctx);
        }
        this.startStateFut.init(discoCache, this.startStateMsg.startMessage());
        this.startStateFut.listen((IgniteInClosure)new IgniteInClosure<IgniteInternalFuture<StartSnapshotOperationAckDiscoveryMessage>>(){

            public void apply(IgniteInternalFuture<StartSnapshotOperationAckDiscoveryMessage> fut) {
                StartSnapshotOperationAckDiscoveryMessage ackMsg;
                try {
                    ackMsg = (StartSnapshotOperationAckDiscoveryMessage)fut.get();
                }
                catch (Exception e) {
                    U.error((IgniteLogger)SnapshotOperationFuture.this.log, (Object)("Failed to collect state state [opId=" + SnapshotOperationFuture.this.id + ']'), (Throwable)e);
                    StartSnapshotOperationDiscoveryMessage startMsg = SnapshotOperationFuture.this.startStateFut.startMessage();
                    ackMsg = new StartSnapshotOperationAckDiscoveryMessage(SnapshotOperationFuture.this.id, startMsg != null ? startMsg.snapshotOperation() : null, null, null, e, SnapshotOperationFuture.this.initiatorId);
                }
                final StartSnapshotOperationAckDiscoveryMessage ackMsg0 = ackMsg;
                SnapshotOperationFuture.this.cctx.kernalContext().pools().getSystemExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SnapshotOperationFuture.this.cctx.discovery().sendCustomEvent((DiscoveryCustomMessage)ackMsg0);
                        }
                        catch (IgniteCheckedException e) {
                            U.error((IgniteLogger)SnapshotOperationFuture.this.log, (Object)("Failed to send start snapshot ack message [opId=" + SnapshotOperationFuture.this.id + ']'), (Throwable)e);
                        }
                    }
                });
            }
        });
        this.startStateFut.onMessage(this.cctx.localNodeId(), this.startStateMsg);
    }

    private void submitTaskToSnapshotExecutor(Runnable task) {
        this.snapMgr.submitTaskToSnapshotExecutor(this.type(), task);
    }

    public void onPartitionStatesRestored(GridDhtPartitionsExchangeFuture fut) {
    }

    public void onWalStateChanged(int grpId, Map<String, IgniteUuid> caches, boolean enabled) {
    }

    protected void clientInitFutDone(Throwable err, boolean doneAfterStart) {
        if (this.clientInitFut != null) {
            this.clientInitFut.onDone(err);
        }
    }

    static boolean compressionEnabled(SnapshotOperationInfoImpl snapshotInfo) {
        GridSnapshotOperationEx snapshotOperation = snapshotInfo.snapshotOperation();
        CompressionOption compression = GridSnapshotOperationAttrs.getCompressionOptionParameter((GridSnapshotOperationEx)snapshotOperation);
        return compression != CompressionOption.NONE;
    }

    StageDescriptor wrapStage(ClusterNode node, ClusterWideSnapshotOperationStageFinishedMessage msg) {
        return new StageDescriptor(msg.stage());
    }

    StageDescriptor wrapStage(ClusterNode node, SnapshotOperationStageFinishedMessage msg) {
        return new StageDescriptor(msg.stage());
    }

    StageDescriptor wrapPreviousStage() {
        return new StageDescriptor(this.previousStage);
    }

    public String toString() {
        return S.toString(SnapshotOperationFuture.class, (Object)this);
    }

    static class StageDescriptor {
        @NotNull
        private final SnapshotOperationStage stage;
        @Nullable
        final Integer customStageIdx;

        StageDescriptor(@NotNull SnapshotOperationStage stage, int customStageIdx) {
            this.stage = stage;
            this.customStageIdx = customStageIdx;
        }

        StageDescriptor(@NotNull SnapshotOperationStage stage) {
            this.stage = stage;
            this.customStageIdx = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StageDescriptor wrapper = (StageDescriptor)o;
            return this.stage == wrapper.stage && Objects.equals(this.customStageIdx, wrapper.customStageIdx);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.stage, this.customStageIdx});
        }

        public String toString() {
            return "StageDescriptor{stage=" + (Object)((Object)this.stage) + ", customStageIdx=" + this.customStageIdx + '}';
        }
    }

    protected static enum SnapshotOperationLifecycleStage {
        OP_STARTED,
        OP_FINISHED;

    }

    private class SnapshotOperationContextImpl
    implements SnapshotOperationContext {
        private final AtomicReference<SnapshotProgressCalculator> progressCalculatorRef = new AtomicReference();

        public SnapshotOperationContextImpl(SnapshotProgressCalculator calculator) {
            this.progressCalculatorRef.set(calculator);
        }

        public boolean isCancelled() {
            return SnapshotOperationFuture.this.isCancelled();
        }

        public void setProgressCalculator(SnapshotProgressCalculator calculator) {
            if (!this.progressCalculatorRef.compareAndSet(null, calculator)) {
                throw new IgniteException("progress calculator was already set!");
            }
        }

        public void progress(long processed, long total) {
            if (!SnapshotOperationFuture.this.isNotInBaseline()) {
                SnapshotOperationFuture.this.sendProgress(processed, total);
            }
        }

        public void reportWork(long amountOfWork) {
            SnapshotProgressCalculator progressCalculator = this.progressCalculatorRef.get();
            if (progressCalculator == null) {
                throw new UnsupportedOperationException("You should calculate progress by yourself for this operation type");
            }
            this.progress(progressCalculator.progress(amountOfWork), progressCalculator.total());
        }

        public SnapshotOperationInfo snapshotOperationInfo() {
            return SnapshotOperationFuture.this.snapshotInfo;
        }
    }
}

