/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.gridgain.grid.internal.processors.cache.database.snapshot.FutureTaskQueue;
import org.gridgain.grid.internal.processors.cache.database.snapshot.PageIdIterable;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateFuture;
import org.jetbrains.annotations.Nullable;

public class PagesWrittenTracker {
    private static final Comparator<FullPageId> COMPARATOR = new SnapshotCreateFuture.FullPageIdComparator();
    private volatile FullPageId cntr;
    private final Object lock = new Object();
    private final AtomicLong cntOfWrittenPages = new AtomicLong(0L);
    private final AtomicLong cntOfWrittenIndexPages = new AtomicLong(0L);
    private final NavigableMap<FullPageId, Boolean> updates = new TreeMap<FullPageId, Boolean>(COMPARATOR);
    private final PageIdIterable iterable;
    private final IgniteLogger log;
    private final FutureTaskQueue<GroupPartitionId> completedPartitionsFutureTaskQueue;
    private volatile int writtenCheckpointPagesCntr;
    private volatile int totalCheckpointPagesCntr;
    private volatile int writtenSnapshotPagesCntr;
    private volatile int totalSnapshotPagesCntr;

    PagesWrittenTracker(PageIdIterable iterable, IgniteLogger log, @Nullable FutureTaskQueue<GroupPartitionId> completedPartitionsFutureTaskQueue) {
        this.iterable = iterable;
        this.log = log;
        this.completedPartitionsFutureTaskQueue = completedPartitionsFutureTaskQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(FullPageId pageId) {
        Object object = this.lock;
        synchronized (object) {
            boolean changed;
            if (this.contains(pageId)) {
                return false;
            }
            boolean bl = changed = this.updates.putIfAbsent(pageId, true) == null;
            assert (changed);
        }
        int partId = PageIdUtils.partId((long)pageId.pageId());
        this.cntOfWrittenPages.incrementAndGet();
        if (partId == 65535) {
            this.cntOfWrittenIndexPages.incrementAndGet();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("New page was added to tracker - " + pageId);
        }
        while (true) {
            FullPageId cntr0 = this.cntr;
            FullPageId next = this.iterable.next(cntr0);
            Object object2 = this.lock;
            synchronized (object2) {
                if (this.cntr != cntr0) {
                    continue;
                }
                Map.Entry<FullPageId, Boolean> entry = this.updates.firstEntry();
                if (next == null && this.completedPartitionsFutureTaskQueue != null) {
                    this.completedPartitionsFutureTaskQueue.submitTask((Object)new GroupPartitionId(cntr0.groupId(), PageIdUtils.partId((long)cntr0.pageId())));
                    break;
                }
                if (entry == null) {
                    break;
                }
                FullPageId first = entry.getKey();
                if (COMPARATOR.compare(first, cntr0) <= 0 || COMPARATOR.compare(first, next) < 0) {
                    throw new IllegalStateException("Unexpected state! 'ADD' was called with page id which we don't expect: first=" + first + ", cntr=" + cntr0 + ", next=" + next);
                }
                if (COMPARATOR.compare(first, next) == 0) {
                    this.cntr = next;
                    this.updates.remove(first);
                    if (this.completedPartitionsFutureTaskQueue != null && cntr0 != null && (cntr0.groupId() != first.groupId() || PageIdUtils.partId((long)cntr0.pageId()) != PageIdUtils.partId((long)first.pageId()))) {
                        this.completedPartitionsFutureTaskQueue.submitTask((Object)new GroupPartitionId(cntr0.groupId(), PageIdUtils.partId((long)cntr0.pageId())));
                    }
                } else {
                    break;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean contains(FullPageId pageId) {
        Object object = this.lock;
        synchronized (object) {
            return COMPARATOR.compare(pageId, this.cntr) <= 0 || this.updates.containsKey(pageId);
        }
    }

    boolean isComplete() {
        FullPageId pageId = this.cntr;
        if (pageId == null) {
            assert (this.iterable.isEmpty()) : this.iterable;
            return true;
        }
        FullPageId next = this.iterable.next(pageId);
        return next == null;
    }

    double progress() {
        if (this.writtenCheckpointPagesCntr >= 0 && this.totalCheckpointPagesCntr >= 0 && this.writtenSnapshotPagesCntr >= 0 && this.totalSnapshotPagesCntr > 0) {
            double progress = (double)(this.writtenCheckpointPagesCntr + this.writtenSnapshotPagesCntr) / (double)(this.totalCheckpointPagesCntr + this.totalSnapshotPagesCntr);
            if (progress < 0.0) {
                return 0.0;
            }
            if (progress > 1.0) {
                return 1.0;
            }
            return progress;
        }
        return 0.0;
    }

    long processed() {
        return this.writtenCheckpointPagesCntr + this.writtenSnapshotPagesCntr;
    }

    long total() {
        return this.totalCheckpointPagesCntr + this.totalSnapshotPagesCntr;
    }

    public void reportCheckpointWrittenPages(int writtenCheckpointPagesCntr, int totalCheckpointPagesCntr) {
        if (totalCheckpointPagesCntr > 0 && writtenCheckpointPagesCntr >= 0) {
            this.writtenCheckpointPagesCntr = writtenCheckpointPagesCntr;
            this.totalCheckpointPagesCntr = totalCheckpointPagesCntr;
        }
    }

    public void reportWrittenSnapshotPages(int writtenSnapshotPagesCntr, int totalSnapshotPagesCntr) {
        if (totalSnapshotPagesCntr > 0 && writtenSnapshotPagesCntr >= 0) {
            this.writtenSnapshotPagesCntr = writtenSnapshotPagesCntr;
            this.totalSnapshotPagesCntr = totalSnapshotPagesCntr;
        }
    }

    public long getCntOfWrittenPages() {
        return this.cntOfWrittenPages.get();
    }

    public long getCntOfWrittenIndexPages() {
        return this.cntOfWrittenIndexPages.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeState() {
        String updates;
        double progress;
        FullPageId pageId;
        Object object = this.lock;
        synchronized (object) {
            pageId = this.cntr;
            if (pageId == null) {
                return "Tracker state = [pageId is null]";
            }
            progress = this.progress();
            updates = this.updates.toString();
        }
        return "Tracker state = [pageId=" + pageId + ", next = " + this.iterable.next(pageId) + ", progress = " + progress + ", updates = " + updates + "]";
    }
}

