/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.util.Collection;
import java.util.Collections;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.gridgain.grid.internal.processors.cache.database.snapshot.ConsistentCutContextSupplier;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridCacheSnapshotManager;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotCreateFuture;
import org.gridgain.grid.internal.processors.cache.database.snapshot.SnapshotOperationFuture;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutContext;
import org.gridgain.grid.internal.processors.cache.database.txdr.ConsistentCutStore;
import org.gridgain.grid.internal.processors.cache.database.txdr.TopologyEventsSnapshot;
import org.gridgain.grid.persistentstore.SnapshotOperationType;

public class ExchanglessCutContextSupplier
implements ConsistentCutContextSupplier {
    private final GridKernalContext ctx;
    private final GridCacheSnapshotManager snapMgr;
    private final SnapshotCreateFuture snapshotFut;

    public ExchanglessCutContextSupplier(GridKernalContext ctx) {
        this.ctx = ctx;
        this.snapMgr = (GridCacheSnapshotManager)ctx.cache().context().snapshot();
        SnapshotOperationFuture fut = this.snapMgr.operationFutureReference(SnapshotOperationType.CREATE).get();
        if (fut == null || fut.isCancelled()) {
            throw new IgniteException("The snapshot already canceled.");
        }
        this.snapshotFut = (SnapshotCreateFuture)fut;
    }

    @Override
    public ConsistentCutContext createConsistentCutContext(long cutId) {
        if (this.snapshotFut.isNotInBaseline()) {
            return new ConsistentCutContext(cutId, -1L, this.ctx.cache().context());
        }
        this.snapshotFut.prepareFuture().get();
        return new ConsistentCutContext(cutId, this.snapshotFut.snapshotInfo().snapshotId(), this.snapshotFut.exchangelessSnapshotContext(), this.ctx.cache().context());
    }

    @Override
    public ConsistentCutStore consistentCutStore() {
        return this.snapMgr.consistentCutStore();
    }

    @Override
    public boolean shouldSkipConsistentCut(ConsistentCutContext cutCtx, AffinityTopologyVersion topVer) {
        AffinityTopologyVersion lastTopVer = this.ctx.discovery().topologyVersionEx();
        AffinityTopologyVersion lastAffChangedTopVer = this.ctx.cache().context().exchange().lastAffinityChangedTopologyVersion(lastTopVer);
        AffinityTopologyVersion startAffChangedTopVer = this.ctx.cache().context().exchange().lastAffinityChangedTopologyVersion(topVer);
        return !startAffChangedTopVer.equals((Object)lastAffChangedTopVer);
    }

    @Override
    public boolean shouldCancelOnSkippedCut() {
        return true;
    }

    @Override
    public Collection<BinaryMetadata> binaryMetadata() throws IgniteCheckedException {
        return Collections.emptyList();
    }

    @Override
    public TopologyEventsSnapshot localTopologySnapshot(ConsistentCutContext cutCtx) throws IgniteCheckedException {
        return new TopologyEventsSnapshot(cutCtx.cutId(), this.ctx.discovery().topologyVersionEx(), Collections.emptyMap());
    }

    @Override
    public void updateLocalTopologySnapshot(TopologyEventsSnapshot snapshot) throws IgniteCheckedException {
    }
}

