/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.snapshot;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.PageSupport;
import org.apache.ignite.internal.pagemem.wal.IgniteWriteAheadLogManager;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.TrackingPageDeltaRecord;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PartitionAllocationMap;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.TrackingPageIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;
import org.apache.ignite.internal.util.typedef.T2;
import org.gridgain.grid.internal.processors.cache.database.snapshot.PageIdIterable;

public abstract class AbstractFullPageIdIterable
implements PageIdIterable {
    private final ThreadLocal<ByteBuffer> trackingPageTmpBuf = new ThreadLocal();
    private final ThreadLocal<Integer> grpId = ThreadLocal.withInitial(() -> 0);
    private final ThreadLocal<T2<Integer, Integer>> realPageSize = ThreadLocal.withInitial(() -> null);
    private final Set<FullPageId> corruptedTrackingPages = new HashSet<FullPageId>();
    protected final TrackingPageIO io = (TrackingPageIO)TrackingPageIO.VERSIONS.latest();
    protected final GridCacheSharedContext<?, ?> sharedCtx;
    private final Map<Integer, Long> nextSnapshotTagsForCacheGrp;
    private final Map<Integer, Long> lastSuccessfulSnapshotTagsForCache;
    protected final PartitionAllocationMap partStateMap;
    protected final int pageSize;
    protected final int totalPageCnt;

    protected AbstractFullPageIdIterable(GridCacheSharedContext<?, ?> sharedCtx, Map<Integer, Long> nextSnapshotTagsForCacheGrp, Map<Integer, Long> lastSuccessfulSnapshotTagsForCache, PartitionAllocationMap partStateMap) {
        this.sharedCtx = sharedCtx;
        this.nextSnapshotTagsForCacheGrp = nextSnapshotTagsForCacheGrp;
        this.lastSuccessfulSnapshotTagsForCache = lastSuccessfulSnapshotTagsForCache;
        this.partStateMap = partStateMap;
        this.pageSize = sharedCtx.database().pageSize();
        partStateMap.prepareForSnapshot();
        int sum = 0;
        for (PagesAllocationRange range : partStateMap.values()) {
            sum += range.getCurrAllocatedPageCnt();
        }
        this.totalPageCnt = sum;
    }

    @Override
    public final Set<FullPageId> corruptedTrackingPages() {
        return Collections.unmodifiableSet(this.corruptedTrackingPages);
    }

    @Override
    public final int getTotalPageCnt() {
        return this.totalPageCnt;
    }

    protected long getLastSuccessfulSnapshotTag(int grpId) {
        return this.lastSuccessfulSnapshotTagsForCache.getOrDefault(grpId, 0L);
    }

    protected long getCurrentSnapshotTag(int grpId) {
        return this.nextSnapshotTagsForCacheGrp.get(grpId) - 1L;
    }

    protected void markCorruptedTrackingPage(long trackingPage, int grpId) {
        this.corruptedTrackingPages.add(new FullPageId(trackingPage, grpId));
    }

    protected final ByteBuffer getCachedTrackingPage() {
        return this.trackingPageTmpBuf.get();
    }

    protected final TrackingPageBufferScope borrowTrackingPage(int grpId, long trackingPageId) {
        long trackingPage;
        ByteBuffer read = this.trackingPageTmpBuf.get();
        if (grpId == this.grpId.get() && read != null && PageIO.getPageId((ByteBuffer)read) == trackingPageId) {
            return () -> {};
        }
        this.sharedCtx.database().checkpointReadLock();
        try {
            trackingPage = this.lockAndReadTrackingPage(grpId, trackingPageId);
            this.grpId.set(grpId);
        }
        catch (Throwable t) {
            this.sharedCtx.database().checkpointReadUnlock();
            throw t;
        }
        long prevLastSnapshotTag = this.trackingPageTmpBuf.get().getLong(40);
        return () -> {
            ByteBuffer pageStoreBuf = this.trackingPageTmpBuf.get();
            ByteBuffer onheapBuf = ByteBuffer.allocate(this.pageSize);
            pageStoreBuf.rewind();
            onheapBuf.put(pageStoreBuf);
            onheapBuf.order(ByteOrder.nativeOrder());
            this.trackingPageTmpBuf.set(onheapBuf);
            this.unlockTrackingPage(grpId, trackingPageId, trackingPage, prevLastSnapshotTag);
        };
    }

    private long lockAndReadTrackingPage(int grpId, long trackingPageId) {
        CacheGroupContext grp = this.sharedCtx.cache().cacheGroup(grpId);
        assert (grp != null) : "Cache group not found: " + grpId;
        PageMemory pageMem = grp.dataRegion().pageMemory();
        try {
            long trackingPage = pageMem.acquirePage(grpId, trackingPageId);
            try {
                long pageAddr = pageMem.writeLock(grpId, trackingPageId, trackingPage);
                assert (pageAddr != 0L);
                try {
                    this.trackingPageTmpBuf.set(pageMem.pageBuffer(pageAddr));
                    return trackingPage;
                }
                catch (Throwable t) {
                    pageMem.writeUnlock(grpId, trackingPageId, trackingPage, null, false);
                    throw t;
                }
            }
            catch (Throwable t) {
                pageMem.releasePage(grpId, trackingPageId, trackingPage);
                throw t;
            }
        }
        catch (IgniteCheckedException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockTrackingPage(int grpId, long trackingPageId, long trackingPage, long prevLastSnapshotTag) {
        long lastSnapshotTag = this.getCachedTrackingPage().getLong(40);
        try {
            PageMemory pageMem = this.sharedCtx.cache().cacheGroup(grpId).dataRegion().pageMemory();
            try {
                boolean dirty = prevLastSnapshotTag != lastSnapshotTag;
                try {
                    IgniteWriteAheadLogManager walMgr = this.sharedCtx.wal();
                    if (dirty && PageHandler.isWalDeltaRecordNeeded((PageSupport)pageMem, (int)grpId, (long)trackingPageId, (long)trackingPage, (IgniteWriteAheadLogManager)walMgr, null)) {
                        long nextSnapshotTag = this.getCurrentSnapshotTag(grpId);
                        long lastSuccessfulSnapshotTag = this.getLastSuccessfulSnapshotTag(grpId);
                        walMgr.log((WALRecord)new TrackingPageDeltaRecord(grpId, trackingPageId, trackingPageId, nextSnapshotTag, lastSuccessfulSnapshotTag));
                    }
                }
                catch (IgniteCheckedException e) {
                    throw new IgniteException((Throwable)e);
                }
                finally {
                    pageMem.writeUnlock(grpId, trackingPageId, trackingPage, null, dirty);
                }
            }
            finally {
                pageMem.releasePage(grpId, trackingPageId, trackingPage);
            }
        }
        finally {
            this.sharedCtx.database().checkpointReadUnlock();
        }
    }

    protected final int realPageSize(int grpId) {
        T2<Integer, Integer> realPageSizePair = this.realPageSize.get();
        if (realPageSizePair == null || (Integer)realPageSizePair.get1() != grpId) {
            CacheGroupContext grpCtx = this.sharedCtx.cache().cacheGroup(grpId);
            int realPageSize = grpCtx.dataRegion().pageMemory().realPageSize(grpId);
            this.realPageSize.set((T2<Integer, Integer>)new T2((Object)grpId, (Object)realPageSize));
            return realPageSize;
        }
        return (Integer)realPageSizePair.get2();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{partStateMap=" + this.partStateMap + ", nextSnapshotTagsForCacheGrp=" + this.nextSnapshotTagsForCacheGrp + ", lastSuccessfulSnapshotIdsForCache=" + this.lastSuccessfulSnapshotTagsForCache + ", pageSize=" + this.pageSize + ", totalPageCnt=" + this.totalPageCnt + '}';
    }

    @FunctionalInterface
    protected static interface TrackingPageBufferScope
    extends AutoCloseable {
        @Override
        public void close();
    }
}

