/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database.messages;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationImpl;
import org.gridgain.grid.persistentstore.SnapshotOperationType;
import org.jetbrains.annotations.Nullable;

public class StartSnapshotOperationDiscoveryMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private IgniteUuid id = IgniteUuid.randomUuid();
    private IgniteUuid operationId;
    private GridSnapshotOperationImpl snapshotOperation;
    private UUID initiatorId;
    private boolean validatedByCoordinator;
    private Exception err;
    @Deprecated
    private Map<Integer, Long> lastFullSnapshotIdForCache = new HashMap<Integer, Long>();
    private Map<Integer, Long> lastSnapshotIdForCache = new HashMap<Integer, Long>();
    private boolean skipAck;
    private transient boolean stopProc;
    private long lastSuccessfulFullSnapshotIdForAllCaches;

    public StartSnapshotOperationDiscoveryMessage(IgniteUuid operationId, GridSnapshotOperationImpl snapshotOperation, UUID initiatorId, long lastSuccessfulFullSnapshotIdForAllCaches, boolean mutableMsg) {
        this.operationId = operationId;
        this.snapshotOperation = snapshotOperation;
        this.initiatorId = initiatorId;
        this.lastSuccessfulFullSnapshotIdForAllCaches = lastSuccessfulFullSnapshotIdForAllCaches;
        this.skipAck = !mutableMsg && StartSnapshotOperationDiscoveryMessage.collectStateByCommunication((GridSnapshotOperationEx)snapshotOperation);
    }

    public static boolean collectStateByCommunication(GridSnapshotOperationEx op) {
        return op.type() == SnapshotOperationType.CREATE && GridSnapshotOperationAttrs.getFullSnapshotParameter((GridSnapshotOperationEx)op) == false;
    }

    public Map<Integer, Long> lastSnapshotIds() {
        return this.lastSnapshotIdForCache;
    }

    public Map<Integer, Long> lastFullSnapshotIds() {
        return this.lastFullSnapshotIdForCache;
    }

    public void stopProcess(boolean stopProc) {
        this.stopProc = stopProc;
    }

    public boolean stopProcess() {
        return this.stopProc;
    }

    public long lastSuccessfulFullSnapshotIdForAllCaches() {
        return this.lastSuccessfulFullSnapshotIdForAllCaches;
    }

    public GridSnapshotOperationEx snapshotOperation() {
        return this.snapshotOperation;
    }

    public void error(Exception err) {
        this.err = err;
    }

    public boolean hasError() {
        return this.err != null;
    }

    public Exception error() {
        return this.err;
    }

    public UUID initiatorNodeId() {
        return this.initiatorId;
    }

    public IgniteUuid id() {
        return this.id;
    }

    public IgniteUuid operationId() {
        return this.operationId;
    }

    public Long lastSnapshotId(int cacheId) {
        return this.lastSnapshotIdForCache.get(cacheId);
    }

    public Long lastFullSnapshotId(int cacheId) {
        return this.lastFullSnapshotIdForCache.get(cacheId);
    }

    public boolean validatedByCoordinator() {
        return this.validatedByCoordinator;
    }

    public void validatedByCoordinator(boolean validatedByCrd) {
        this.validatedByCoordinator = validatedByCrd;
    }

    public void lastSnapshotId(int cacheId, long id) {
        this.lastSnapshotIdForCache.put(cacheId, id);
    }

    public void skipAck(boolean skipAck) {
        this.skipAck = skipAck;
    }

    public void lastFullSnapshotId(int cacheId, long id) {
        this.lastFullSnapshotIdForCache.put(cacheId, id);
    }

    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        if (this.skipAck && !this.stopProc) {
            return null;
        }
        return new StartSnapshotOperationAckDiscoveryMessage(this.operationId, (GridSnapshotOperationEx)this.snapshotOperation, this.lastSnapshotIdForCache, null, (Exception)(this.err != null ? this.err : (this.validatedByCoordinator ? null : new IgniteException("Coordinator didn't validate operation!"))), this.initiatorId);
    }

    public boolean isMutable() {
        return true;
    }

    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        throw new UnsupportedOperationException();
    }

    public void snapshotOperation(GridSnapshotOperationImpl snapshotOperation) {
        this.snapshotOperation = snapshotOperation;
    }

    public String toString() {
        return S.toString(StartSnapshotOperationDiscoveryMessage.class, (Object)this);
    }
}

