/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.processors.cache.database;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryMessageResultsCollector;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.grid.internal.processors.cache.database.messages.SnapshotOperationStartStateMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationAckDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.messages.StartSnapshotOperationDiscoveryMessage;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationAttrs;
import org.gridgain.grid.internal.processors.cache.database.snapshot.GridSnapshotOperationEx;
import org.gridgain.grid.internal.processors.cache.database.snapshot.LatestSnapshotMismatchHandlingPolicy;

public class SnapshotOperationCollectStartStateFuture
extends GridFutureAdapter<StartSnapshotOperationAckDiscoveryMessage> {
    private StartSnapshotOperationDiscoveryMessage startMsg;
    private final IgniteLogger log;
    private final DiscoveryMessageResultsCollector<SnapshotOperationStartStateMessage, StartSnapshotOperationAckDiscoveryMessage> resCollect;

    public SnapshotOperationCollectStartStateFuture(final GridCacheSharedContext<?, ?> cctx) {
        this.log = cctx.logger(((Object)((Object)this)).getClass());
        this.resCollect = new DiscoveryMessageResultsCollector<SnapshotOperationStartStateMessage, StartSnapshotOperationAckDiscoveryMessage>(cctx.kernalContext()){

            protected StartSnapshotOperationAckDiscoveryMessage createResult(Map<UUID, DiscoveryMessageResultsCollector.NodeMessage<SnapshotOperationStartStateMessage>> rcvd) {
                assert (SnapshotOperationCollectStartStateFuture.this.startMsg != null);
                assert (!rcvd.isEmpty());
                assert (StartSnapshotOperationDiscoveryMessage.collectStateByCommunication(SnapshotOperationCollectStartStateFuture.this.startMsg.snapshotOperation())) : SnapshotOperationCollectStartStateFuture.access$000(SnapshotOperationCollectStartStateFuture.this);
                boolean supportsSmartIncremental = IgniteFeatures.allNodesSupports((GridKernalContext)cctx.kernalContext(), (Iterable)cctx.discovery().allNodes(), (IgniteFeatures)IgniteFeatures.SNAPSHOT_LAST_SNAPSHOTS_MISMATCH_HANDLING_POLICY);
                if (!supportsSmartIncremental) {
                    return this.preMismatchHandlingPolicy(rcvd);
                }
                IgniteCheckedException err = null;
                HashMap<Integer, SnapshotInfoHolder> latestSnapshots = new HashMap<Integer, SnapshotInfoHolder>();
                HashMap snapInfoByConsId = new HashMap();
                for (Map.Entry<UUID, DiscoveryMessageResultsCollector.NodeMessage<SnapshotOperationStartStateMessage>> e : rcvd.entrySet()) {
                    SnapshotOperationStartStateMessage snapshotOperationStartStateMessage = (SnapshotOperationStartStateMessage)e.getValue().message();
                    if (snapshotOperationStartStateMessage == null) continue;
                    if (snapshotOperationStartStateMessage.error() != null) {
                        U.warn((IgniteLogger)SnapshotOperationCollectStartStateFuture.this.log, (Object)("Failed to start snapshot operation on node [opId=" + SnapshotOperationCollectStartStateFuture.this.startMsg.operationId() + ", node=" + e.getKey() + ", err=" + snapshotOperationStartStateMessage.error() + ']'));
                        if (err != null) continue;
                        err = new IgniteCheckedException(snapshotOperationStartStateMessage.error());
                        continue;
                    }
                    if (err != null) continue;
                    HashMap<Integer, SnapshotInfoHolder> snapInfoByGrpId = new HashMap<Integer, SnapshotInfoHolder>();
                    snapInfoByConsId.put(e.getKey(), snapInfoByGrpId);
                    Map<Integer, Long> lastSnapshotIds0 = snapshotOperationStartStateMessage.lastSnapshotIds();
                    Map<Integer, Long> lastFullSnapshotIds0 = snapshotOperationStartStateMessage.lastFullSnapshotIds();
                    if (lastSnapshotIds0 == null) {
                        err = new IgniteCheckedException("Failed to get last snapshot IDs from node: " + e.getKey());
                        continue;
                    }
                    if (lastFullSnapshotIds0 == null) {
                        err = new IgniteCheckedException("Failed to get last full snapshot IDs from node: " + e.getKey());
                        continue;
                    }
                    for (Integer grpId : SnapshotOperationCollectStartStateFuture.this.startMsg.snapshotOperation().cacheGroupIds()) {
                        SnapshotInfoHolder info;
                        Long fullSnaphotId;
                        Long snapshotId = lastSnapshotIds0.get(grpId);
                        if (snapshotId == null) {
                            snapshotId = 0L;
                        }
                        if ((fullSnaphotId = lastFullSnapshotIds0.get(grpId)) == null) {
                            fullSnaphotId = 0L;
                        }
                        if ((info = (SnapshotInfoHolder)latestSnapshots.get(grpId)) == null) {
                            info = new SnapshotInfoHolder(fullSnaphotId, snapshotId);
                        } else {
                            long fullSnaphotId0 = info.lastFullSnapshotId();
                            long snapshotId0 = info.lastSnapshotId();
                            info = new SnapshotInfoHolder(Long.max(fullSnaphotId0, fullSnaphotId), Long.max(snapshotId0, snapshotId));
                        }
                        latestSnapshots.put(grpId, info);
                        snapInfoByGrpId.put(grpId, new SnapshotInfoHolder(fullSnaphotId, snapshotId));
                    }
                }
                HashMap<String, StartSnapshotOperationAckDiscoveryMessage.Resolution> resolutions = new HashMap<String, StartSnapshotOperationAckDiscoveryMessage.Resolution>();
                for (Map.Entry entry : snapInfoByConsId.entrySet()) {
                    UUID nodeId = (UUID)entry.getKey();
                    ClusterNode node = cctx.kernalContext().discovery().node(nodeId);
                    String consistentId = U.maskForFileName((CharSequence)node.consistentId().toString());
                    Map value = (Map)entry.getValue();
                    LatestSnapshotMismatchHandlingPolicy mismatchHandlingPlc = GridSnapshotOperationAttrs.getMismatchHandlingPolicy((GridSnapshotOperationEx)SnapshotOperationCollectStartStateFuture.this.startMsg.snapshotOperation());
                    StartSnapshotOperationAckDiscoveryMessage.Resolution resolution = StartSnapshotOperationAckDiscoveryMessage.Resolution.INCREMENTAL;
                    for (Integer grpId : SnapshotOperationCollectStartStateFuture.this.startMsg.snapshotOperation().cacheGroupIds()) {
                        if (!cctx.discovery().cacheGroupAffinityNode(node, grpId.intValue())) continue;
                        SnapshotInfoHolder latestSnaps = (SnapshotInfoHolder)latestSnapshots.get(grpId);
                        long globalLatestSnapForGroup = latestSnaps.lastSnapshotId();
                        long globalLatestFullSnapForGroup = latestSnaps.lastFullSnapshotId();
                        SnapshotInfoHolder info = (SnapshotInfoHolder)value.get(grpId);
                        long lastSnapForGroupOnNode = info.lastSnapshotId();
                        long lastFullSnapForGroupOnNode = info.lastFullSnapshotId();
                        if (lastSnapForGroupOnNode == globalLatestSnapForGroup && globalLatestSnapForGroup != 0L) continue;
                        long lastSuccessfulFullSnapshotIdForAllCaches = SnapshotOperationCollectStartStateFuture.this.startMsg.lastSuccessfulFullSnapshotIdForAllCaches();
                        if (globalLatestFullSnapForGroup == 0L && GridSnapshotOperationAttrs.isForAllCaches((GridSnapshotOperationEx)SnapshotOperationCollectStartStateFuture.this.startMsg.snapshotOperation()) && lastSuccessfulFullSnapshotIdForAllCaches != 0L) continue;
                        boolean hasCommonFull = lastFullSnapForGroupOnNode == globalLatestFullSnapForGroup;
                        switch (mismatchHandlingPlc) {
                            case INCREMENTAL_OR_IGNORE: {
                                if (lastSnapForGroupOnNode == 0L || !hasCommonFull) {
                                    resolution = StartSnapshotOperationAckDiscoveryMessage.Resolution.IGNORE;
                                    break;
                                }
                                resolution = StartSnapshotOperationAckDiscoveryMessage.Resolution.INCREMENTAL;
                                break;
                            }
                            case INCREMENTAL_OR_FULL: {
                                if (hasCommonFull && lastSnapForGroupOnNode != 0L) break;
                                resolution = StartSnapshotOperationAckDiscoveryMessage.Resolution.FORCE_FULL;
                            }
                        }
                        if (err == null && resolution == StartSnapshotOperationAckDiscoveryMessage.Resolution.INCREMENTAL) continue;
                        break;
                    }
                    resolutions.put(consistentId, resolution);
                    if (err == null) continue;
                    break;
                }
                HashMap<Integer, Long> lastSnapshotIdForCache = new HashMap<Integer, Long>();
                for (Map.Entry entry : latestSnapshots.entrySet()) {
                    lastSnapshotIdForCache.put((Integer)entry.getKey(), ((SnapshotInfoHolder)entry.getValue()).lastSnapshotId());
                }
                return new StartSnapshotOperationAckDiscoveryMessage(SnapshotOperationCollectStartStateFuture.this.startMsg.operationId(), SnapshotOperationCollectStartStateFuture.this.startMsg.snapshotOperation(), (Map<Integer, Long>)lastSnapshotIdForCache, (Map<String, StartSnapshotOperationAckDiscoveryMessage.Resolution>)resolutions, (Exception)((Object)err), SnapshotOperationCollectStartStateFuture.this.startMsg.initiatorNodeId());
            }

            private StartSnapshotOperationAckDiscoveryMessage preMismatchHandlingPolicy(Map<UUID, DiscoveryMessageResultsCollector.NodeMessage<SnapshotOperationStartStateMessage>> rcvd) {
                IgniteCheckedException err = null;
                UUID snapshotIdsNode = null;
                Map<Integer, Long> lastSnapshotIds = null;
                for (Map.Entry<UUID, DiscoveryMessageResultsCollector.NodeMessage<SnapshotOperationStartStateMessage>> e : rcvd.entrySet()) {
                    SnapshotOperationStartStateMessage msg = (SnapshotOperationStartStateMessage)e.getValue().message();
                    if (msg == null) continue;
                    if (msg.error() != null) {
                        U.warn((IgniteLogger)SnapshotOperationCollectStartStateFuture.this.log, (Object)("Failed to start snapshot operation on node [opId=" + SnapshotOperationCollectStartStateFuture.this.startMsg.operationId() + ", node=" + e.getKey() + ", err=" + msg.error() + ']'));
                        if (err != null) continue;
                        err = new IgniteCheckedException(msg.error());
                        continue;
                    }
                    if (err != null) continue;
                    Map<Integer, Long> lastSnapshotIds0 = msg.lastSnapshotIds();
                    if (lastSnapshotIds0 == null) {
                        err = new IgniteCheckedException("Failed to get last snapshot IDs from node: " + e.getKey());
                        continue;
                    }
                    if (lastSnapshotIds == null) {
                        snapshotIdsNode = e.getKey();
                        lastSnapshotIds = lastSnapshotIds0;
                        continue;
                    }
                    for (Integer grpId : SnapshotOperationCollectStartStateFuture.this.startMsg.snapshotOperation().cacheGroupIds()) {
                        Long snapshotId = lastSnapshotIds.get(grpId);
                        Long snapshotId0 = lastSnapshotIds0.get(grpId);
                        if (snapshotId == null && snapshotId0 != null) {
                            lastSnapshotIds.put(grpId, snapshotId0);
                        }
                        if (snapshotId == null || snapshotId0 == null || Objects.equals(snapshotId, snapshotId0)) continue;
                        String errorMsg = "Last snapshots are different on nodes [grpId=" + grpId + ", node1=" + snapshotIdsNode + ", lastSnapshotId=" + snapshotId + ", node2=" + e.getKey() + ", lastSnapshotId=" + snapshotId0 + ']';
                        U.warn((IgniteLogger)SnapshotOperationCollectStartStateFuture.this.log, (Object)errorMsg);
                        if (err != null) continue;
                        err = new IgniteCheckedException(errorMsg);
                    }
                }
                if (err == null && lastSnapshotIds == null) {
                    err = new IgniteCheckedException("Failed to get last snapshot IDs.");
                }
                return new StartSnapshotOperationAckDiscoveryMessage(SnapshotOperationCollectStartStateFuture.this.startMsg.operationId(), SnapshotOperationCollectStartStateFuture.this.startMsg.snapshotOperation(), lastSnapshotIds, null, (Exception)((Object)err), SnapshotOperationCollectStartStateFuture.this.startMsg.initiatorNodeId());
            }

            protected void onResultsCollected(StartSnapshotOperationAckDiscoveryMessage res) {
                SnapshotOperationCollectStartStateFuture.this.onDone(res);
            }

            protected boolean waitForNode(DiscoCache discoCache, ClusterNode node) {
                return !node.isClient();
            }
        };
    }

    public void init(DiscoCache discoCache, StartSnapshotOperationDiscoveryMessage startMsg) {
        this.startMsg = startMsg;
        this.resCollect.init(discoCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartSnapshotOperationDiscoveryMessage startMessage() {
        DiscoveryMessageResultsCollector<SnapshotOperationStartStateMessage, StartSnapshotOperationAckDiscoveryMessage> discoveryMessageResultsCollector = this.resCollect;
        synchronized (discoveryMessageResultsCollector) {
            return this.startMsg;
        }
    }

    public void onMessage(UUID nodeId, SnapshotOperationStartStateMessage msg) {
        this.resCollect.onMessage(nodeId, (Object)msg);
    }

    public void onNodeLeft(UUID nodeId) {
        this.resCollect.onNodeFail(nodeId);
    }

    public String toString() {
        return S.toString(SnapshotOperationCollectStartStateFuture.class, (Object)((Object)this));
    }

    private static class SnapshotInfoHolder {
        private final long fullSnap;
        private final long snap;

        public SnapshotInfoHolder(long fullSnap, long snap) {
            this.fullSnap = fullSnap;
            this.snap = snap;
        }

        public long lastFullSnapshotId() {
            return this.fullSnap;
        }

        public long lastSnapshotId() {
            return this.snap;
        }
    }
}

