/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.internal.persistentstore.snapshot.file.remote.sftp;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.cache.AbstractFilesCache;
import org.apache.commons.vfs2.util.Messages;

public class SftpFilesCache
extends AbstractFilesCache {
    private static final int TIMEOUT = 1000;
    private static final Log log = LogFactory.getLog(SftpFilesCache.class);
    private final Lock lock = new ReentrantLock();
    private final ReferenceQueue<FileObject> refQueue = new ReferenceQueue();
    private final Map<Reference<FileObject>, ReverseLink> refReverseMap = new ConcurrentHashMap<Reference<FileObject>, ReverseLink>(100);
    private volatile ReleaseThread releaseThread;
    private final ThreadLocal<CacheHolder> threadLocalCache = ThreadLocal.withInitial(() -> new CacheHolder());

    private void startThread() {
        if (this.releaseThread != null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.releaseThread == null) {
                this.releaseThread = new ReleaseThread();
                this.releaseThread.start();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void endThread() {
        this.lock.lock();
        try {
            ReleaseThread thread = this.releaseThread;
            this.releaseThread = null;
            if (thread != null) {
                thread.requestEnd = true;
                thread.interrupt();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(FileObject fileObject) {
        CacheHolder cacheHolder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("putFile: " + this.getSafeName(fileObject)));
        }
        CacheHolder cacheHolder2 = cacheHolder = this.threadLocalCache.get();
        synchronized (cacheHolder2) {
            Map<FileName, Reference<FileObject>> files = cacheHolder.getOrCreateFilesystemCache(fileObject.getFileSystem());
            Reference<FileObject> ref = this.createReference(fileObject, this.refQueue);
            CacheKey key = new CacheKey(fileObject.getFileSystem(), fileObject.getName());
            Reference<FileObject> old = files.put(fileObject.getName(), ref);
            if (old != null) {
                this.refReverseMap.remove(old);
            }
            this.refReverseMap.put(ref, new ReverseLink(cacheHolder, key));
        }
    }

    private String getSafeName(FileName fileName) {
        return fileName.getFriendlyURI();
    }

    private String getSafeName(FileObject fileObject) {
        return this.getSafeName(fileObject.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean putFileIfAbsent(FileObject fileObject) {
        CacheHolder cacheHolder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("putFile: " + this.getSafeName(fileObject)));
        }
        CacheHolder cacheHolder2 = cacheHolder = this.threadLocalCache.get();
        synchronized (cacheHolder2) {
            Map<FileName, Reference<FileObject>> files = cacheHolder.getOrCreateFilesystemCache(fileObject.getFileSystem());
            Reference<FileObject> ref = this.createReference(fileObject, this.refQueue);
            CacheKey key = new CacheKey(fileObject.getFileSystem(), fileObject.getName());
            if (files.containsKey(fileObject.getName()) && files.get(fileObject.getName()).get() != null) {
                return false;
            }
            Reference<FileObject> old = files.put(fileObject.getName(), ref);
            if (old != null) {
                this.refReverseMap.remove(old);
            }
            this.refReverseMap.put(ref, new ReverseLink(cacheHolder, key));
            return true;
        }
    }

    protected Reference<FileObject> createReference(FileObject file, ReferenceQueue<FileObject> refQueue) {
        return new WeakReference<FileObject>(file, refQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile(FileSystem fileSystem, FileName fileName) {
        CacheHolder cacheHolder;
        CacheHolder cacheHolder2 = cacheHolder = this.threadLocalCache.get();
        synchronized (cacheHolder2) {
            Map<FileName, Reference<FileObject>> files = cacheHolder.getOrCreateFilesystemCache(fileSystem);
            Reference<FileObject> ref = files.get(fileName);
            if (ref == null) {
                return null;
            }
            FileObject fo = ref.get();
            if (fo == null) {
                this.removeFile(fileSystem, fileName);
            }
            return fo;
        }
    }

    public void clear(FileSystem fileSystem) {
        List<Map.Entry> collect = this.refReverseMap.entrySet().stream().filter(entry -> ((ReverseLink)entry.getValue()).key.fileSystem == fileSystem).collect(Collectors.toList());
        collect.forEach(entry -> {
            CacheHolder holder;
            ReverseLink link = (ReverseLink)entry.getValue();
            CacheHolder cacheHolder = holder = link.holder;
            synchronized (cacheHolder) {
                Map<FileName, Reference<FileObject>> files = holder.getOrCreateFilesystemCache(fileSystem);
                files.remove(link.key.getFileName());
                if (files.isEmpty()) {
                    this.close(holder, fileSystem);
                }
            }
            this.refReverseMap.remove(entry.getKey());
        });
    }

    private void close(CacheHolder holder, FileSystem fileSystem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("close fs: " + fileSystem.getRootName()));
        }
        holder.remove(fileSystem);
        if (this.refReverseMap.isEmpty()) {
            this.endThread();
        }
    }

    public void close() {
        super.close();
        this.endThread();
        this.refReverseMap.values().forEach(value -> {
            CacheHolder holder;
            CacheHolder cacheHolder = holder = ((ReverseLink)value).holder;
            synchronized (cacheHolder) {
                ((ReverseLink)value).holder.clear();
            }
        });
        this.refReverseMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(FileSystem fileSystem, FileName fileName) {
        CacheHolder holder;
        CacheHolder cacheHolder = holder = this.threadLocalCache.get();
        synchronized (cacheHolder) {
            if (this.removeFile(holder, new CacheKey(fileSystem, fileName))) {
                this.close(holder, fileSystem);
            }
        }
    }

    private boolean removeFile(CacheHolder cacheHolder, CacheKey key) {
        Map<FileName, Reference<FileObject>> files;
        Reference<FileObject> ref;
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeFile: " + this.getSafeName(key.getFileName())));
        }
        if ((ref = (files = cacheHolder.getOrCreateFilesystemCache(key.getFileSystem())).remove(key.getFileName())) != null) {
            this.refReverseMap.remove(ref);
        }
        return files.isEmpty();
    }

    private static class ReverseLink {
        private final CacheHolder holder;
        private final CacheKey key;

        public ReverseLink(CacheHolder holder, CacheKey key) {
            this.holder = holder;
            this.key = key;
        }
    }

    private static class CacheKey
    implements Comparable<CacheKey> {
        private final FileSystem fileSystem;
        private final FileName fileName;
        private final int fileSystemId;

        CacheKey(FileSystem fileSystem, FileName fileName) {
            this.fileSystem = fileSystem;
            this.fileSystemId = System.identityHashCode(fileSystem);
            this.fileName = fileName;
        }

        @Override
        public int compareTo(CacheKey other) {
            if (this.fileSystemId < other.fileSystemId) {
                return -1;
            }
            if (this.fileSystemId > other.fileSystemId) {
                return 1;
            }
            return this.fileName.compareTo((Object)other.fileName);
        }

        FileSystem getFileSystem() {
            return this.fileSystem;
        }

        FileName getFileName() {
            return this.fileName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKey)) {
                return false;
            }
            return this.compareTo((CacheKey)o) == 0;
        }
    }

    private final class ReleaseThread
    extends Thread {
        private volatile boolean requestEnd;

        private ReleaseThread() {
            this.setName(ReleaseThread.class.getName());
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.requestEnd && !Thread.currentThread().isInterrupted()) {
                try {
                    CacheHolder holder;
                    ReverseLink value;
                    Reference ref = SftpFilesCache.this.refQueue.remove(1000L);
                    if (ref == null || (value = (ReverseLink)SftpFilesCache.this.refReverseMap.get(ref)) == null) continue;
                    CacheHolder cacheHolder = holder = value.holder;
                    synchronized (cacheHolder) {
                        value = (ReverseLink)SftpFilesCache.this.refReverseMap.get(ref);
                        if (value != null && SftpFilesCache.this.removeFile(holder, value.key)) {
                            SftpFilesCache.this.close(holder, value.key.fileSystem);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (this.requestEnd) break;
                    VfsLog.warn((Log)SftpFilesCache.this.getLogger(), (Log)log, (String)Messages.getString((String)"vfs.impl/SoftRefReleaseThread-interrupt.info"));
                    break;
                }
            }
        }
    }

    private class CacheHolder {
        private final Map<FileSystem, Map<FileName, Reference<FileObject>>> fileSystemCache = new HashMap<FileSystem, Map<FileName, Reference<FileObject>>>();

        private CacheHolder() {
        }

        Map<FileName, Reference<FileObject>> getOrCreateFilesystemCache(FileSystem fileSystem) {
            if (this.fileSystemCache.isEmpty()) {
                SftpFilesCache.this.startThread();
            }
            return this.fileSystemCache.computeIfAbsent(fileSystem, fs -> new HashMap());
        }

        void remove(FileSystem system) {
            this.fileSystemCache.remove(system);
        }

        void clear() {
            this.fileSystemCache.clear();
        }
    }
}

