/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core.longrunning.task;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.ignite.tensorflow.core.longrunning.LongRunningProcess;
import org.apache.ignite.tensorflow.core.longrunning.task.LongRunningProcessTask;
import org.apache.ignite.tensorflow.core.util.CustomizableThreadFactory;

public class LongRunningProcessStartTask
extends LongRunningProcessTask<List<UUID>> {
    private static final long serialVersionUID = -3934183044853083034L;
    private final List<LongRunningProcess> processes;

    public LongRunningProcessStartTask(List<LongRunningProcess> processes) {
        assert (processes != null) : "Processes should not be null";
        this.processes = processes;
    }

    public List<UUID> call() {
        ArrayList<UUID> res = new ArrayList<UUID>();
        try {
            for (LongRunningProcess proc : this.processes) {
                Future<?> fut = this.runTask((Runnable)proc.getTask());
                UUID procId = this.saveProcMetadata(fut);
                res.add(procId);
            }
        }
        catch (Exception e) {
            this.stopAllProcessesAndClearMetadata(res);
            throw e;
        }
        return res;
    }

    private Future<?> runTask(Runnable task) {
        return Executors.newSingleThreadExecutor(new CustomizableThreadFactory("tf-long-running", true)).submit(task);
    }

    private UUID saveProcMetadata(Future<?> fut) {
        ConcurrentHashMap<UUID, Future<?>> metadataStorage = this.getMetadataStorage();
        UUID procId = UUID.randomUUID();
        metadataStorage.put(procId, fut);
        return procId;
    }

    private void stopAllProcessesAndClearMetadata(List<UUID> procIds) {
        ConcurrentHashMap<UUID, Future<?>> metadataStorage = this.getMetadataStorage();
        for (UUID procId : procIds) {
            Future fut = (Future)metadataStorage.remove(procId);
            fut.cancel(true);
        }
    }
}

