/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.core.longrunning;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite.Ignite;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.tensorflow.core.ProcessManager;
import org.apache.ignite.tensorflow.core.longrunning.LongRunningProcess;
import org.apache.ignite.tensorflow.core.longrunning.task.LongRunningProcessClearTask;
import org.apache.ignite.tensorflow.core.longrunning.task.LongRunningProcessPingTask;
import org.apache.ignite.tensorflow.core.longrunning.task.LongRunningProcessStartTask;
import org.apache.ignite.tensorflow.core.longrunning.task.LongRunningProcessStopTask;
import org.apache.ignite.tensorflow.core.longrunning.task.LongRunningProcessTask;
import org.apache.ignite.tensorflow.core.longrunning.task.util.LongRunningProcessStatus;

public class LongRunningProcessManager
implements ProcessManager<LongRunningProcess> {
    private final Ignite ignite;

    public LongRunningProcessManager(Ignite ignite) {
        assert (ignite != null) : "Ignite instance should not be null";
        this.ignite = ignite;
    }

    @Override
    public Map<UUID, List<UUID>> start(List<LongRunningProcess> specifications) {
        return this.call(this.groupByNodeId(specifications), LongRunningProcessStartTask::new, this::rollbackStartTask, false);
    }

    @Override
    public Map<UUID, List<LongRunningProcessStatus>> ping(Map<UUID, List<UUID>> procIds) {
        return this.call(procIds, LongRunningProcessPingTask::new, this::rollbackNothing, false);
    }

    @Override
    public Map<UUID, List<LongRunningProcessStatus>> stop(Map<UUID, List<UUID>> procIds, boolean clear) {
        return this.call(procIds, params -> new LongRunningProcessStopTask((List<UUID>)params, clear), this::rollbackNothing, true);
    }

    @Override
    public Map<UUID, List<LongRunningProcessStatus>> clear(Map<UUID, List<UUID>> procIds) {
        return this.call(procIds, LongRunningProcessClearTask::new, this::rollbackNothing, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T, E> Map<UUID, List<E>> call(Map<UUID, List<T>> params, Function<List<T>, LongRunningProcessTask<List<E>>> taskSupplier, Consumer<Map<UUID, List<E>>> rollback, boolean onlyIfNodeExists) {
        HashMap<UUID, List<E>> res = new HashMap<UUID, List<E>>();
        try {
            for (UUID nodeId : params.keySet()) {
                List<T> nodeProcesses = params.get(nodeId);
                LongRunningProcessTask<List<E>> task = taskSupplier.apply(nodeProcesses);
                ClusterGroup clusterGrp = this.ignite.cluster().forNodeId(nodeId, new UUID[0]);
                try {
                    List nodeRes = (List)this.ignite.compute(clusterGrp).call(task);
                    res.put(nodeId, nodeRes);
                }
                catch (ClusterGroupEmptyException e) {
                    if (onlyIfNodeExists) continue;
                    throw e;
                    return res;
                }
            }
        }
        catch (Exception e) {
            rollback.accept(res);
            throw e;
        }
    }

    private Map<UUID, List<LongRunningProcess>> groupByNodeId(List<LongRunningProcess> specifications) {
        HashMap<UUID, List<LongRunningProcess>> res = new HashMap<UUID, List<LongRunningProcess>>();
        for (LongRunningProcess spec : specifications) {
            UUID nodeId = spec.getNodeId();
            ArrayList<LongRunningProcess> nodeSpecs = (ArrayList<LongRunningProcess>)res.get(nodeId);
            if (nodeSpecs == null) {
                nodeSpecs = new ArrayList<LongRunningProcess>();
                nodeSpecs.add(spec);
                res.put(nodeId, nodeSpecs);
                continue;
            }
            nodeSpecs.add(spec);
        }
        return res;
    }

    private void rollbackStartTask(Map<UUID, List<UUID>> procIds) {
        this.stop(procIds, true);
    }

    private void rollbackNothing(Map<UUID, List<LongRunningProcessStatus>> processes) {
    }
}

