/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster.util;

import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.tensorflow.core.util.PythonProcessBuilderSupplier;

public class TensorFlowProcessBuilderSupplier
extends PythonProcessBuilderSupplier {
    private static final long serialVersionUID = 6866243505446122897L;
    private static final String ENV_PREFIX = "IGNITE_DATASET_";
    private final Boolean loc;

    public TensorFlowProcessBuilderSupplier(boolean interactive, Boolean loc, String ... meta) {
        super(interactive, meta);
        this.loc = loc;
    }

    @Override
    public ProcessBuilder get() {
        ProcessBuilder pythonProcBuilder = super.get();
        Ignite ignite = Ignition.ignite();
        ClusterNode locNode = ignite.cluster().localNode();
        Integer port = (Integer)locNode.attribute("clientListenerPort");
        Map<String, String> env = pythonProcBuilder.environment();
        env.put("IGNITE_DATASET_HOST", "localhost");
        if (port != null) {
            env.put("IGNITE_DATASET_PORT", String.valueOf(port));
        }
        if (this.loc != null) {
            env.put("IGNITE_DATASET_LOCAL", String.valueOf(this.loc));
        }
        return pythonProcBuilder;
    }
}

