/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster.util;

import java.io.Serializable;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.cluster.ClusterGroupEmptyException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.lang.IgniteCallable;

public class ClusterPortManager {
    private final Ignite ignite;
    private final IgniteLogger log;
    private final String portMgrCacheName;
    private final int from;
    private final int cnt;
    private final IgniteCache<HostIdentifier, BitSet> cache;

    public ClusterPortManager(Ignite ignite, String poolName, int from, int cnt) {
        assert (ignite != null) : "Ignite instance should not be null";
        assert (poolName != null) : "Pool name should not be null";
        assert (cnt >= 0) : "Count should not be negative";
        assert (from >= 0 && cnt + from <= 65535) : "Port range should be between 0 and 65535";
        this.ignite = ignite;
        this.log = ignite.log().getLogger(ClusterPortManager.class);
        this.portMgrCacheName = String.format("PORT_MANAGER_%s_CACHE", poolName);
        this.from = from;
        this.cnt = cnt;
        this.cache = this.getOrCreateCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acquirePort(UUID nodeId) {
        HostIdentifier hostId = this.getHostIdentifier(nodeId);
        if (hostId == null) {
            throw new IllegalStateException("Can't find node [nodeId=" + nodeId + "]");
        }
        Lock lock = this.cache.lock((Object)hostId);
        lock.lock();
        try {
            int free;
            BitSet ports = (BitSet)this.cache.get((Object)hostId);
            if (ports == null) {
                ports = new BitSet(this.cnt);
            }
            if ((free = ports.nextClearBit(0)) >= this.cnt) {
                throw new IllegalStateException("No free ports in range [from=" + this.from + ", cnt=" + this.cnt + "]");
            }
            ports.set(free);
            this.log.debug("Port acquired [nodeId=" + nodeId + ", port=" + (this.from + free) + "]");
            this.cache.put((Object)hostId, (Object)ports);
            int n = this.from + free;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releasePort(UUID nodeId, int port) {
        assert (port - this.from >= 0 && port - this.from < this.cnt) : "Port not in the range";
        HostIdentifier hostId = this.getHostIdentifier(nodeId);
        if (hostId == null) {
            return;
        }
        Lock lock = this.cache.lock((Object)hostId);
        lock.lock();
        try {
            BitSet ports = (BitSet)this.cache.get((Object)hostId);
            if (ports != null) {
                ports.clear(port - this.from);
                this.log.debug("Port released [nodeId=" + nodeId + ", port=" + port + "]");
                if (ports.isEmpty()) {
                    this.cache.remove((Object)hostId);
                } else {
                    this.cache.put((Object)hostId, (Object)ports);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void destroy() {
        this.ignite.destroyCache(this.portMgrCacheName);
    }

    private IgniteCache<HostIdentifier, BitSet> getOrCreateCache() {
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setName(this.portMgrCacheName);
        cacheConfiguration.setCacheMode(CacheMode.REPLICATED);
        cacheConfiguration.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        return this.ignite.getOrCreateCache(cacheConfiguration);
    }

    private HostIdentifier getHostIdentifier(UUID nodeId) {
        try {
            ClusterGroup grp = this.ignite.cluster().forNodeId(nodeId, new UUID[0]);
            return (HostIdentifier)this.ignite.compute(grp).call((IgniteCallable & Serializable)() -> {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                ArrayList<byte[]> macAddrs = new ArrayList<byte[]>();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface netItf = interfaces.nextElement();
                    byte[] macAddr = netItf.getHardwareAddress();
                    macAddrs.add(macAddr);
                }
                return new HostIdentifier((byte[][])macAddrs.toArray((T[])new byte[macAddrs.size()][]));
            });
        }
        catch (ClusterGroupEmptyException e) {
            return null;
        }
    }

    private static class HostIdentifier
    implements Serializable {
        private static final long serialVersionUID = -7060231325908935162L;
        private final byte[][] macAddrs;

        public HostIdentifier(byte[][] macAddrs) {
            this.macAddrs = macAddrs;
        }

        public byte[][] getMacAddrs() {
            return this.macAddrs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HostIdentifier that = (HostIdentifier)o;
            if (this.macAddrs.length != that.macAddrs.length) {
                return false;
            }
            for (int i = 0; i < this.macAddrs.length; ++i) {
                if (Arrays.equals(this.macAddrs[i], that.macAddrs[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Arrays.hashCode((Object[])this.macAddrs);
        }
    }
}

