/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.tensorflow.cluster.spec;

import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import org.apache.ignite.Ignite;

public class TensorFlowServerAddressSpec
implements Serializable {
    private static final long serialVersionUID = 7883701602323727681L;
    private final UUID nodeId;
    private final int port;

    TensorFlowServerAddressSpec(UUID nodeId, int port) {
        assert (nodeId != null) : "Node identifier should not be null";
        assert (port >= 0 && port <= 65535) : "Port should be between 0 and 65535";
        this.nodeId = nodeId;
        this.port = port;
    }

    public String format(Ignite ignite) {
        Collection names = ignite.cluster().forNodeId(this.nodeId, new UUID[0]).hostNames();
        return (String)names.iterator().next() + ":" + this.port;
    }

    public UUID getNodeId() {
        return this.nodeId;
    }

    public int getPort() {
        return this.port;
    }
}

