/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.processors.platform.client.CustomQueryProcessor;

public class ThinClientCustomQueryRegistry {
    private static ConcurrentMap<String, CustomQueryProcessor> processors = new ConcurrentHashMap<String, CustomQueryProcessor>();

    public static ClientResponse call(long requestId, String processorId, byte methodId, BinaryRawReader reader) {
        CustomQueryProcessor processor = (CustomQueryProcessor)processors.get(processorId);
        if (processor == null) {
            return new ClientResponse(requestId, "Cannot find processor with id = " + processorId);
        }
        return processor.call(requestId, methodId, reader);
    }

    public static boolean registerIfAbsent(CustomQueryProcessor processor) {
        String processorId = processor.id();
        return processors.putIfAbsent(processorId, processor) == null;
    }

    public static void unregister(CustomQueryProcessor processor) {
        if (processor == null) {
            return;
        }
        ThinClientCustomQueryRegistry.unregister(processor.id());
    }

    public static void unregister(String processorId) {
        processors.remove(processorId);
    }

    public static Set<String> registeredProcessors() {
        return processors.keySet();
    }
}

