/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint.syncfs;

import com.sun.jna.Native;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.pagemem.store.PageStore;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointPagesWriter;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.syncfs.SyncFsLibC;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.util.collection.IntHashMap;
import org.apache.ignite.lang.IgniteBiTuple;

public class SyncFsUtils {
    public static final String IGNITE_CHECKPOINT_SYNC_FS_ENABLED = "IGNITE_CHECKPOINT_SYNC_FS_ENABLED";
    public static final String IGNITE_CHECKPOINT_SYNC_FS_THRESHOLD = "IGNITE_CHECKPOINT_SYNC_FS_THRESHOLD";
    public static final boolean SYNC_FS_ENABLED = IgniteSystemProperties.getBoolean("IGNITE_CHECKPOINT_SYNC_FS_ENABLED", true);
    public static final int SYNC_FS_THRESHOLD = IgniteSystemProperties.getInteger("IGNITE_CHECKPOINT_SYNC_FS_THRESHOLD", 1024);

    public static void syncfs(ConcurrentMap<PageStore, CheckpointPagesWriter.CheckpointPageStoreInfo> updStores) throws IgniteCheckedException {
        Collection<Path> filesFromDifferentFileSystems = SyncFsUtils.findAllFileSystems(updStores);
        SyncFsUtils.syncFileSystems(filesFromDifferentFileSystems);
    }

    private static Collection<Path> findAllFileSystems(ConcurrentMap<PageStore, CheckpointPagesWriter.CheckpointPageStoreInfo> updStores) throws StorageException {
        IntHashMap<IgniteBiTuple> groupIdToFileStore = new IntHashMap<IgniteBiTuple>();
        for (Map.Entry entry : updStores.entrySet()) {
            CheckpointPagesWriter.CheckpointPageStoreInfo info = (CheckpointPagesWriter.CheckpointPageStoreInfo)entry.getValue();
            if (groupIdToFileStore.containsKey(info.groupId)) continue;
            Path path = ((FilePageStore)entry.getKey()).getPath();
            try {
                groupIdToFileStore.put(info.groupId, new IgniteBiTuple<Path, FileStore>(path, Files.getFileStore(path)));
            }
            catch (IOException e) {
                throw new StorageException(e);
            }
        }
        HashMap fileSystems = new HashMap();
        groupIdToFileStore.forEach((key, val) -> {
            Path cfr_ignored_0 = (Path)fileSystems.putIfAbsent(((FileStore)val.getValue()).name(), val.getKey());
        });
        return fileSystems.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncFileSystems(Collection<Path> filesFromDifferentFileSystems) throws IgniteCheckedException {
        for (Path path : filesFromDifferentFileSystems) {
            ArrayList<String> messages;
            IgniteCheckedException igniteException;
            int closeErr;
            int fd = SyncFsLibC.open(path.toAbsolutePath().toString(), 0, 0);
            int syncFsErr = 0;
            Throwable error = null;
            try {
                if (SyncFsLibC.syncfs(fd) != 0) {
                    syncFsErr = Native.getLastError();
                }
                closeErr = 0;
            }
            catch (Error | RuntimeException e) {
                try {
                    error = e;
                    closeErr = 0;
                }
                catch (Throwable throwable) {
                    int closeErr2 = 0;
                    if (SyncFsLibC.close(fd) != 0) {
                        closeErr2 = Native.getLastError();
                    }
                    IgniteCheckedException igniteException2 = null;
                    if (closeErr2 != 0 || syncFsErr != 0) {
                        ArrayList<String> messages2 = new ArrayList<String>(2);
                        if (syncFsErr != 0) {
                            messages2.add(SyncFsLibC.strerror(syncFsErr));
                        }
                        if (closeErr2 != 0) {
                            messages2.add(SyncFsLibC.strerror(closeErr2));
                        }
                        igniteException2 = new IgniteCheckedException("Failed to execute syncfs: " + messages2);
                    }
                    if (error != null) {
                        if (igniteException2 != null) {
                            error.addSuppressed(igniteException2);
                        }
                        if (error instanceof RuntimeException) {
                            throw (RuntimeException)error;
                        }
                        throw (Error)error;
                    }
                    if (igniteException2 != null) {
                        throw igniteException2;
                    }
                    throw throwable;
                }
                if (SyncFsLibC.close(fd) != 0) {
                    closeErr = Native.getLastError();
                }
                igniteException = null;
                if (closeErr != 0 || syncFsErr != 0) {
                    messages = new ArrayList(2);
                    if (syncFsErr != 0) {
                        messages.add(SyncFsLibC.strerror(syncFsErr));
                    }
                    if (closeErr != 0) {
                        messages.add(SyncFsLibC.strerror(closeErr));
                    }
                    igniteException = new IgniteCheckedException("Failed to execute syncfs: " + messages);
                }
                if (error != null) {
                    if (igniteException != null) {
                        error.addSuppressed(igniteException);
                    }
                    if (error instanceof RuntimeException) {
                        throw (RuntimeException)error;
                    }
                    throw (Error)error;
                }
                if (igniteException == null) continue;
                throw igniteException;
            }
            if (SyncFsLibC.close(fd) != 0) {
                closeErr = Native.getLastError();
            }
            igniteException = null;
            if (closeErr != 0 || syncFsErr != 0) {
                messages = new ArrayList<String>(2);
                if (syncFsErr != 0) {
                    messages.add(SyncFsLibC.strerror(syncFsErr));
                }
                if (closeErr != 0) {
                    messages.add(SyncFsLibC.strerror(closeErr));
                }
                igniteException = new IgniteCheckedException("Failed to execute syncfs: " + messages);
            }
            if (error != null) {
                if (igniteException != null) {
                    error.addSuppressed(igniteException);
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw (Error)error;
            }
            if (igniteException == null) continue;
            throw igniteException;
        }
    }

    public static boolean isActive() {
        return SYNC_FS_ENABLED && SyncFsLibC.JNA_AVAILABLE;
    }

    public static void logStartup(IgniteLogger log) {
        if (SYNC_FS_ENABLED) {
            if (SyncFsUtils.isActive()) {
                log.info("syncfs is enabled with a threshold of " + SYNC_FS_THRESHOLD + " files.");
            } else {
                log.warning("syncfs checkpoint optimization is enabled, but not supported by the OS.");
            }
            if (SyncFsLibC.ERROR != null) {
                log.error("Exception while loading native library for syncfs", SyncFsLibC.ERROR);
            }
        }
    }
}

