/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.processors.cache.persistence.CheckCorruptedCacheStoresCleanAction;
import org.apache.ignite.internal.processors.cache.persistence.CleanCacheStoresMaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceAction;
import org.apache.ignite.maintenance.MaintenanceWorkflowCallback;
import org.jetbrains.annotations.NotNull;

public class CorruptedPdsMaintenanceCallback
implements MaintenanceWorkflowCallback {
    private final File workDir;
    private final List<String> cacheStoreDirs;

    public CorruptedPdsMaintenanceCallback(@NotNull File workDir, @NotNull List<String> cacheStoreDirs) {
        this.workDir = workDir;
        this.cacheStoreDirs = cacheStoreDirs;
    }

    @Override
    public boolean shouldProceedWithMaintenance() {
        for (String cacheStoreDirName : this.cacheStoreDirs) {
            File cacheStoreDir = new File(this.workDir, cacheStoreDirName);
            if (!cacheStoreDir.exists() || !cacheStoreDir.isDirectory() || cacheStoreDir.listFiles().length <= 0) continue;
            for (File f : cacheStoreDir.listFiles()) {
                if (f.getName().equals("cache_data.dat")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<MaintenanceAction<?>> allActions() {
        return Arrays.asList(new CleanCacheStoresMaintenanceAction(this.workDir, this.cacheStoreDirs.toArray(new String[0])), new CheckCorruptedCacheStoresCleanAction(this.workDir, this.cacheStoreDirs.toArray(new String[0])));
    }

    @Override
    public MaintenanceAction<?> automaticAction() {
        return null;
    }
}

