/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.internal.processors.cache.GridCacheFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public abstract class GridCacheFutureAdapter<R>
extends GridFutureAdapter<R>
implements GridCacheFuture<R> {
    private final long startTime = U.currentTimeMillis();
    private volatile long endTime;

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long duration() {
        long endTime = this.endTime;
        return endTime == 0L ? U.currentTimeMillis() - this.startTime : endTime - this.startTime;
    }

    @Override
    protected boolean onDone(@Nullable R res, @Nullable Throwable err, boolean cancel) {
        if (super.onDone(res, err, cancel)) {
            this.endTime = U.currentTimeMillis();
            return true;
        }
        return false;
    }
}

