/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectAdapter;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class CacheObjectShadow
extends CacheObjectAdapter {
    private static final long serialVersionUID = 0L;
    private byte type;
    private int valSize;

    public CacheObjectShadow() {
        this.valBytes = IgniteUtils.EMPTY_BYTES;
    }

    public CacheObjectShadow(byte type, int size) {
        this.type = type;
        this.valBytes = IgniteUtils.EMPTY_BYTES;
        this.valSize = size;
    }

    @Override
    public byte cacheObjectType() {
        return this.type;
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy) {
        throw new UnsupportedOperationException("Incomplete cache object shadow does not support materialization.");
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy, ClassLoader ldr) {
        throw new UnsupportedOperationException("Incomplete cache object shadow does not support materialization.");
    }

    @Override
    public byte[] valueBytes(CacheObjectValueContext ctx) throws IgniteCheckedException {
        return IgniteUtils.EMPTY_BYTES;
    }

    @Override
    public int valueBytesOriginLength(CacheObjectValueContext ctx) throws IgniteCheckedException {
        return this.valSize;
    }

    @Override
    public int valueBytesLength(CacheObjectContext ctx) throws IgniteCheckedException {
        return CacheObjectShadow.objectPutSize(this.valSize);
    }

    @Override
    public boolean isPlatformType() {
        return true;
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx, boolean compress) throws IgniteCheckedException {
        throw new UnsupportedOperationException("Incomplete cache object shadow does not support materialization.");
    }

    @Override
    public void finishUnmarshal(CacheObjectValueContext ctx, ClassLoader ldr) throws IgniteCheckedException {
    }

    @Override
    public void prepareMarshal(CacheObjectValueContext ctx) throws IgniteCheckedException {
    }

    @Override
    public short directType() {
        return -1;
    }

    @Override
    public void onAckReceived() {
    }
}

