/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers.systemview;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.managers.systemview.AbstractSystemView;
import org.apache.ignite.internal.managers.systemview.walker.ScanQueryViewWalker;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryManager;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.spi.IgniteSpiCloseableIterator;
import org.apache.ignite.spi.systemview.view.ScanQueryView;
import org.jetbrains.annotations.NotNull;

public class ScanQuerySystemView<K, V>
extends AbstractSystemView<ScanQueryView> {
    public static final String SCAN_QRY_SYS_VIEW = MetricUtils.metricName("scan", "queries");
    public static final String SCAN_QRY_SYS_VIEW_DESC = "Scan queries";
    private final Collection<GridCacheContext<K, V>> cctxs;

    public ScanQuerySystemView(Collection<GridCacheContext<K, V>> cctxs) {
        super(SCAN_QRY_SYS_VIEW, SCAN_QRY_SYS_VIEW_DESC, new ScanQueryViewWalker());
        this.cctxs = cctxs;
    }

    @Override
    public int size() {
        int sz = 0;
        QueryDataIterator iter = new QueryDataIterator();
        while (iter.hasNext()) {
            ++sz;
        }
        return sz;
    }

    @Override
    @NotNull
    public Iterator<ScanQueryView> iterator() {
        return new QueryDataIterator();
    }

    private class QueryDataIterator
    implements Iterator<ScanQueryView> {
        private final Iterator<GridCacheContext<K, V>> cctxsIter;
        private GridCacheContext<K, V> cctx;
        private Iterator<Map.Entry<UUID, GridCacheQueryManager.RequestFutureMap>> nodeQryIter;
        private Iterator<GridCacheQueryManager.ScanQueryIterator> localQryIter;
        private UUID nodeId;
        private GridCacheQueryManager.RequestFutureMap reqMap;
        private Iterator<Map.Entry<Long, GridFutureAdapter<GridCacheQueryManager.QueryResult<K, V>>>> qriesIter;
        private long qryId;
        private IgniteSpiCloseableIterator<IgniteBiTuple<K, V>> qry;
        private boolean hasNextExec;

        public QueryDataIterator() {
            this.cctxsIter = ScanQuerySystemView.this.cctxs.iterator();
            this.nodeQryIter = Collections.emptyIterator();
            this.qriesIter = Collections.emptyIterator();
            this.localQryIter = Collections.emptyIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            this.hasNextExec = true;
            while (!this.nextScanIter()) {
                while (!this.nodeQryIter.hasNext() && !this.localQryIter.hasNext()) {
                    if (!this.cctxsIter.hasNext()) {
                        return false;
                    }
                    this.cctx = this.cctxsIter.next();
                    GridCacheQueryManager qryMgr = this.cctx.queries();
                    this.nodeQryIter = qryMgr.queryIterators().entrySet().iterator();
                    this.localQryIter = qryMgr.localQueryIterators().iterator();
                }
                if (this.nodeQryIter.hasNext()) {
                    LinkedHashSet cpOfEntries;
                    Map.Entry<UUID, GridCacheQueryManager.RequestFutureMap> next = this.nodeQryIter.next();
                    this.nodeId = next.getKey();
                    GridCacheQueryManager.RequestFutureMap requestFutureMap = this.reqMap = next.getValue();
                    synchronized (requestFutureMap) {
                        cpOfEntries = new LinkedHashSet(this.reqMap.entrySet());
                    }
                    this.qriesIter = cpOfEntries.iterator();
                    continue;
                }
                this.nodeId = this.cctx.localNodeId();
                this.reqMap = null;
                this.qriesIter = null;
            }
            return true;
        }

        @Override
        public ScanQueryView next() {
            if (!this.hasNextExec && !this.hasNext()) {
                throw new NoSuchElementException("No more elements.");
            }
            this.hasNextExec = false;
            return new ScanQueryView(this.nodeId, this.qryId, this.reqMap != null && this.reqMap.isCanceled(this.qryId), this.qry);
        }

        private boolean nextScanIter() {
            try {
                while (this.qriesIter != null && this.qriesIter.hasNext()) {
                    Map.Entry qryRes = this.qriesIter.next();
                    if (!qryRes.getValue().isDone() || qryRes.getValue().get().type() != GridCacheQueryType.SCAN) continue;
                    this.qryId = qryRes.getKey();
                    this.qry = (IgniteSpiCloseableIterator)qryRes.getValue().get().get();
                    return true;
                }
                this.qriesIter = null;
                this.reqMap = null;
                if (!this.localQryIter.hasNext()) {
                    return false;
                }
                this.qryId = 0L;
                this.qry = this.localQryIter.next();
                this.nodeId = this.cctx.localNodeId();
                return true;
            }
            catch (IgniteCheckedException e) {
                throw new IgniteException(e);
            }
        }
    }
}

