/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import org.apache.ignite.IgniteException;
import org.apache.ignite.client.ClientAtomicSequence;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.internal.client.thin.AbstractClientAtomic;
import org.apache.ignite.internal.client.thin.ClientOperation;
import org.apache.ignite.internal.client.thin.ClientServerError;
import org.apache.ignite.internal.client.thin.PayloadOutputChannel;
import org.apache.ignite.internal.client.thin.ReliableChannel;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

class ClientAtomicSequenceImpl
extends AbstractClientAtomic
implements ClientAtomicSequence {
    @GridToStringInclude(sensitive=true)
    private volatile long locVal;
    @GridToStringExclude
    private long upBound;
    private volatile int batchSize;
    private volatile boolean rmvd;

    public ClientAtomicSequenceImpl(String name, @Nullable String groupName, int batchSize, ReliableChannel ch) {
        super(name, groupName, ch);
        this.batchSize = batchSize;
        this.upBound = this.locVal = ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_SEQUENCE_VALUE_GET, this::writeName, in -> in.in().readLong()).longValue();
    }

    @Override
    public long get() throws IgniteException {
        this.checkRemoved();
        return this.locVal;
    }

    @Override
    public long incrementAndGet() throws IgniteException {
        return this.internalUpdate(1L, true);
    }

    @Override
    public long getAndIncrement() throws IgniteException {
        return this.internalUpdate(1L, false);
    }

    @Override
    public long addAndGet(long l) throws IgniteException {
        A.ensure(l > 0L, " Parameter can't be less then 1: " + l);
        return this.internalUpdate(l, true);
    }

    @Override
    public long getAndAdd(long l) throws IgniteException {
        A.ensure(l > 0L, " Parameter can't be less then 1: " + l);
        return this.internalUpdate(l, false);
    }

    @Override
    public int batchSize() {
        return this.batchSize;
    }

    @Override
    public synchronized void batchSize(int size) {
        A.ensure(size > 0, " Batch size can't be less then 0: " + size);
        this.batchSize = size;
    }

    @Override
    public boolean removed() {
        boolean exists = this.ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_SEQUENCE_EXISTS, this::writeName, in -> in.in().readBoolean());
        this.rmvd = !exists;
        return !exists;
    }

    @Override
    public void close() {
        this.ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_SEQUENCE_REMOVE, this::writeName, null);
        this.rmvd = true;
    }

    @Override
    public String toString() {
        return S.toString(ClientAtomicSequenceImpl.class, this, super.toString());
    }

    private synchronized long internalUpdate(long l, boolean updated) {
        assert (l > 0L) : "l > 0";
        this.checkRemoved();
        long locVal0 = this.locVal;
        long newLocVal = locVal0 + l;
        if (newLocVal <= this.upBound) {
            this.locVal = newLocVal;
            return updated ? newLocVal : locVal0;
        }
        long remainingOldRange = this.upBound - locVal0;
        long newRangeOffset = (long)this.batchSize + l - remainingOldRange;
        long globalVal = this.remoteAddAndGet(newRangeOffset);
        long oldGlobalVal = globalVal - newRangeOffset;
        this.locVal = globalVal - (long)this.batchSize;
        this.upBound = globalVal - 1L;
        if (oldGlobalVal > locVal0) {
            --this.locVal;
        }
        return updated ? this.locVal : locVal0;
    }

    private long remoteAddAndGet(long l) {
        try {
            return this.ch.affinityService(this.cacheId, this.affinityKey(), ClientOperation.ATOMIC_SEQUENCE_VALUE_ADD_AND_GET, out -> {
                this.writeName((PayloadOutputChannel)out);
                out.out().writeLong(l);
            }, r -> r.in().readLong());
        }
        catch (ClientException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClientServerError && ((ClientServerError)cause).getCode() == 1011) {
                this.rmvd = true;
            }
            throw e;
        }
    }

    private void checkRemoved() {
        if (this.rmvd) {
            throw new IgniteException("Sequence was removed from cache: " + this.name);
        }
    }
}

