/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class SqlFieldsQuery
extends Query<List<?>> {
    private static final long serialVersionUID = 0L;
    private static final int DFLT_UPDATE_BATCH_SIZE = 1;
    private static ThreadLocal<String> threadedQryInitiatorId = new ThreadLocal();
    private static final int DFLT_QUERY_TIMEOUT = -1;
    public static boolean DFLT_LAZY = true;
    private String sql;
    @GridToStringInclude
    private Object[] args;
    private boolean collocated;
    private int timeout = -1;
    private boolean enforceJoinOrder;
    private boolean distributedJoins;
    private boolean replicatedOnly;
    private boolean lazy = DFLT_LAZY;
    private int[] parts;
    private String schema;
    private int updateBatchSize = 1;
    private String qryInitiatorId;
    private boolean skipReducerOnUpdate;
    @Nullable
    private String label;

    public SqlFieldsQuery(SqlFieldsQuery qry) {
        this.sql = qry.sql;
        this.args = qry.args;
        this.collocated = qry.collocated;
        this.timeout = qry.timeout;
        this.enforceJoinOrder = qry.enforceJoinOrder;
        this.distributedJoins = qry.distributedJoins;
        this.replicatedOnly = qry.replicatedOnly;
        this.lazy = qry.lazy;
        this.parts = qry.parts;
        this.schema = qry.schema;
        this.updateBatchSize = qry.updateBatchSize;
        this.qryInitiatorId = qry.qryInitiatorId;
        this.skipReducerOnUpdate = qry.skipReducerOnUpdate;
        this.label = qry.label;
    }

    public SqlFieldsQuery(String sql) {
        this.setSql(sql);
    }

    public SqlFieldsQuery(String sql, boolean collocated) {
        this.sql = sql;
        this.collocated = collocated;
    }

    public String getSql() {
        return this.sql;
    }

    public SqlFieldsQuery setSql(String sql) {
        A.notNull(sql, "sql");
        this.sql = sql;
        return this;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public SqlFieldsQuery setArgs(Object ... args) {
        this.args = args;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public SqlFieldsQuery setTimeout(int timeout, TimeUnit timeUnit) {
        this.timeout = QueryUtils.validateTimeout(timeout, timeUnit);
        return this;
    }

    public SqlFieldsQuery setSkipReducerOnUpdate(boolean skipReducerOnUpdate) {
        this.skipReducerOnUpdate = skipReducerOnUpdate;
        return this;
    }

    public boolean isSkipReducerOnUpdate() {
        return this.skipReducerOnUpdate;
    }

    public boolean isCollocated() {
        return this.collocated;
    }

    public SqlFieldsQuery setCollocated(boolean collocated) {
        this.collocated = collocated;
        return this;
    }

    public boolean isEnforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    public SqlFieldsQuery setEnforceJoinOrder(boolean enforceJoinOrder) {
        this.enforceJoinOrder = enforceJoinOrder;
        return this;
    }

    public SqlFieldsQuery setDistributedJoins(boolean distributedJoins) {
        this.distributedJoins = distributedJoins;
        return this;
    }

    public boolean isDistributedJoins() {
        return this.distributedJoins;
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    public SqlFieldsQuery setLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    public SqlFieldsQuery setPageSize(int pageSize) {
        return (SqlFieldsQuery)super.setPageSize(pageSize);
    }

    public SqlFieldsQuery setLocal(boolean loc) {
        return (SqlFieldsQuery)super.setLocal(loc);
    }

    @Deprecated
    public SqlFieldsQuery setReplicatedOnly(boolean replicatedOnly) {
        this.replicatedOnly = replicatedOnly;
        return this;
    }

    @Deprecated
    public boolean isReplicatedOnly() {
        return this.replicatedOnly;
    }

    public SqlFieldsQuery setLazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public int[] getPartitions() {
        return this.parts;
    }

    public SqlFieldsQuery setPartitions(int ... parts) {
        this.parts = this.prepare(parts);
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public SqlFieldsQuery setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public int getUpdateBatchSize() {
        return this.updateBatchSize;
    }

    public SqlFieldsQuery setUpdateBatchSize(int updateBatchSize) {
        A.ensure(updateBatchSize >= 1, "updateBatchSize cannot be lower than 1");
        this.updateBatchSize = updateBatchSize;
        return this;
    }

    public String getQueryInitiatorId() {
        return this.qryInitiatorId;
    }

    public SqlFieldsQuery setQueryInitiatorId(String qryInitiatorId) {
        this.qryInitiatorId = qryInitiatorId;
        return this;
    }

    public SqlFieldsQuery copy() {
        return new SqlFieldsQuery(this);
    }

    public static void setThreadedQueryInitiatorId(String originator) {
        threadedQryInitiatorId.set(originator);
    }

    public static void resetThreadedQueryInitiatorId() {
        threadedQryInitiatorId.remove();
    }

    public static String threadedQueryInitiatorId() {
        return threadedQryInitiatorId.get();
    }

    @Override
    public String toString() {
        return S.toString(SqlFieldsQuery.class, this);
    }
}

