/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;

public class ValueInt
extends Value {
    public static final int PRECISION = 10;
    public static final int DISPLAY_SIZE = 11;
    private static final int STATIC_SIZE = 128;
    private static final int DYNAMIC_SIZE = 256;
    private static final ValueInt[] STATIC_CACHE = new ValueInt[128];
    private static final ValueInt[] DYNAMIC_CACHE = new ValueInt[256];
    private final int value;

    private ValueInt(int value) {
        this.value = value;
    }

    public static ValueInt get(int i) {
        if (i >= 0 && i < 128) {
            return STATIC_CACHE[i];
        }
        ValueInt v = DYNAMIC_CACHE[i & 0xFF];
        if (v == null || v.value != i) {
            ValueInt.DYNAMIC_CACHE[i & 0xFF] = v = new ValueInt(i);
        }
        return v;
    }

    @Override
    public int getMemory() {
        if (this.value >= 0 && this.value < 128) {
            return 0;
        }
        return super.getMemory();
    }

    @Override
    public Value add(Value v) {
        ValueInt other = (ValueInt)v;
        return ValueInt.checkRange((long)this.value + (long)other.value);
    }

    private static ValueInt checkRange(long x) {
        if ((long)((int)x) != x) {
            throw DbException.get(22003, Long.toString(x));
        }
        return ValueInt.get((int)x);
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.value);
    }

    @Override
    public Value negate() {
        return ValueInt.checkRange(-((long)this.value));
    }

    @Override
    public Value subtract(Value v) {
        ValueInt other = (ValueInt)v;
        return ValueInt.checkRange((long)this.value - (long)other.value);
    }

    @Override
    public Value multiply(Value v) {
        ValueInt other = (ValueInt)v;
        return ValueInt.checkRange((long)this.value * (long)other.value);
    }

    @Override
    public Value divide(Value v) {
        int y = ((ValueInt)v).value;
        if (y == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        int x = this.value;
        if (x == Integer.MIN_VALUE && y == -1) {
            throw DbException.get(22003, "2147483648");
        }
        return ValueInt.get(x / y);
    }

    @Override
    public Value modulus(Value v) {
        ValueInt other = (ValueInt)v;
        if (other.value == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        return ValueInt.get(this.value % other.value);
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        return builder.append(this.value);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_INT;
    }

    @Override
    public int getValueType() {
        return 4;
    }

    @Override
    public int getInt() {
        return this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public int compareTypeSafe(Value o, CompareMode mode) {
        return Integer.compare(this.value, ((ValueInt)o).value);
    }

    @Override
    public String getString() {
        return Integer.toString(this.value);
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    @Override
    public Object getObject() {
        return this.value;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setInt(parameterIndex, this.value);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueInt && this.value == ((ValueInt)other).value;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            ValueInt.STATIC_CACHE[i] = new ValueInt(i);
        }
    }
}

