/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.internal.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.gridgain.internal.h2.engine.Mode;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.util.Bits;
import org.gridgain.internal.h2.util.StringUtils;
import org.gridgain.internal.h2.util.Utils;
import org.gridgain.internal.h2.util.geometry.EWKBUtils;
import org.gridgain.internal.h2.util.geometry.EWKTUtils;
import org.gridgain.internal.h2.util.geometry.GeometryUtils;
import org.gridgain.internal.h2.util.geometry.JTSUtils;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.DataType;
import org.gridgain.internal.h2.value.ExtTypeInfo;
import org.gridgain.internal.h2.value.TypeInfo;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;
import org.locationtech.jts.geom.Geometry;

public class ValueGeometry
extends Value {
    private static final double[] UNKNOWN_ENVELOPE = new double[0];
    private final byte[] bytes;
    private final int hashCode;
    private final int typeAndDimensionSystem;
    private final int srid;
    private double[] envelope;
    private Object geometry;

    private ValueGeometry(byte[] bytes, double[] envelope) {
        if (bytes.length < 9 || bytes[0] != 0) {
            throw DbException.get(22018, StringUtils.convertBytesToHex(bytes));
        }
        this.bytes = bytes;
        this.envelope = envelope;
        int t = Bits.readInt(bytes, 1);
        this.srid = (t & 0x20000000) != 0 ? Bits.readInt(bytes, 5) : 0;
        this.typeAndDimensionSystem = (t & 0xFFFF) % 1000 + EWKBUtils.type2dimensionSystem(t) * 1000;
        this.hashCode = Arrays.hashCode(bytes);
    }

    public static ValueGeometry getFromGeometry(Object o) {
        try {
            GeometryUtils.EnvelopeAndDimensionSystemTarget target = new GeometryUtils.EnvelopeAndDimensionSystemTarget();
            Geometry g = (Geometry)o;
            JTSUtils.parseGeometry(g, target);
            return (ValueGeometry)ValueGeometry.cache(new ValueGeometry(JTSUtils.geometry2ewkb(g, target.getDimensionSystem()), target.getEnvelope()));
        }
        catch (RuntimeException ex) {
            throw DbException.get(22018, String.valueOf(o));
        }
    }

    public static ValueGeometry get(String s) {
        try {
            GeometryUtils.EnvelopeAndDimensionSystemTarget target = new GeometryUtils.EnvelopeAndDimensionSystemTarget();
            EWKTUtils.parseEWKT(s, target);
            return (ValueGeometry)ValueGeometry.cache(new ValueGeometry(EWKTUtils.ewkt2ewkb(s, target.getDimensionSystem()), target.getEnvelope()));
        }
        catch (RuntimeException ex) {
            throw DbException.get(22018, s);
        }
    }

    public static ValueGeometry get(String s, int srid) {
        return ValueGeometry.get(srid == 0 ? s : "SRID=" + srid + ';' + s);
    }

    public static ValueGeometry get(byte[] bytes) {
        return (ValueGeometry)ValueGeometry.cache(new ValueGeometry(bytes, UNKNOWN_ENVELOPE));
    }

    public static ValueGeometry getFromEWKB(byte[] bytes) {
        try {
            GeometryUtils.EnvelopeAndDimensionSystemTarget target = new GeometryUtils.EnvelopeAndDimensionSystemTarget();
            EWKBUtils.parseEWKB(bytes, target);
            return (ValueGeometry)ValueGeometry.cache(new ValueGeometry(EWKBUtils.ewkb2ewkb(bytes, target.getDimensionSystem()), target.getEnvelope()));
        }
        catch (RuntimeException ex) {
            throw DbException.get(22018, StringUtils.convertBytesToHex(bytes));
        }
    }

    public static Value fromEnvelope(double[] envelope) {
        return envelope != null ? ValueGeometry.cache(new ValueGeometry(EWKBUtils.envelope2wkb(envelope), envelope)) : ValueNull.INSTANCE;
    }

    public Geometry getGeometry() {
        if (this.geometry == null) {
            try {
                this.geometry = JTSUtils.ewkb2geometry(this.bytes, this.getDimensionSystem());
            }
            catch (RuntimeException ex) {
                throw DbException.convert(ex);
            }
        }
        return ((Geometry)this.geometry).copy();
    }

    public int getTypeAndDimensionSystem() {
        return this.typeAndDimensionSystem;
    }

    public int getGeometryType() {
        return this.typeAndDimensionSystem % 1000;
    }

    public int getDimensionSystem() {
        return this.typeAndDimensionSystem / 1000;
    }

    public int getSRID() {
        return this.srid;
    }

    public double[] getEnvelopeNoCopy() {
        if (this.envelope == UNKNOWN_ENVELOPE) {
            GeometryUtils.EnvelopeTarget target = new GeometryUtils.EnvelopeTarget();
            EWKBUtils.parseEWKB(this.bytes, target);
            this.envelope = target.getEnvelope();
        }
        return this.envelope;
    }

    public boolean intersectsBoundingBox(ValueGeometry r) {
        return GeometryUtils.intersects(this.getEnvelopeNoCopy(), r.getEnvelopeNoCopy());
    }

    public Value getEnvelopeUnion(ValueGeometry r) {
        return ValueGeometry.fromEnvelope(GeometryUtils.union(this.getEnvelopeNoCopy(), r.getEnvelopeNoCopy()));
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_GEOMETRY;
    }

    @Override
    public int getValueType() {
        return 22;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder) {
        builder.append("X'");
        return StringUtils.convertBytesToHex(builder, this.getBytesNoCopy()).append("'::Geometry");
    }

    @Override
    public int compareTypeSafe(Value v, CompareMode mode) {
        return Bits.compareNotNullUnsigned(this.bytes, ((ValueGeometry)v).bytes);
    }

    @Override
    public String getString() {
        return this.getEWKT();
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Object getObject() {
        if (DataType.GEOMETRY_CLASS != null) {
            return this.getGeometry();
        }
        return this.getEWKT();
    }

    @Override
    public byte[] getBytes() {
        return Utils.cloneByteArray(this.bytes);
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.bytes;
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBytes(parameterIndex, this.bytes);
    }

    @Override
    public int getMemory() {
        return this.bytes.length * 20 + 24;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ValueGeometry && Arrays.equals(this.bytes, ((ValueGeometry)other).bytes);
    }

    public String getEWKT() {
        return EWKTUtils.ewkb2ewkt(this.bytes, this.getDimensionSystem());
    }

    public byte[] getEWKB() {
        return this.bytes;
    }

    @Override
    protected Value convertTo(int targetType, Mode mode, Object column, ExtTypeInfo extTypeInfo) {
        if (targetType == 22) {
            return extTypeInfo != null ? extTypeInfo.cast(this) : this;
        }
        if (targetType == 19) {
            return this;
        }
        return super.convertTo(targetType, mode, column, null);
    }
}

